/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.expr.ClassPathClassResolver;
import org.teavm.flavour.expr.Compiler;
import org.teavm.flavour.expr.Evaluator;
import org.teavm.flavour.expr.EvaluatorBuilder;
import org.teavm.flavour.expr.ImportingClassResolver;
import org.teavm.flavour.expr.Interpreter;
import org.teavm.flavour.expr.InvalidExpressionException;
import org.teavm.flavour.expr.Parser;
import org.teavm.flavour.expr.Scope;
import org.teavm.flavour.expr.TypedPlan;
import org.teavm.flavour.expr.VariableName;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriberRepository;

public class InterpretingEvaluatorBuilder
implements EvaluatorBuilder {
    private ImportingClassResolver classResolver = new ImportingClassResolver(new ClassPathClassResolver(ClassLoader.getSystemClassLoader()));

    public InterpretingEvaluatorBuilder importClass(String name) {
        this.classResolver.importClass(name);
        return this;
    }

    public InterpretingEvaluatorBuilder importPackage(String name) {
        this.classResolver.importPackage(name);
        return this;
    }

    @Override
    public <F, V> Evaluator<F, V> build(Class<F> functionType, Class<V> variablesType, String exprString) {
        if (!functionType.isInterface()) {
            throw new IllegalArgumentException("Function type must be an interface");
        }
        Method[] functionMethods = functionType.getDeclaredMethods();
        if (functionMethods.length != 1) {
            throw new IllegalArgumentException("Function type must have exactly one method");
        }
        if (!variablesType.isInterface()) {
            throw new IllegalArgumentException("Variables type must be an interface");
        }
        Method[] variableMethods = variablesType.getDeclaredMethods();
        HashMap<String, Type> variableTypes = new HashMap<String, Type>();
        HashMap<Method, String> methodToVariableMap = new HashMap<Method, String>();
        for (Method method : variableMethods) {
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new IllegalArgumentException("Method " + method + " does not return void");
            }
            Type[] parameters = method.getGenericParameterTypes();
            if (parameters.length != 1) {
                throw new IllegalArgumentException("Method " + method + " does not take one parameter");
            }
            String variableName = method.getName();
            if (method.isAnnotationPresent(VariableName.class)) {
                variableName = method.getAnnotation(VariableName.class).value();
            }
            methodToVariableMap.put(method, variableName);
            variableTypes.put(variableName, parameters[0]);
        }
        Parser parser = new Parser(this.classResolver);
        Expr expr = parser.parse(exprString);
        if (!parser.getDiagnostics().isEmpty()) {
            throw new InvalidExpressionException(parser.getDiagnostics());
        }
        ClassPathClassDescriberRepository classes = new ClassPathClassDescriberRepository();
        Compiler compiler = new Compiler(classes, this.classResolver, new ScopeImpl(classes, variableTypes));
        Type returnType = functionMethods[0].getGenericReturnType();
        TypedPlan typedPlan = compiler.compile(expr, classes.convertGenericType(returnType));
        if (!compiler.wasSuccessful()) {
            throw new InvalidExpressionException(compiler.getDiagnostics());
        }
        Interpreter interpreter = new Interpreter(typedPlan.getPlan());
        Object function = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{functionType}, (InvocationHandler)new FunctionProxy(interpreter));
        Object variables = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{variablesType}, (InvocationHandler)new VariablesProxy(interpreter, methodToVariableMap));
        return new Evaluator<Object, Object>(function, variables);
    }

    class VariablesProxy
    implements InvocationHandler {
        private Interpreter interpreter;
        private Map<Method, String> variables;

        VariablesProxy(Interpreter interpreter, Map<Method, String> variables) {
            this.interpreter = interpreter;
            this.variables = variables;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String varName = this.variables.get(method);
            this.interpreter.getVariables().put(varName, args[0]);
            return null;
        }
    }

    class FunctionProxy
    implements InvocationHandler {
        private Interpreter interpreter;

        FunctionProxy(Interpreter interpreter) {
            this.interpreter = interpreter;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.interpreter.interpret();
        }
    }

    class ScopeImpl
    implements Scope {
        private ClassPathClassDescriberRepository classes;
        private Map<String, Type> variables;

        ScopeImpl(ClassPathClassDescriberRepository classes, Map<String, Type> variables) {
            this.classes = classes;
            this.variables = variables;
        }

        @Override
        public ValueType variableType(String variableName) {
            Type type = this.variables.get(variableName);
            return type != null ? this.classes.convertGenericType(type) : null;
        }
    }
}

