/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.flavour.expr.Diagnostic;

public class InvalidExpressionException
extends RuntimeException {
    private static final long serialVersionUID = -1385228947330502798L;
    private final List<Diagnostic> diagnostics;

    public InvalidExpressionException(List<Diagnostic> diagnostics) {
        super(InvalidExpressionException.createMessage(diagnostics));
        this.diagnostics = Collections.unmodifiableList(new ArrayList<Diagnostic>(diagnostics));
    }

    private static String createMessage(List<Diagnostic> diagnostics) {
        StringBuilder sb = new StringBuilder();
        sb.append("Errors occurred compiling expression:");
        for (Diagnostic diagnostic : diagnostics) {
            sb.append("\n  at (" + diagnostic.getStart() + "; " + diagnostic.getEnd() + "): ").append(diagnostic.getMessage());
        }
        return sb.toString();
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

