/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.teavm.flavour.expr.ClassResolver;
import org.teavm.flavour.expr.CompilerCommons;
import org.teavm.flavour.expr.Scope;
import org.teavm.flavour.expr.TypeEstimator;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.type.GenericArray;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.MethodWithFreshTypeVars;
import org.teavm.flavour.expr.type.PrimitiveArray;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeInference;
import org.teavm.flavour.expr.type.TypeInferenceStatePoint;
import org.teavm.flavour.expr.type.TypeUtils;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.MethodDescriber;

public class MethodLookup {
    private TypeInference inference;
    private GenericTypeNavigator navigator;
    private TypeEstimator typeEstimator;
    private List<GenericMethod> candidates = new ArrayList<GenericMethod>();
    private List<GenericMethod> safeCandidates = Collections.unmodifiableList(this.candidates);
    private boolean varArgs;
    private ValueType returnType;

    public MethodLookup(TypeInference inference, ClassResolver classResolver, GenericTypeNavigator navigator, Scope scope) {
        this.inference = inference;
        this.navigator = navigator;
        this.typeEstimator = new TypeEstimator(inference, classResolver, navigator, scope);
    }

    public GenericMethod lookupVirtual(Collection<GenericClass> classes, String name, List<Expr> args) {
        return this.lookupMethod(classes, name, args, false);
    }

    public GenericMethod lookupStatic(Collection<GenericClass> classes, String name, List<Expr> args) {
        return this.lookupMethod(classes, name, args, true);
    }

    private GenericMethod lookupMethod(Collection<GenericClass> classes, String name, List<Expr> args, boolean isStatic) {
        this.varArgs = false;
        this.returnType = null;
        this.candidates.clear();
        this.candidates.addAll(this.findAllMethods(classes, name, isStatic));
        if (this.candidates.isEmpty()) {
            return null;
        }
        GenericMethod result = this.lookupMethodStrict(args);
        if (result != null) {
            return result;
        }
        result = this.lookupMethodCompatible(args);
        if (result != null) {
            return result;
        }
        result = this.lookupVarargMethod(args);
        if (result != null) {
            this.varArgs = true;
        }
        return result;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public List<GenericMethod> getCandidates() {
        return this.safeCandidates;
    }

    public ValueType getReturnType() {
        return this.returnType;
    }

    private GenericMethod lookupMethodStrict(List<Expr> args) {
        return this.lookup(params -> {
            if (((ValueType[])params).length != args.size()) {
                return false;
            }
            for (int i = 0; i < ((ValueType[])params).length; ++i) {
                ValueType argType;
                if (args.get(i) == null || (argType = this.typeEstimator.estimate((Expr)args.get(i), params[i])) == null || this.inference.equalConstraint(argType, params[i])) continue;
                return false;
            }
            return true;
        });
    }

    private GenericMethod lookupMethodCompatible(List<Expr> args) {
        return this.lookup(params -> {
            if (((ValueType[])params).length != args.size()) {
                return false;
            }
            for (int i = 0; i < ((ValueType[])params).length; ++i) {
                ValueType argType;
                if (args.get(i) == null || (argType = this.typeEstimator.estimate((Expr)args.get(i), params[i])) == null || this.inference.subtypeConstraint(argType, params[i])) continue;
                return false;
            }
            return true;
        });
    }

    private GenericMethod lookupVarargMethod(List<Expr> args) {
        return this.lookup(params -> {
            ValueType argType;
            int i;
            ValueType lastParam;
            if (((ValueType[])params).length == 0 || ((ValueType[])params).length > args.size() - 1) {
                return false;
            }
            ValueType lastParamType = params[((ValueType[])params).length - 1];
            if (lastParamType instanceof PrimitiveArray) {
                lastParam = ((PrimitiveArray)lastParamType).getElementType();
            } else if (lastParamType instanceof GenericArray) {
                lastParam = ((GenericArray)lastParamType).getElementType();
            } else {
                return false;
            }
            for (i = 0; i < ((ValueType[])params).length - 1; ++i) {
                if (args.get(i) == null || (argType = this.typeEstimator.estimate((Expr)args.get(i), params[i])) == null || this.inference.subtypeConstraint(argType, params[i])) continue;
                return false;
            }
            for (i = ((ValueType[])params).length - 1; i < args.size(); ++i) {
                argType = this.typeEstimator.estimate((Expr)args.get(i), lastParam);
                if (argType == null || this.inference.subtypeConstraint(argType, lastParam)) continue;
                return false;
            }
            return true;
        });
    }

    private GenericMethod lookup(Function<ValueType[], Boolean> constraintSupplier) {
        GenericMethod result = null;
        GenericMethod resultWithFixedVars = null;
        TypeVar[] bestMatchingTypeVars = null;
        TypeInferenceStatePoint statePoint = this.inference.createStatePoint();
        for (GenericMethod method : this.candidates) {
            ValueType[] paramTypes;
            statePoint.restoreTo();
            MethodWithFreshTypeVars methodWithFreshTypeVars = TypeUtils.withFreshTypeVars(method, this.inference);
            if (methodWithFreshTypeVars == null || !constraintSupplier.apply(paramTypes = (method = methodWithFreshTypeVars.getMethod()).getActualParameterTypes()).booleanValue() || !this.inference.resolve()) continue;
            GenericMethod methodWithFixedVars = method.substitute(this.inference.getSubstitutions());
            if (result != null) {
                if (this.isMoreSpecific(methodWithFixedVars, resultWithFixedVars)) {
                    resultWithFixedVars = methodWithFixedVars;
                    result = method;
                    bestMatchingTypeVars = methodWithFreshTypeVars.getFreshTypeVars();
                    this.returnType = method.getActualReturnType();
                    continue;
                }
                if (this.isMoreSpecific(resultWithFixedVars, methodWithFixedVars)) continue;
                statePoint.restoreTo();
                return null;
            }
            resultWithFixedVars = methodWithFixedVars;
            result = method;
            bestMatchingTypeVars = methodWithFreshTypeVars.getFreshTypeVars();
            this.returnType = method.getActualReturnType();
        }
        statePoint.restoreTo();
        if (result != null) {
            boolean ok = this.inference.addVariables(Arrays.asList(bestMatchingTypeVars));
            assert (ok);
            ok = constraintSupplier.apply(result.getActualParameterTypes());
            assert (ok);
        }
        return result;
    }

    private List<GenericMethod> findAllMethods(Collection<GenericClass> classes, String name, boolean isStatic) {
        ArrayList<GenericMethod> methods = new ArrayList<GenericMethod>();
        HashSet<String> visited = new HashSet<String>();
        for (GenericClass cls : classes) {
            this.findAllMethodsRec(cls, name, isStatic, visited, methods);
        }
        return methods;
    }

    private void findAllMethodsRec(GenericClass cls, String name, boolean isStatic, Set<String> visited, List<GenericMethod> methods) {
        if (!visited.add(cls.getName())) {
            return;
        }
        ClassDescriber desc = this.navigator.getClassRepository().describe(cls.getName());
        if (desc == null) {
            return;
        }
        HashMap<TypeVar, TypeArgument> substitutionMap = new HashMap<TypeVar, TypeArgument>();
        TypeVar[] typeVars = desc.getTypeVariables();
        for (int i = 0; i < typeVars.length; ++i) {
            substitutionMap.put(typeVars[i], cls.getArguments().get(i));
        }
        for (MethodDescriber methodDesc : desc.getMethods()) {
            if (!methodDesc.getName().equals(name) || methodDesc.isStatic() != isStatic) continue;
            ValueType[] params = (ValueType[])Arrays.stream(methodDesc.getParameterTypes()).map(arg -> {
                if (arg instanceof GenericType) {
                    arg = ((GenericType)arg).substituteArgs(substitutionMap::get);
                }
                return arg;
            }).toArray(ValueType[]::new);
            ValueType returnType = methodDesc.getReturnType();
            if (returnType instanceof GenericType) {
                returnType = ((GenericType)returnType).substituteArgs(substitutionMap::get);
            }
            GenericMethod method = new GenericMethod(methodDesc, cls, params, returnType);
            methods.add(method);
        }
        GenericClass parentClass = this.navigator.getParent(cls);
        if (parentClass != null) {
            this.findAllMethodsRec(parentClass, name, isStatic, visited, methods);
        }
        for (GenericClass iface : this.navigator.getInterfaces(cls)) {
            this.findAllMethodsRec(iface, name, isStatic, visited, methods);
        }
    }

    private boolean isMoreSpecific(GenericMethod specific, GenericMethod general) {
        if (!specific.getDescriber().isStatic() && general.getDescriber().isStatic() && this.navigator.sublassPath(specific.getActualOwner(), general.getActualOwner().getName()) == null) {
            return false;
        }
        ValueType[] specificArgs = specific.getActualParameterTypes();
        ValueType[] generalArgs = general.getActualParameterTypes();
        for (int i = 0; i < specificArgs.length; ++i) {
            if (CompilerCommons.isLooselyCompatibleType(generalArgs[i], specificArgs[i], this.navigator)) continue;
            return false;
        }
        if (specific.getActualReturnType() == null && general.getActualReturnType() == null) {
            return true;
        }
        if (specific.getActualReturnType() == null || general.getActualReturnType() == null) {
            return false;
        }
        return CompilerCommons.isLooselyCompatibleType(specific.getActualReturnType(), general.getActualReturnType(), this.navigator);
    }
}

