/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.expr.ClassResolver;
import org.teavm.flavour.expr.CompilerCommons;
import org.teavm.flavour.expr.Scope;
import org.teavm.flavour.expr.TypeEstimatorVisitor;
import org.teavm.flavour.expr.ast.BoundVariable;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.ast.LambdaExpr;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.TypeInference;
import org.teavm.flavour.expr.type.TypeInferenceStatePoint;
import org.teavm.flavour.expr.type.ValueType;

public class TypeEstimator {
    private TypeInference inference;
    private ClassResolver classResolver;
    private GenericTypeNavigator navigator;
    private Scope scope;

    public TypeEstimator(TypeInference inference, ClassResolver classResolver, GenericTypeNavigator navigator, Scope scope) {
        this.inference = inference;
        this.classResolver = classResolver;
        this.navigator = navigator;
        this.scope = scope;
    }

    public ValueType estimate(Expr expr, ValueType expectedType) {
        TypeEstimatorVisitor visitor = new TypeEstimatorVisitor(this.inference, this.classResolver, this.navigator, this.scope);
        visitor.expectedType = expectedType;
        return expr.acceptVisitor(visitor);
    }

    public ValueType estimateLambda(LambdaExpr expr, GenericMethod method) {
        try (TypeInferenceStatePoint ignored = this.inference.createStatePoint();){
            ValueType valueType;
            BoundVariable boundVar;
            int i2;
            BoundVarsScope innerScope = new BoundVarsScope();
            ValueType[] paramTypes = method.getActualParameterTypes();
            if (!this.inference.addVariables(Arrays.asList(method.getDescriber().getTypeVariables()))) {
                ValueType valueType2 = null;
                return valueType2;
            }
            for (i2 = 0; i2 < expr.getBoundVariables().size(); ++i2) {
                boundVar = expr.getBoundVariables().get(i2);
                ValueType type = paramTypes[i2];
                if (boundVar.getType() == null || this.inference.subtypeConstraint(boundVar.getType(), type)) continue;
                ValueType valueType3 = null;
                return valueType3;
            }
            if (!this.inference.resolve()) {
                ValueType i2 = null;
                return i2;
            }
            for (i2 = 0; i2 < expr.getBoundVariables().size(); ++i2) {
                boundVar = expr.getBoundVariables().get(i2);
                ValueType paramType = paramTypes[i2];
                if (paramType instanceof GenericType) {
                    paramType = ((GenericType)paramType).substitute(this.inference.getSubstitutions());
                }
                innerScope.boundVars.put(boundVar.getName(), paramType);
            }
            TypeEstimatorVisitor visitor = new TypeEstimatorVisitor(this.inference, this.classResolver, this.navigator, innerScope);
            ValueType result = expr.getBody().acceptVisitor(visitor);
            if (result == null) {
                valueType = null;
                return valueType;
            }
            if (!CompilerCommons.isLooselyCompatibleType(result, method.getActualReturnType(), this.navigator)) {
                valueType = null;
                return valueType;
            }
        }
        return method.getActualReturnType();
    }

    class BoundVarsScope
    implements Scope {
        Map<String, ValueType> boundVars = new HashMap<String, ValueType>();

        BoundVarsScope() {
        }

        @Override
        public ValueType variableType(String variableName) {
            return this.boundVars.containsKey(variableName) ? this.boundVars.get(variableName) : TypeEstimator.this.scope.variableType(variableName);
        }
    }
}

