/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.teavm.flavour.expr.ClassResolver;
import org.teavm.flavour.expr.CompilerCommons;
import org.teavm.flavour.expr.MethodLookup;
import org.teavm.flavour.expr.Scope;
import org.teavm.flavour.expr.ast.AssignmentExpr;
import org.teavm.flavour.expr.ast.BinaryExpr;
import org.teavm.flavour.expr.ast.CastExpr;
import org.teavm.flavour.expr.ast.ConstantExpr;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.ast.ExprVisitor;
import org.teavm.flavour.expr.ast.InstanceOfExpr;
import org.teavm.flavour.expr.ast.InvocationExpr;
import org.teavm.flavour.expr.ast.LambdaExpr;
import org.teavm.flavour.expr.ast.PropertyExpr;
import org.teavm.flavour.expr.ast.StaticInvocationExpr;
import org.teavm.flavour.expr.ast.StaticPropertyExpr;
import org.teavm.flavour.expr.ast.TernaryConditionExpr;
import org.teavm.flavour.expr.ast.ThisExpr;
import org.teavm.flavour.expr.ast.UnaryExpr;
import org.teavm.flavour.expr.ast.VariableExpr;
import org.teavm.flavour.expr.plan.ArithmeticType;
import org.teavm.flavour.expr.plan.IntegerSubtype;
import org.teavm.flavour.expr.type.GenericArray;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericField;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.NullType;
import org.teavm.flavour.expr.type.Primitive;
import org.teavm.flavour.expr.type.PrimitiveArray;
import org.teavm.flavour.expr.type.PrimitiveKind;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeInference;
import org.teavm.flavour.expr.type.TypeUtils;
import org.teavm.flavour.expr.type.ValueType;

class TypeEstimatorVisitor
implements ExprVisitor<ValueType> {
    private TypeInference inference;
    private ClassResolver classResolver;
    private GenericTypeNavigator navigator;
    private Scope scope;
    ValueType expectedType;

    TypeEstimatorVisitor(TypeInference inference, ClassResolver classResolver, GenericTypeNavigator navigator, Scope scope) {
        this.inference = inference;
        this.classResolver = classResolver;
        this.navigator = navigator;
        this.scope = scope;
    }

    @Override
    public ValueType visit(BinaryExpr expr) {
        ValueType first = expr.getFirstOperand().acceptVisitor(this);
        if (first == null) {
            return null;
        }
        ValueType second = expr.getSecondOperand().acceptVisitor(this);
        if (second == null) {
            return null;
        }
        switch (expr.getOperation()) {
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: {
                return CompilerCommons.getType(this.getAritmeticTypeForPair(first, second));
            }
            case AND: 
            case OR: 
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS: 
            case LESS_OR_EQUAL: 
            case GREATER: 
            case GREATER_OR_EQUAL: {
                return Primitive.BOOLEAN;
            }
            case ADD: {
                return first.equals(TypeUtils.STRING_CLASS) || second.equals(TypeUtils.STRING_CLASS) ? TypeUtils.STRING_CLASS : CompilerCommons.getType(this.getAritmeticTypeForPair(first, second));
            }
            case GET_ELEMENT: {
                return this.estimateGetElement(first, expr.getSecondOperand());
            }
        }
        return null;
    }

    private ValueType estimateGetElement(ValueType first, Expr argument) {
        if (first instanceof GenericArray) {
            return ((GenericArray)first).getElementType();
        }
        if (first instanceof PrimitiveArray) {
            return ((PrimitiveArray)first).getElementType();
        }
        if (first instanceof GenericClass) {
            Collection<GenericClass> classes = CompilerCommons.extractClasses(first);
            MethodLookup lookup = new MethodLookup(this.inference, this.classResolver, this.navigator, this.scope);
            GenericMethod method = lookup.lookupVirtual(classes, "get", Arrays.asList(argument));
            return method == null ? null : lookup.getReturnType();
        }
        return null;
    }

    @Override
    public ValueType visit(CastExpr expr) {
        return this.resolveType(expr.getTargetType());
    }

    @Override
    public ValueType visit(InstanceOfExpr expr) {
        return Primitive.BOOLEAN;
    }

    @Override
    public ValueType visit(InvocationExpr expr) {
        ValueType instance;
        ValueType valueType = instance = expr.getInstance() != null ? expr.getInstance().acceptVisitor(this) : this.scope.variableType("this");
        if (instance == null) {
            return null;
        }
        if (!((instance = TypeUtils.tryBox(instance)) instanceof GenericClass)) {
            return null;
        }
        Collection<GenericClass> classes = CompilerCommons.extractClasses(instance);
        ValueType[] args = new ValueType[expr.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = expr.getArguments().get(i).acceptVisitor(this);
        }
        MethodLookup lookup = new MethodLookup(this.inference, this.classResolver, this.navigator, this.scope);
        GenericMethod method = lookup.lookupVirtual(classes, expr.getMethodName(), expr.getArguments());
        return this.fixReturnType(method, lookup);
    }

    @Override
    public ValueType visit(StaticInvocationExpr expr) {
        ValueType[] args = new ValueType[expr.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = expr.getArguments().get(i).acceptVisitor(this);
        }
        GenericClass cls = this.navigator.getGenericClass(expr.getClassName());
        MethodLookup lookup = new MethodLookup(this.inference, this.classResolver, this.navigator, this.scope);
        GenericMethod method = lookup.lookupStatic(Collections.singleton(cls), expr.getMethodName(), expr.getArguments());
        return this.fixReturnType(method, lookup);
    }

    private ValueType fixReturnType(GenericMethod method, MethodLookup lookup) {
        if (method == null) {
            return null;
        }
        ValueType[] capturedReturnType = new ValueType[1];
        if (!this.addReturnTypeConstraint(lookup.getReturnType(), this.expectedType)) {
            return null;
        }
        if (capturedReturnType != null) {
            return capturedReturnType[0];
        }
        return lookup.getReturnType();
    }

    private boolean addReturnTypeConstraint(ValueType actualType, ValueType expectedType) {
        if (actualType == null || expectedType == null) {
            return true;
        }
        return this.inference.subtypeConstraint(actualType, expectedType);
    }

    @Override
    public ValueType visit(PropertyExpr expr) {
        ValueType instance = expr.getInstance().acceptVisitor(this);
        if (instance == null) {
            return null;
        }
        if (instance instanceof GenericArray && expr.getPropertyName().equals("length")) {
            return Primitive.INT;
        }
        return this.estimatePropertyAccess(instance, CompilerCommons.extractClasses(instance), expr.getPropertyName());
    }

    @Override
    public ValueType visit(StaticPropertyExpr expr) {
        GenericClass cls = this.navigator.getGenericClass(expr.getClassName());
        return this.estimatePropertyAccess(null, Collections.singleton(cls), expr.getPropertyName());
    }

    private ValueType estimatePropertyAccess(ValueType instance, Collection<GenericClass> classes, String propertyName) {
        for (GenericClass cls : classes) {
            boolean isStatic;
            GenericField field = this.navigator.getField(cls, propertyName);
            boolean bl = isStatic = instance == null;
            if (field != null) {
                if (isStatic != field.getDescriber().isStatic()) continue;
                return field.getActualType();
            }
            GenericMethod method = this.navigator.getMethod(cls, this.getGetterName(propertyName), new GenericClass[0]);
            if (method == null && (method = this.navigator.getMethod(cls, this.getBooleanGetterName(propertyName), new GenericClass[0])) != null && method.getActualReturnType() != Primitive.BOOLEAN || method == null || isStatic != method.getDescriber().isStatic()) continue;
            return method.getActualReturnType();
        }
        return null;
    }

    private String getGetterName(String propertyName) {
        if (propertyName.isEmpty()) {
            return "get";
        }
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String getBooleanGetterName(String propertyName) {
        if (propertyName.isEmpty()) {
            return "is";
        }
        return "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    @Override
    public ValueType visit(UnaryExpr expr) {
        ValueType result = expr.getOperand().acceptVisitor(this);
        if (result == null) {
            return null;
        }
        switch (expr.getOperation()) {
            case NEGATE: {
                ArithmeticType type = this.getArithmeticType(result);
                return type != null ? CompilerCommons.getType(type) : null;
            }
            case NOT: {
                return Primitive.BOOLEAN;
            }
        }
        return null;
    }

    @Override
    public ValueType visit(VariableExpr expr) {
        ValueType result = this.scope.variableType(expr.getName());
        if (result == null) {
            ValueType thisType = this.scope.variableType("this");
            return this.estimatePropertyAccess(thisType, CompilerCommons.extractClasses(thisType), expr.getName());
        }
        return result;
    }

    @Override
    public ValueType visit(ConstantExpr expr) {
        if (expr.getValue() == null) {
            return NullType.INSTANCE;
        }
        if (expr.getValue() instanceof Boolean) {
            return Primitive.BOOLEAN;
        }
        if (expr.getValue() instanceof Character) {
            return Primitive.CHAR;
        }
        if (expr.getValue() instanceof Byte) {
            return Primitive.BYTE;
        }
        if (expr.getValue() instanceof Short) {
            return Primitive.SHORT;
        }
        if (expr.getValue() instanceof Integer) {
            return Primitive.INT;
        }
        if (expr.getValue() instanceof Long) {
            return Primitive.LONG;
        }
        if (expr.getValue() instanceof Float) {
            return Primitive.FLOAT;
        }
        if (expr.getValue() instanceof Double) {
            return Primitive.DOUBLE;
        }
        if (expr.getValue() instanceof String) {
            return TypeUtils.STRING_CLASS;
        }
        return null;
    }

    @Override
    public ValueType visit(TernaryConditionExpr expr) {
        ValueType first = expr.getConsequent().acceptVisitor(this);
        if (first == null) {
            return null;
        }
        ValueType second = expr.getAlternative().acceptVisitor(this);
        if (second == null) {
            return null;
        }
        return CompilerCommons.commonSupertype(first, second, this.navigator);
    }

    @Override
    public ValueType visit(ThisExpr expr) {
        return this.scope.variableType("this");
    }

    @Override
    public ValueType visit(LambdaExpr expr) {
        return null;
    }

    @Override
    public ValueType visit(AssignmentExpr expr) {
        return null;
    }

    private ArithmeticType getAritmeticTypeForPair(ValueType first, ValueType second) {
        ArithmeticType firstType = this.getArithmeticType(first);
        if (firstType == null) {
            return null;
        }
        ArithmeticType secondType = this.getArithmeticType(second);
        if (secondType == null) {
            return null;
        }
        return ArithmeticType.values()[Math.max(firstType.ordinal(), secondType.ordinal())];
    }

    private ArithmeticType getArithmeticType(ValueType type) {
        if (!(type instanceof Primitive)) {
            type = TypeUtils.tryUnbox((GenericType)type);
        }
        if (type != null) {
            PrimitiveKind kind = ((Primitive)type).getKind();
            IntegerSubtype subtype = CompilerCommons.getIntegerSubtype(kind);
            if (subtype != null) {
                kind = ((Primitive)type).getKind();
            }
            return CompilerCommons.getArithmeticType(kind);
        }
        return null;
    }

    private ValueType resolveType(ValueType type) {
        if (type instanceof GenericClass) {
            GenericClass cls = (GenericClass)type;
            String resolvedName = this.classResolver.findClass(cls.getName());
            if (resolvedName == null) {
                return type;
            }
            boolean changed = !resolvedName.equals(cls.getName());
            ArrayList<TypeArgument> arguments = new ArrayList<TypeArgument>();
            for (TypeArgument typeArgument : cls.getArguments()) {
                TypeArgument resolvedArg = typeArgument.mapBound(bound -> (GenericType)this.resolveType((ValueType)bound));
                arguments.add(resolvedArg);
                changed |= typeArgument != resolvedArg;
            }
            return !changed ? type : new GenericClass(resolvedName, arguments);
        }
        if (type instanceof GenericArray) {
            GenericArray array = (GenericArray)type;
            GenericType elementType = (GenericType)this.resolveType(array.getElementType());
            return elementType == array.getElementType() ? type : new GenericArray(elementType);
        }
        return type;
    }
}

