/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.ast;

import java.util.ArrayList;
import org.teavm.flavour.expr.ast.AssignmentExpr;
import org.teavm.flavour.expr.ast.BinaryExpr;
import org.teavm.flavour.expr.ast.CastExpr;
import org.teavm.flavour.expr.ast.ConstantExpr;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.ast.ExprVisitor;
import org.teavm.flavour.expr.ast.InstanceOfExpr;
import org.teavm.flavour.expr.ast.InvocationExpr;
import org.teavm.flavour.expr.ast.LambdaExpr;
import org.teavm.flavour.expr.ast.PropertyExpr;
import org.teavm.flavour.expr.ast.StaticInvocationExpr;
import org.teavm.flavour.expr.ast.StaticPropertyExpr;
import org.teavm.flavour.expr.ast.TernaryConditionExpr;
import org.teavm.flavour.expr.ast.ThisExpr;
import org.teavm.flavour.expr.ast.UnaryExpr;
import org.teavm.flavour.expr.ast.VariableExpr;

public class ExprCopier
implements ExprVisitor<Expr> {
    @Override
    public Expr visit(BinaryExpr expr) {
        Expr firstOperand = expr.getFirstOperand().acceptVisitor(this);
        Expr secondOperand = expr.getSecondOperand().acceptVisitor(this);
        return this.copyLocation(new BinaryExpr(firstOperand, secondOperand, expr.getOperation()), expr);
    }

    @Override
    public Expr visit(CastExpr expr) {
        Expr operand = expr.getValue().acceptVisitor(this);
        return this.copyLocation(new CastExpr(operand, expr.getTargetType()), expr);
    }

    @Override
    public Expr visit(InstanceOfExpr expr) {
        Expr operand = expr.getValue().acceptVisitor(this);
        return this.copyLocation(new InstanceOfExpr(operand, expr.getCheckedType()), expr);
    }

    @Override
    public Expr visit(InvocationExpr expr) {
        Expr instance = expr.getInstance() != null ? expr.getInstance().acceptVisitor(this) : null;
        ArrayList<Expr> arguments = new ArrayList<Expr>();
        for (Expr arg : expr.getArguments()) {
            arguments.add(arg.acceptVisitor(this));
        }
        return this.copyLocation(new InvocationExpr(instance, expr.getMethodName(), arguments), expr);
    }

    @Override
    public Expr visit(StaticInvocationExpr expr) {
        ArrayList<Expr> arguments = new ArrayList<Expr>();
        for (Expr arg : expr.getArguments()) {
            arguments.add(arg.acceptVisitor(this));
        }
        return this.copyLocation(new StaticInvocationExpr(expr.getClassName(), expr.getMethodName(), arguments), expr);
    }

    @Override
    public Expr visit(PropertyExpr expr) {
        Expr instance = expr.getInstance().acceptVisitor(this);
        return this.copyLocation(new PropertyExpr(instance, expr.getPropertyName()), expr);
    }

    @Override
    public Expr visit(StaticPropertyExpr expr) {
        return this.copyLocation(new StaticPropertyExpr(expr.getClassName(), expr.getPropertyName()), expr);
    }

    @Override
    public Expr visit(UnaryExpr expr) {
        Expr operand = expr.getOperand().acceptVisitor(this);
        return this.copyLocation(new UnaryExpr(operand, expr.getOperation()), expr);
    }

    @Override
    public Expr visit(VariableExpr expr) {
        return this.copyLocation(new VariableExpr(expr.getName()), expr);
    }

    @Override
    public Expr visit(ConstantExpr expr) {
        return this.copyLocation(new ConstantExpr(expr.getValue()), expr);
    }

    @Override
    public Expr visit(TernaryConditionExpr expr) {
        Expr condition = expr.getCondition().acceptVisitor(this);
        Expr consequent = expr.getConsequent().acceptVisitor(this);
        Expr alternative = expr.getAlternative().acceptVisitor(this);
        return this.copyLocation(new TernaryConditionExpr(condition, consequent, alternative), expr);
    }

    @Override
    public Expr visit(ThisExpr expr) {
        return this.copyLocation(new ThisExpr(), expr);
    }

    @Override
    public Expr visit(LambdaExpr expr) {
        Expr body = expr.getBody().acceptVisitor(this);
        return this.copyLocation(new LambdaExpr(body, expr.getBoundVariables()), expr);
    }

    @Override
    public Expr visit(AssignmentExpr expr) {
        Expr target = expr.getTarget().acceptVisitor(this);
        Expr value = expr.getValue().acceptVisitor(this);
        return this.copyLocation(new AssignmentExpr(target, value), expr);
    }

    private Expr copyLocation(Expr expr, Expr from) {
        expr.setStart(from.getStart());
        expr.setEnd(from.getEnd());
        return expr;
    }
}

