/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.ast.ExprVisitor;

public class InvocationExpr
extends Expr {
    private Expr instance;
    private String methodName;
    private List<Expr> arguments = new ArrayList<Expr>();

    public InvocationExpr(Expr instance, String methodName, Expr ... arguments) {
        this(instance, methodName, Arrays.asList(arguments));
    }

    public InvocationExpr(Expr instance, String methodName, Collection<Expr> arguments) {
        this.instance = instance;
        this.methodName = methodName;
        this.arguments.addAll(arguments);
    }

    public Expr getInstance() {
        return this.instance;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setInstance(Expr instance) {
        this.instance = instance;
    }

    public List<Expr> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T acceptVisitor(ExprVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

