/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.plan;

import org.teavm.flavour.expr.plan.ArithmeticCastPlan;
import org.teavm.flavour.expr.plan.ArrayConstructionPlan;
import org.teavm.flavour.expr.plan.ArrayLengthPlan;
import org.teavm.flavour.expr.plan.BinaryPlan;
import org.teavm.flavour.expr.plan.CastFromIntegerPlan;
import org.teavm.flavour.expr.plan.CastPlan;
import org.teavm.flavour.expr.plan.CastToIntegerPlan;
import org.teavm.flavour.expr.plan.ConditionalPlan;
import org.teavm.flavour.expr.plan.ConstantPlan;
import org.teavm.flavour.expr.plan.ConstructionPlan;
import org.teavm.flavour.expr.plan.FieldAssignmentPlan;
import org.teavm.flavour.expr.plan.FieldPlan;
import org.teavm.flavour.expr.plan.GetArrayElementPlan;
import org.teavm.flavour.expr.plan.InstanceOfPlan;
import org.teavm.flavour.expr.plan.InvocationPlan;
import org.teavm.flavour.expr.plan.LambdaPlan;
import org.teavm.flavour.expr.plan.LogicalBinaryPlan;
import org.teavm.flavour.expr.plan.NegatePlan;
import org.teavm.flavour.expr.plan.NotPlan;
import org.teavm.flavour.expr.plan.ObjectPlan;
import org.teavm.flavour.expr.plan.ObjectPlanEntry;
import org.teavm.flavour.expr.plan.Plan;
import org.teavm.flavour.expr.plan.PlanVisitor;
import org.teavm.flavour.expr.plan.ReferenceEqualityPlan;
import org.teavm.flavour.expr.plan.ThisPlan;
import org.teavm.flavour.expr.plan.VariablePlan;

public class PlanFormatter
implements PlanVisitor {
    private StringBuilder sb;
    private int indentLevel;

    public PlanFormatter(StringBuilder sb) {
        this.sb = sb;
    }

    @Override
    public void visit(ConstantPlan plan) {
        this.sb.append("[constant ").append(plan.getValue()).append("]");
    }

    @Override
    public void visit(VariablePlan plan) {
        this.sb.append("[var ").append(plan.getName()).append("]");
    }

    @Override
    public void visit(BinaryPlan plan) {
        this.sb.append("[").append(plan.getType().name().toLowerCase()).append('-').append(plan.getValueType().name().toLowerCase());
        ++this.indentLevel;
        this.newLine();
        plan.getFirstOperand().acceptVisitor(this);
        this.newLine();
        plan.getSecondOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(NegatePlan plan) {
        this.sb.append("[negate-").append(plan.getValueType().name().toLowerCase());
        ++this.indentLevel;
        this.newLine();
        plan.getOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ReferenceEqualityPlan plan) {
        this.sb.append("[").append(plan.getType().name().toLowerCase()).append("-ref");
        ++this.indentLevel;
        this.newLine();
        plan.getFirstOperand().acceptVisitor(this);
        this.newLine();
        plan.getSecondOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(LogicalBinaryPlan plan) {
        this.sb.append("[").append(plan.getType().name().toLowerCase());
        ++this.indentLevel;
        this.newLine();
        plan.getFirstOperand().acceptVisitor(this);
        this.newLine();
        plan.getSecondOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(NotPlan plan) {
        this.sb.append("[not");
        ++this.indentLevel;
        this.newLine();
        plan.getOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(CastPlan plan) {
        this.sb.append("[cast-obj-to ").append(plan.getTargetType());
        ++this.indentLevel;
        this.newLine();
        plan.getOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ArithmeticCastPlan plan) {
        this.sb.append("[cast-").append(plan.getSourceType().name().toLowerCase()).append("-to-").append(plan.getTargetType().name().toLowerCase());
        ++this.indentLevel;
        this.newLine();
        plan.getOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(CastFromIntegerPlan plan) {
        this.sb.append("[cast-int-to-").append(plan.getType().name().toLowerCase());
        ++this.indentLevel;
        this.newLine();
        plan.getOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(CastToIntegerPlan plan) {
        this.sb.append("[cast-").append(plan.getType().name().toLowerCase()).append("-to-int");
        ++this.indentLevel;
        this.newLine();
        plan.getOperand().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(GetArrayElementPlan plan) {
        this.sb.append("[array-subscript ");
        ++this.indentLevel;
        this.newLine();
        plan.getArray().acceptVisitor(this);
        this.newLine();
        plan.getIndex().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ArrayLengthPlan plan) {
        this.sb.append("[array-length ");
        ++this.indentLevel;
        this.newLine();
        plan.getArray().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(FieldPlan plan) {
        this.sb.append("[get-field");
        if (plan.getInstance() == null) {
            this.sb.append("-static");
        }
        this.sb.append(" ").append(plan.getClassName()).append('.').append(plan.getFieldName());
        if (plan.getInstance() != null) {
            ++this.indentLevel;
            this.newLine();
            plan.getInstance().acceptVisitor(this);
            this.sb.append(']');
            --this.indentLevel;
        }
    }

    @Override
    public void visit(FieldAssignmentPlan plan) {
        this.sb.append("[set-field");
        if (plan.getInstance() == null) {
            this.sb.append("-static");
        }
        this.sb.append(" ").append(plan.getClassName()).append('.').append(plan.getFieldName());
        ++this.indentLevel;
        if (plan.getInstance() != null) {
            this.newLine();
            plan.getInstance().acceptVisitor(this);
        }
        this.newLine();
        plan.getValue().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(InstanceOfPlan plan) {
        this.sb.append("[instanceof ").append(plan.getClassName());
        ++this.indentLevel;
        this.newLine();
        plan.getOperand().acceptVisitor(this);
        --this.indentLevel;
    }

    @Override
    public void visit(InvocationPlan plan) {
        this.sb.append("[invoke-method");
        if (plan.getInstance() == null) {
            this.sb.append("-static");
        }
        this.sb.append(" ").append(plan.getClassName()).append('.').append(plan.getMethodName()).append(plan.getMethodDesc());
        ++this.indentLevel;
        if (plan.getInstance() != null) {
            this.newLine();
            plan.getInstance().acceptVisitor(this);
        }
        for (Plan arg : plan.getArguments()) {
            this.newLine();
            arg.acceptVisitor(this);
        }
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ConstructionPlan plan) {
        this.sb.append("[instantiate ");
        this.sb.append(" ").append(plan.getClassName()).append(".<init>").append(plan.getMethodDesc());
        ++this.indentLevel;
        for (Plan arg : plan.getArguments()) {
            this.newLine();
            arg.acceptVisitor(this);
        }
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ArrayConstructionPlan plan) {
        this.sb.append("[new-array ");
        this.sb.append(plan.getElementType());
        ++this.indentLevel;
        for (Plan elem : plan.getElements()) {
            this.newLine();
            elem.acceptVisitor(this);
        }
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ConditionalPlan plan) {
        this.sb.append("[if");
        ++this.indentLevel;
        this.newLine();
        plan.getCondition().acceptVisitor(this);
        this.newLine();
        plan.getConsequent().acceptVisitor(this);
        this.newLine();
        plan.getAlternative().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ThisPlan plan) {
        this.sb.append("[this]");
    }

    @Override
    public void visit(LambdaPlan plan) {
        this.sb.append("[lambda (");
        for (int i = 0; i < plan.getBoundVars().size(); ++i) {
            if (i > 0) {
                this.sb.append(", ");
            }
            this.sb.append(plan.getBoundVars().get(i));
        }
        this.sb.append(")");
        ++this.indentLevel;
        this.newLine();
        this.sb.append(plan.getClassName()).append("#").append(plan.getMethodName()).append(plan.getMethodDesc());
        this.newLine();
        plan.getBody().acceptVisitor(this);
        this.sb.append(']');
        --this.indentLevel;
    }

    @Override
    public void visit(ObjectPlan plan) {
        this.sb.append("[object ").append(plan.getClassName());
        ++this.indentLevel;
        boolean first = true;
        for (ObjectPlanEntry entry : plan.getEntries()) {
            if (!first) {
                this.sb.append(",");
            }
            first = false;
            this.newLine();
            this.sb.append("[entry ").append(entry.getSetterName()).append(entry.getSetterDesc());
            entry.getValue().acceptVisitor(this);
            this.sb.append("]");
        }
        this.sb.append("]");
        --this.indentLevel;
    }

    private void printIndent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.sb.append("  ");
        }
    }

    private void newLine() {
        this.sb.append('\n');
        this.printIndent();
    }
}

