/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;

public final class GenericArray
extends GenericType {
    private GenericType elementType;

    public GenericArray(GenericType elementType) {
        Objects.requireNonNull(elementType);
        this.elementType = elementType;
    }

    public GenericType getElementType() {
        return this.elementType;
    }

    @Override
    public GenericArray substitute(Substitutions substitutions) {
        return this.substitute(substitutions, (Set)new HashSet());
    }

    @Override
    GenericArray substitute(Substitutions substitutions, Set<TypeVar> visited) {
        GenericType substElem = this.elementType.substitute(substitutions, visited);
        return substElem != this.elementType ? new GenericArray(substElem) : this;
    }

    @Override
    public GenericArray substituteArgs(Function<TypeVar, TypeArgument> substitutions) {
        return this.substituteArgs((Function)substitutions, (Set)new HashSet());
    }

    @Override
    GenericArray substituteArgs(Function<TypeVar, TypeArgument> substitutions, Set<TypeVar> visited) {
        GenericType substElem = this.elementType.substituteArgs(substitutions, visited);
        return substElem != this.elementType ? new GenericArray(substElem) : this;
    }

    public int hashCode() {
        return 31 * this.elementType.hashCode() + 13;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericArray)) {
            return false;
        }
        GenericArray other = (GenericArray)obj;
        return this.elementType.equals(other.elementType);
    }

    @Override
    public GenericArray erasure() {
        return new GenericArray(this.elementType.erasure());
    }
}

