/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.Variance;

public final class GenericClass
extends GenericType {
    private String name;
    private List<? extends TypeArgument> arguments;

    public GenericClass(String name) {
        this.name = name;
        this.arguments = Collections.emptyList();
    }

    public GenericClass(String name, TypeArgument ... arguments) {
        this(name, Arrays.asList(arguments));
    }

    public GenericClass(String name, TypeVar ... arguments) {
        this(name, Arrays.stream(arguments).map(typeVar -> TypeArgument.invariant(new GenericReference((TypeVar)typeVar))).collect(Collectors.toList()));
    }

    public GenericClass(String name, List<? extends TypeArgument> arguments) {
        if (name == null || arguments == null) {
            throw new IllegalArgumentException();
        }
        for (TypeArgument typeArgument : arguments) {
            if (typeArgument != null) continue;
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.arguments = Collections.unmodifiableList(new ArrayList<TypeArgument>(arguments));
    }

    public String getName() {
        return this.name;
    }

    public List<? extends TypeArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public GenericClass substitute(Substitutions substitutions) {
        return this.substitute(substitutions, (Set)new HashSet());
    }

    @Override
    GenericClass substitute(Substitutions substitutions, Set<TypeVar> visited) {
        ArrayList<TypeArgument> argumentSubstitutions = new ArrayList<TypeArgument>();
        boolean changed = false;
        for (TypeArgument typeArgument : this.arguments) {
            TypeArgument argSubst = typeArgument.mapBound(bound -> bound.substitute(substitutions, visited));
            argumentSubstitutions.add(argSubst);
            changed |= typeArgument != argSubst;
        }
        return changed ? new GenericClass(this.name, argumentSubstitutions) : this;
    }

    @Override
    public GenericClass substituteArgs(Function<TypeVar, TypeArgument> substitutions) {
        return this.substituteArgs((Function)substitutions, (Set)new HashSet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    GenericClass substituteArgs(Function<TypeVar, TypeArgument> substitutions, Set<TypeVar> visited) {
        ArrayList<void> argumentSubstitutions = new ArrayList<void>();
        boolean changed = false;
        for (TypeArgument typeArgument : this.arguments) {
            void var6_6;
            TypeArgument argSubst;
            if (typeArgument.getBound() instanceof GenericReference) {
                if (typeArgument.getVariance() == Variance.INVARIANT) {
                    argSubst = substitutions.apply(((GenericReference)typeArgument.getBound()).getVar());
                    if (argSubst != null) {
                        changed |= true;
                        TypeArgument typeArgument2 = argSubst;
                    }
                } else {
                    argSubst = substitutions.apply(((GenericReference)typeArgument.getBound()).getVar());
                    if (argSubst != null && argSubst.getVariance() == Variance.INVARIANT && argSubst != null) {
                        changed |= true;
                        TypeArgument typeArgument3 = new TypeArgument(typeArgument.getVariance(), argSubst.getBound());
                    }
                }
            } else {
                argSubst = typeArgument.mapBound(bound -> bound.substituteArgs(substitutions, visited));
                if (argSubst != typeArgument) {
                    TypeArgument typeArgument4 = argSubst;
                    changed = true;
                }
            }
            argumentSubstitutions.add(var6_6);
        }
        return changed ? new GenericClass(this.name, argumentSubstitutions) : this;
    }

    public int hashCode() {
        int hash = 31 * this.name.hashCode() + 13;
        for (TypeArgument typeArgument : this.arguments) {
            hash = 31 * hash + typeArgument.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericClass)) {
            return false;
        }
        GenericClass other = (GenericClass)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.arguments.size() != other.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i).equals(other.arguments.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public GenericType erasure() {
        return new GenericClass(this.name);
    }
}

