/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.ValueTypeFormatter;
import org.teavm.flavour.expr.type.meta.MethodDescriber;

public class GenericMethod {
    private MethodDescriber describer;
    private GenericClass actualOwner;
    private ValueType[] actualParameterTypes;
    private ValueType actualReturnType;

    public GenericMethod(MethodDescriber describer, GenericClass actualOwner, ValueType[] actualParameterTypes, ValueType actualReturnType) {
        if (describer.getParameterTypes().length != actualParameterTypes.length) {
            throw new IllegalArgumentException();
        }
        if (actualReturnType == null != (describer.getReturnType() == null)) {
            throw new IllegalArgumentException();
        }
        this.describer = describer;
        this.actualOwner = actualOwner;
        this.actualParameterTypes = actualParameterTypes;
        this.actualReturnType = actualReturnType;
    }

    public GenericClass getActualOwner() {
        return this.actualOwner;
    }

    public MethodDescriber getDescriber() {
        return this.describer;
    }

    public ValueType[] getActualParameterTypes() {
        return (ValueType[])this.actualParameterTypes.clone();
    }

    public ValueType getActualReturnType() {
        return this.actualReturnType;
    }

    public GenericMethod substitute(Substitutions substitutions) {
        GenericClass actualOwner = this.actualOwner.substitute(substitutions);
        ValueType[] actualParameterTypes = (ValueType[])this.actualParameterTypes.clone();
        for (int i = 0; i < actualParameterTypes.length; ++i) {
            if (!(actualParameterTypes[i] instanceof GenericType)) continue;
            actualParameterTypes[i] = ((GenericType)actualParameterTypes[i]).substitute(substitutions);
        }
        ValueType actualReturnType = this.actualReturnType;
        if (actualReturnType instanceof GenericType) {
            actualReturnType = ((GenericType)actualReturnType).substitute(substitutions);
        }
        return new GenericMethod(this.describer, actualOwner, actualParameterTypes, actualReturnType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.describer.getName()).append('(');
        ValueTypeFormatter formatter = new ValueTypeFormatter();
        if (this.actualParameterTypes.length > 0) {
            formatter.format(this.actualParameterTypes[0], sb);
            for (int i = 1; i < this.actualParameterTypes.length; ++i) {
                sb.append(", ");
                formatter.format(this.actualParameterTypes[i], sb);
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

