/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;

public final class GenericReference
extends GenericType {
    private TypeVar var;

    public GenericReference(TypeVar var) {
        Objects.requireNonNull(var);
        this.var = var;
    }

    public TypeVar getVar() {
        return this.var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GenericType substitute(Substitutions substitutions, Set<TypeVar> visited) {
        try {
            if (!visited.add(this.var)) {
                GenericReference genericReference = this;
                return genericReference;
            }
            GenericType substitution = substitutions.get(this.var);
            if (substitution == null) {
                GenericReference genericReference = this;
                return genericReference;
            }
            GenericType genericType = substitution != this ? substitution.substitute(substitutions, visited) : substitution;
            return genericType;
        }
        finally {
            visited.remove(this.var);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GenericType substituteArgs(Function<TypeVar, TypeArgument> substitutions, Set<TypeVar> visited) {
        try {
            if (!visited.add(this.var)) {
                GenericReference genericReference = this;
                return genericReference;
            }
            TypeArgument substitutionArg = substitutions.apply(this.var);
            if (substitutionArg == null) {
                GenericReference genericReference = this;
                return genericReference;
            }
            GenericType substitution = substitutionArg.getBound();
            GenericType genericType = substitution != this ? substitution.substituteArgs(substitutions, visited) : substitution;
            return genericType;
        }
        finally {
            visited.remove(this.var);
        }
    }

    public int hashCode() {
        return 31 * this.var.hashCode() + 13;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericReference)) {
            return false;
        }
        GenericReference other = (GenericReference)obj;
        return this.var == other.var;
    }

    @Override
    public GenericType erasure() {
        if (this.var.getUpperBound().size() != 1) {
            return GenericType.OBJECT;
        }
        return this.var.getUpperBound().iterator().next();
    }
}

