/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericField;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.FieldDescriber;
import org.teavm.flavour.expr.type.meta.MethodDescriber;

public class GenericTypeNavigator {
    private ClassDescriberRepository classRepository;

    public GenericTypeNavigator(ClassDescriberRepository classRepository) {
        this.classRepository = classRepository;
    }

    public ClassDescriberRepository getClassRepository() {
        return this.classRepository;
    }

    public List<GenericClass> sublassPath(GenericClass subclass, String superclass) {
        ArrayList<GenericClass> path = new ArrayList<GenericClass>();
        if (!this.subclassPathImpl(subclass, superclass, path)) {
            return null;
        }
        return path;
    }

    private boolean subclassPathImpl(GenericClass subclass, String superclass, List<GenericClass> path) {
        path.add(subclass);
        if (subclass.getName().equals(superclass)) {
            return true;
        }
        GenericClass parent = this.getParent(subclass);
        if (parent != null && this.subclassPathImpl(parent, superclass, path)) {
            return true;
        }
        for (GenericClass iface : this.getInterfaces(subclass)) {
            if (!this.subclassPathImpl(iface, superclass, path)) continue;
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }

    public Set<String> commonSupertypes(Set<String> firstSet, Set<String> secondSet) {
        Set<String> firstAncestors = this.allAncestors(firstSet);
        HashSet<String> commonSupertypes = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String cls : secondSet) {
            this.commonSupertypesImpl(cls, firstAncestors, visited, commonSupertypes);
        }
        return commonSupertypes;
    }

    private void commonSupertypesImpl(String cls, Set<String> ancestors, Set<String> visited, Set<String> commonSupertypes) {
        if (!visited.add(cls)) {
            return;
        }
        if (ancestors.contains(cls)) {
            commonSupertypes.add(cls);
            return;
        }
        ClassDescriber desc = this.classRepository.describe(cls);
        if (desc == null) {
            return;
        }
        if (desc.getSupertype() != null) {
            this.commonSupertypesImpl(desc.getSupertype().getName(), ancestors, visited, commonSupertypes);
        }
        for (GenericClass iface : desc.getInterfaces()) {
            this.commonSupertypesImpl(iface.getName(), ancestors, visited, commonSupertypes);
        }
    }

    public Set<String> allAncestors(Collection<String> classes) {
        HashSet<String> ancestors = new HashSet<String>();
        for (String cls : classes) {
            this.allAncestorsImpl(cls, ancestors);
        }
        return ancestors;
    }

    private void allAncestorsImpl(String cls, Set<String> ancestors) {
        if (!ancestors.add(cls)) {
            return;
        }
        ClassDescriber desc = this.classRepository.describe(cls);
        if (desc == null) {
            return;
        }
        if (desc.getSupertype() != null) {
            this.allAncestorsImpl(desc.getSupertype().getName(), ancestors);
        }
        for (GenericClass iface : desc.getInterfaces()) {
            this.allAncestorsImpl(iface.getName(), ancestors);
        }
    }

    public GenericClass getGenericClass(String className) {
        ClassDescriber describer = this.classRepository.describe(className);
        if (describer == null) {
            return null;
        }
        ArrayList<TypeArgument> arguments = new ArrayList<TypeArgument>();
        for (TypeVar var : describer.getTypeVariables()) {
            arguments.add(TypeArgument.invariant(new GenericReference(var)));
        }
        return new GenericClass(className, arguments);
    }

    public GenericClass getParent(GenericClass cls) {
        List<? extends TypeArgument> typeValues;
        ClassDescriber describer = this.classRepository.describe(cls.getName());
        if (describer == null) {
            return null;
        }
        GenericClass superType = describer.getSupertype();
        if (superType == null) {
            return null;
        }
        TypeVar[] typeVars = describer.getTypeVariables();
        if (typeVars.length != (typeValues = cls.getArguments()).size()) {
            return null;
        }
        HashMap<TypeVar, TypeArgument> substitutions = new HashMap<TypeVar, TypeArgument>();
        for (int i = 0; i < typeVars.length; ++i) {
            substitutions.put(typeVars[i], typeValues.get(i));
        }
        return superType.substituteArgs(substitutions::get);
    }

    public GenericClass[] getInterfaces(GenericClass cls) {
        List<? extends TypeArgument> typeValues;
        ClassDescriber describer = this.classRepository.describe(cls.getName());
        if (describer == null) {
            return new GenericClass[0];
        }
        TypeVar[] typeVars = describer.getTypeVariables();
        if (typeVars.length != (typeValues = cls.getArguments()).size()) {
            return new GenericClass[0];
        }
        HashMap<TypeVar, TypeArgument> substitutions = new HashMap<TypeVar, TypeArgument>();
        for (int i = 0; i < typeVars.length; ++i) {
            substitutions.put(typeVars[i], typeValues.get(i));
        }
        GenericClass[] interfaces = describer.getInterfaces();
        GenericClass[] result = new GenericClass[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            result[i] = interfaces[i].substituteArgs(substitutions::get);
        }
        return result;
    }

    public GenericMethod[] findMethods(GenericClass cls, String name, int paramCount) {
        HashMap<MethodSignature, GenericMethod> methods = new HashMap<MethodSignature, GenericMethod>();
        this.findMethodsImpl(cls, name, paramCount, new HashSet<String>(), methods);
        return methods.values().toArray(new GenericMethod[0]);
    }

    private Map<TypeVar, TypeArgument> prepareSubstitutions(ClassDescriber describer, GenericClass cls) {
        List<? extends TypeArgument> typeValues;
        TypeVar[] typeVars = describer.getTypeVariables();
        if (typeVars.length != (typeValues = cls.getArguments()).size()) {
            return null;
        }
        HashMap<TypeVar, TypeArgument> substitutions = new HashMap<TypeVar, TypeArgument>();
        for (int i = 0; i < typeVars.length; ++i) {
            substitutions.put(typeVars[i], typeValues.get(i));
        }
        return substitutions;
    }

    public GenericField getField(GenericClass cls, String name) {
        return this.getFieldRec(cls, name, new HashSet<GenericClass>());
    }

    private GenericField getFieldRec(GenericClass cls, String name, Set<GenericClass> visited) {
        if (!visited.add(cls)) {
            return null;
        }
        GenericField field = this.getFieldImpl(cls, name);
        if (field != null) {
            return field;
        }
        GenericClass parent = this.getParent(cls);
        if (parent != null && (field = this.getFieldRec(parent, name, visited)) != null) {
            return field;
        }
        for (GenericClass iface : this.getInterfaces(cls)) {
            field = this.getFieldRec(iface, name, visited);
            if (field == null) continue;
            return field;
        }
        return field;
    }

    private GenericField getFieldImpl(GenericClass cls, String name) {
        ClassDescriber describer = this.classRepository.describe(cls.getName());
        if (describer == null) {
            return null;
        }
        Map<TypeVar, TypeArgument> substitutions = this.prepareSubstitutions(describer, cls);
        if (substitutions == null) {
            return null;
        }
        FieldDescriber fieldDescriber = describer.getField(name);
        if (fieldDescriber == null) {
            return null;
        }
        ValueType type = fieldDescriber.getType();
        if (type instanceof GenericType) {
            type = ((GenericType)type).substituteArgs(substitutions::get);
        }
        return new GenericField(fieldDescriber, type);
    }

    public GenericMethod getMethod(GenericClass cls, String name, GenericClass ... argumentTypes) {
        return this.getMethodRec(cls, name, argumentTypes, new HashSet<GenericClass>());
    }

    private GenericMethod getMethodRec(GenericClass cls, String name, GenericClass[] argumentTypes, Set<GenericClass> visited) {
        if (!visited.add(cls)) {
            return null;
        }
        GenericMethod method = this.getMethodImpl(cls, name, argumentTypes);
        if (method != null) {
            return method;
        }
        GenericClass parent = this.getParent(cls);
        if (parent != null && (method = this.getMethodRec(parent, name, argumentTypes, visited)) != null) {
            return method;
        }
        for (GenericClass iface : this.getInterfaces(cls)) {
            method = this.getMethodRec(iface, name, argumentTypes, visited);
            if (method == null) continue;
            return method;
        }
        return method;
    }

    private GenericMethod getMethodImpl(GenericClass cls, String name, GenericClass ... parameterTypes) {
        ClassDescriber describer = this.classRepository.describe(cls.getName());
        if (describer == null) {
            return null;
        }
        Map<TypeVar, TypeArgument> substitutions = this.prepareSubstitutions(describer, cls);
        if (substitutions == null) {
            return null;
        }
        MethodDescriber methodDescriber = describer.getMethod(name, parameterTypes);
        if (methodDescriber == null) {
            return null;
        }
        ValueType[] argTypes = methodDescriber.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (!(argTypes[i] instanceof GenericType)) continue;
            argTypes[i] = ((GenericType)argTypes[i]).substituteArgs(substitutions::get);
        }
        ValueType returnType = methodDescriber.getReturnType();
        if (returnType instanceof GenericType) {
            returnType = ((GenericType)returnType).substituteArgs(substitutions::get);
        }
        return new GenericMethod(methodDescriber, cls, parameterTypes, returnType);
    }

    private void findMethodsImpl(GenericClass cls, String name, int paramCount, Set<String> visitedClasses, Map<MethodSignature, GenericMethod> methods) {
        if (!visitedClasses.add(cls.getName())) {
            return;
        }
        ClassDescriber describer = this.classRepository.describe(cls.getName());
        if (describer == null) {
            return;
        }
        Map<TypeVar, TypeArgument> substitutions = this.prepareSubstitutions(describer, cls);
        if (substitutions == null) {
            return;
        }
        for (MethodDescriber methodDesc : describer.getMethods()) {
            ValueType[] paramTypes;
            if (!methodDesc.getName().equals(name) || (paramTypes = methodDesc.getParameterTypes()).length != paramCount) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!(paramTypes[i] instanceof GenericType)) continue;
                paramTypes[i] = ((GenericType)paramTypes[i]).substituteArgs(substitutions::get);
            }
            ValueType returnType = methodDesc.getReturnType();
            if (returnType instanceof GenericType) {
                returnType = ((GenericType)returnType).substituteArgs(substitutions::get);
            }
            MethodSignature signature = new MethodSignature(methodDesc.getRawParameterTypes());
            methods.put(signature, new GenericMethod(methodDesc, cls, paramTypes, returnType));
        }
        GenericClass supertype = this.getParent(cls);
        if (supertype != null) {
            this.findMethodsImpl(supertype, name, paramCount, visitedClasses, methods);
        }
        for (GenericClass iface : this.getInterfaces(cls)) {
            this.findMethodsImpl(iface, name, paramCount, visitedClasses, methods);
        }
    }

    public GenericMethod findSingleAbstractMethod(GenericClass cls) {
        HashMap<MethodSignature, GenericMethod> methods = new HashMap<MethodSignature, GenericMethod>();
        int count = this.findSingleAbstractMethodImpl(cls, new HashSet<String>(), methods);
        if (count != 1) {
            return null;
        }
        for (GenericMethod method : methods.values()) {
            if (!method.getDescriber().isAbstract()) continue;
            return method;
        }
        return null;
    }

    private int findSingleAbstractMethodImpl(GenericClass cls, Set<String> visitedClasses, Map<MethodSignature, GenericMethod> methods) {
        GenericClass supertype;
        if (cls.getName().equals(Object.class.getName())) {
            return 0;
        }
        if (!visitedClasses.add(cls.getName())) {
            return 0;
        }
        ClassDescriber describer = this.classRepository.describe(cls.getName());
        if (describer == null) {
            return 0;
        }
        Map<TypeVar, TypeArgument> substitutions = this.prepareSubstitutions(describer, cls);
        if (substitutions == null) {
            return 0;
        }
        int result = 0;
        ClassDescriber objectDescriber = this.classRepository.describe(Object.class.getName());
        for (MethodDescriber methodDesc : describer.getMethods()) {
            MethodSignature signature;
            if (objectDescriber.getMethod(methodDesc.getName(), methodDesc.getParameterTypes()) != null || !methodDesc.isAbstract() || methodDesc.isStatic()) continue;
            ValueType[] paramTypes = methodDesc.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!(paramTypes[i] instanceof GenericType)) continue;
                paramTypes[i] = ((GenericType)paramTypes[i]).substituteArgs(substitutions::get);
            }
            ValueType returnType = methodDesc.getReturnType();
            if (returnType instanceof GenericType) {
                returnType = ((GenericType)returnType).substituteArgs(substitutions::get);
            }
            if (methods.containsKey(signature = new MethodSignature(methodDesc.getRawParameterTypes()))) continue;
            methods.put(signature, new GenericMethod(methodDesc, cls, paramTypes, returnType));
            if (methodDesc.isAbstract() && ++result > 1) break;
        }
        if ((supertype = this.getParent(cls)) != null && result <= 1) {
            result += this.findSingleAbstractMethodImpl(supertype, visitedClasses, methods);
        }
        for (GenericClass iface : this.getInterfaces(cls)) {
            if (result > 1) break;
            result += this.findSingleAbstractMethodImpl(iface, visitedClasses, methods);
        }
        return result;
    }

    static class MethodSignature {
        ValueType[] paramTypes;

        MethodSignature(ValueType[] paramTypes) {
            this.paramTypes = paramTypes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.paramTypes);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MethodSignature)) {
                return false;
            }
            MethodSignature other = (MethodSignature)obj;
            return Arrays.equals(this.paramTypes, other.paramTypes);
        }
    }
}

