/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;

public class IntersectionType
extends GenericType {
    private Set<? extends GenericType> types;

    private IntersectionType(Set<? extends GenericType> types) {
        this.types = Collections.unmodifiableSet(types);
    }

    public static GenericType of(GenericType ... types) {
        return IntersectionType.of(Arrays.asList(types));
    }

    public static GenericType of(Collection<? extends GenericType> types) {
        LinkedHashSet<? extends GenericType> flattenedTypes = new LinkedHashSet<GenericType>();
        for (GenericType genericType : types) {
            if (genericType instanceof IntersectionType) {
                flattenedTypes.addAll(((IntersectionType)genericType).getTypes());
                continue;
            }
            flattenedTypes.add(genericType);
        }
        return flattenedTypes.size() == 1 ? (GenericType)flattenedTypes.iterator().next() : new IntersectionType(flattenedTypes);
    }

    public Set<? extends GenericType> getTypes() {
        return this.types;
    }

    @Override
    GenericType substitute(Substitutions substitutions, Set<TypeVar> visited) {
        ArrayList<GenericType> mappedTypes = new ArrayList<GenericType>();
        boolean changed = false;
        for (GenericType genericType : this.types) {
            GenericType mappedType = genericType.substitute(substitutions, visited);
            if (mappedType != genericType) {
                changed = true;
            }
            mappedTypes.add(mappedType);
        }
        return changed ? IntersectionType.of(mappedTypes) : this;
    }

    @Override
    GenericType substituteArgs(Function<TypeVar, TypeArgument> substitutions, Set<TypeVar> visited) {
        ArrayList<GenericType> mappedTypes = new ArrayList<GenericType>();
        boolean changed = false;
        for (GenericType genericType : this.types) {
            GenericType mappedType = genericType.substituteArgs(substitutions, visited);
            if (mappedType != genericType) {
                changed = true;
            }
            mappedTypes.add(mappedType);
        }
        return changed ? IntersectionType.of(mappedTypes) : this;
    }

    @Override
    public GenericType erasure() {
        ArrayList<GenericType> erasedTypes = new ArrayList<GenericType>();
        boolean changed = false;
        for (GenericType genericType : this.types) {
            GenericType erasedType = genericType.erasure();
            if (erasedType != genericType) {
                changed = true;
            }
            erasedTypes.add(erasedType);
        }
        return changed ? IntersectionType.of(erasedTypes) : this;
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntersectionType)) {
            return false;
        }
        IntersectionType that = (IntersectionType)obj;
        return this.types.equals(that.types);
    }
}

