/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.flavour.expr.type.GenericArray;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.IntersectionType;
import org.teavm.flavour.expr.type.PrimitiveArray;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.Variance;
import org.teavm.flavour.expr.type.meta.ClassDescriber;

public class LeastUpperBoundFinder {
    private GenericTypeNavigator typeNavigator;
    private Set<Set<TypeArgument>> cache = new HashSet<Set<TypeArgument>>();

    public LeastUpperBoundFinder(GenericTypeNavigator typeNavigator) {
        this.typeNavigator = typeNavigator;
    }

    public GenericType find(List<GenericType> types) {
        Set<GenericType> mec = this.calculateMinimalErasedCandidateSet(types);
        Map<GenericType, List<GenericType>> relevant = this.findRelevant(types, mec);
        return this.intersectArrays(IntersectionType.of(relevant.values().stream().map(this::leastContainingInvocation).collect(Collectors.toList())));
    }

    private GenericType intersectArrays(GenericType type) {
        if (!(type instanceof IntersectionType)) {
            return type;
        }
        Set<? extends GenericType> types = ((IntersectionType)type).getTypes();
        HashSet<GenericType> allTypes = new HashSet<GenericType>();
        LinkedHashSet<GenericType> arrayTypes = new LinkedHashSet<GenericType>();
        for (GenericType genericType : types) {
            if (genericType instanceof GenericArray) {
                GenericArray array = (GenericArray)genericType;
                arrayTypes.add(array.getElementType());
                continue;
            }
            allTypes.add(genericType);
        }
        if (!arrayTypes.isEmpty()) {
            allTypes.add(new GenericArray(this.intersectArrays(IntersectionType.of(arrayTypes))));
        }
        return IntersectionType.of(allTypes);
    }

    private Map<GenericType, List<GenericType>> findRelevant(List<GenericType> types, Set<GenericType> mec) {
        HashSet<GenericType> visited = new HashSet<GenericType>();
        LinkedHashMap<GenericType, List<GenericType>> relevant = new LinkedHashMap<GenericType, List<GenericType>>();
        for (GenericType type : types) {
            this.findRelevant(type, mec, visited, relevant);
        }
        return relevant;
    }

    private void findRelevant(GenericType type, Set<GenericType> mec, Set<GenericType> visited, Map<GenericType, List<GenericType>> relevant) {
        if (!visited.add(type)) {
            return;
        }
        if (mec.contains(type.erasure())) {
            relevant.computeIfAbsent(type.erasure(), k -> new ArrayList()).add(type);
        }
        for (GenericType genericType : this.getSupertypes(type)) {
            this.findRelevant(genericType, mec, visited, relevant);
        }
    }

    private GenericType leastContainingInvocation(List<GenericType> types) {
        if (types.get(0) instanceof GenericClass) {
            List<GenericClass> classes = types.stream().map(t -> (GenericClass)t).collect(Collectors.toList());
            assert (this.allClassesHaveSameNameAndArgCount(classes));
            ArrayList<TypeArgument> newArguments = new ArrayList<TypeArgument>();
            int argCount = classes.get(0).getArguments().size();
            int i = 0;
            while (i < argCount) {
                int argIndex = i++;
                List<TypeArgument> arguments = classes.stream().map(cls -> cls.getArguments().get(argIndex)).collect(Collectors.toList());
                newArguments.add(this.leastContainingTypeArgument(arguments));
            }
            return new GenericClass(classes.get(0).getName(), newArguments);
        }
        if (types.get(0) instanceof GenericArray) {
            List arrays = types.stream().map(t -> (GenericArray)t).collect(Collectors.toList());
            List<GenericType> arguments = arrays.stream().map(array -> array.getElementType()).collect(Collectors.toList());
            return new GenericArray(this.find(arguments));
        }
        assert (types.stream().allMatch(t -> ((GenericType)types.get(0)).equals(t)));
        return types.get(0);
    }

    private boolean allClassesHaveSameNameAndArgCount(List<GenericClass> classes) {
        String name = classes.get(0).getName();
        int argCount = classes.get(0).getArguments().size();
        for (int i = 1; i < classes.size(); ++i) {
            if (name.equals(classes.get(i).getName()) && argCount == classes.get(i).getArguments().size()) continue;
            return false;
        }
        return true;
    }

    private TypeArgument leastContainingTypeArgument(List<TypeArgument> arguments) {
        HashSet<TypeArgument> argumentSet = new HashSet<TypeArgument>(arguments);
        if (this.cache.add(argumentSet)) {
            TypeArgument result = (TypeArgument)arguments.stream().reduce(this::leastContainingTypeArgument).get();
            this.cache.remove(argumentSet);
            return result;
        }
        return TypeArgument.covariant(GenericType.OBJECT);
    }

    private TypeArgument leastContainingTypeArgument(TypeArgument a, TypeArgument b) {
        if (a.getVariance() == Variance.INVARIANT && b.getVariance() == Variance.INVARIANT) {
            if (a.getBound().equals(b.getBound())) {
                return a;
            }
            return TypeArgument.covariant(this.find(Arrays.asList(a.getBound(), b.getBound())));
        }
        if (a.getVariance() == Variance.COVARIANT && b.getVariance() == Variance.COVARIANT || a.getVariance() == Variance.COVARIANT && b.getVariance() == Variance.INVARIANT || a.getVariance() == Variance.INVARIANT && b.getVariance() == Variance.COVARIANT) {
            return TypeArgument.covariant(this.find(Arrays.asList(a.getBound(), b.getBound())));
        }
        if (a.getVariance() == Variance.CONTRAVARIANT && b.getVariance() == Variance.CONTRAVARIANT || a.getVariance() == Variance.CONTRAVARIANT && b.getVariance() == Variance.INVARIANT || a.getVariance() == Variance.INVARIANT && b.getVariance() == Variance.CONTRAVARIANT) {
            return TypeArgument.contravariant(IntersectionType.of(a.getBound(), b.getBound()));
        }
        if (a.getVariance() == Variance.COVARIANT && b.getVariance() == Variance.CONTRAVARIANT || a.getVariance() == Variance.CONTRAVARIANT && b.getVariance() == Variance.COVARIANT) {
            if (a.getBound().equals(b.getBound())) {
                return TypeArgument.invariant(a.getBound());
            }
            return TypeArgument.covariant(GenericType.OBJECT);
        }
        return TypeArgument.covariant(new GenericClass("java.lang.Object"));
    }

    private Collection<? extends GenericType> getSupertypes(GenericType type) {
        LinkedHashSet<GenericType> supertypes = new LinkedHashSet<GenericType>();
        if (type instanceof GenericClass) {
            GenericClass cls = (GenericClass)type;
            GenericClass parent = this.typeNavigator.getParent(cls);
            if (parent != null) {
                supertypes.add(parent);
            }
            supertypes.addAll(Arrays.asList(this.typeNavigator.getInterfaces(cls)));
        } else if (type instanceof GenericArray) {
            GenericType elementType = ((GenericArray)type).getElementType();
            for (GenericType genericType : this.getSupertypes(elementType)) {
                supertypes.add(new GenericArray(genericType));
            }
            supertypes.add(GenericType.OBJECT);
        } else if (type instanceof PrimitiveArray) {
            supertypes.add(GenericType.OBJECT);
        } else if (type instanceof GenericReference) {
            TypeVar typeVar = ((GenericReference)type).getVar();
            if (!typeVar.getUpperBound().isEmpty()) {
                supertypes.add(typeVar.getUpperBound().iterator().next());
            } else {
                supertypes.add(GenericType.OBJECT);
            }
        } else if (type instanceof IntersectionType) {
            ((IntersectionType)type).getTypes().stream().flatMap(t -> this.getSupertypes((GenericType)t).stream()).forEach(supertypes::add);
        }
        return supertypes;
    }

    private Set<GenericType> calculateMinimalErasedCandidateSet(List<GenericType> types) {
        MinimalErasedCandidateSet mec = new MinimalErasedCandidateSet(this.typeNavigator);
        for (GenericType type : types) {
            mec.add(type.erasure());
        }
        return mec.calculate();
    }

    static class MinimalErasedCandidateSet {
        private GenericTypeNavigator typeNavigator;
        private Map<GenericType, Node> nodes = new LinkedHashMap<GenericType, Node>();
        private int count;

        MinimalErasedCandidateSet(GenericTypeNavigator typeNavigator) {
            this.typeNavigator = typeNavigator;
        }

        Set<GenericType> calculate() {
            return this.nodes.values().stream().filter(node -> node.count == this.count && node.lowermost).map(node -> node.type).collect(Collectors.toSet());
        }

        void add(GenericType type) {
            ++this.count;
            this.addImpl(this.getNode(type), true);
        }

        private void addImpl(Node node, boolean lowermost) {
            if (node.mark == this.count) {
                return;
            }
            node.mark = this.count;
            node.lowermost = lowermost;
            boolean newLowermost = ++node.count < this.count;
            for (Node parent : node.parentNodes) {
                this.addImpl(parent, newLowermost);
            }
        }

        private Node getNode(GenericType type) {
            Node node = this.nodes.get(type);
            if (node == null) {
                node = new Node(type);
                this.nodes.put(type, node);
                for (GenericType genericType : this.getSupertypes(type)) {
                    node.parentNodes.add(this.getNode(genericType));
                }
            }
            return node;
        }

        private Collection<? extends GenericType> getSupertypes(GenericType type) {
            LinkedHashSet<GenericType> supertypes = new LinkedHashSet<GenericType>();
            if (type instanceof GenericClass) {
                ClassDescriber cls = this.typeNavigator.getClassRepository().describe(((GenericClass)type).getName());
                if (cls != null) {
                    if (cls.getSupertype() != null) {
                        supertypes.add(new GenericClass(cls.getSupertype().getName()));
                    }
                    for (GenericClass itf : cls.getInterfaces()) {
                        supertypes.add(new GenericClass(itf.getName()));
                    }
                    if (cls.isInterface() && cls.getSupertype() == null) {
                        supertypes.add(GenericType.OBJECT);
                    }
                }
            } else if (type instanceof GenericArray) {
                GenericType elementType = ((GenericArray)type).getElementType();
                for (GenericType genericType : this.getSupertypes(elementType)) {
                    supertypes.add(new GenericArray(genericType));
                }
                supertypes.add(GenericType.OBJECT);
            } else if (type instanceof PrimitiveArray) {
                supertypes.add(GenericType.OBJECT);
            } else if (type instanceof IntersectionType) {
                ((IntersectionType)type).getTypes().stream().flatMap(t -> this.getSupertypes((GenericType)t).stream()).forEach(supertypes::add);
            }
            return supertypes;
        }

        static class Node {
            GenericType type;
            List<Node> parentNodes = new ArrayList<Node>();
            int mark;
            int count;
            boolean lowermost;

            Node(GenericType type) {
                this.type = type;
            }
        }
    }
}

