/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.Objects;
import java.util.function.Function;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.Variance;

public class TypeArgument {
    private Variance variance;
    private GenericType bound;

    public TypeArgument(Variance variance, GenericType bound) {
        this.variance = variance;
        this.bound = bound;
    }

    public Variance getVariance() {
        return this.variance;
    }

    public GenericType getBound() {
        return this.bound;
    }

    public static TypeArgument invariant(GenericType type) {
        Objects.requireNonNull(type);
        return new TypeArgument(Variance.INVARIANT, type);
    }

    public static TypeArgument covariant(GenericType bound) {
        Objects.requireNonNull(bound);
        return new TypeArgument(Variance.COVARIANT, bound);
    }

    public static TypeArgument contravariant(GenericType bound) {
        Objects.requireNonNull(bound);
        return new TypeArgument(Variance.CONTRAVARIANT, bound);
    }

    public TypeArgument mapBound(Function<GenericType, GenericType> f) {
        GenericType mappedBound = f.apply(this.bound);
        return mappedBound != this.bound ? new TypeArgument(this.variance, mappedBound) : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeArgument that = (TypeArgument)o;
        return this.variance == that.variance && Objects.equals(this.bound, that.bound);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.variance, this.bound});
    }
}

