/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teavm.flavour.expr.type.GenericArray;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.IntersectionType;
import org.teavm.flavour.expr.type.LeastUpperBoundFinder;
import org.teavm.flavour.expr.type.MapSubstitutions;
import org.teavm.flavour.expr.type.NullType;
import org.teavm.flavour.expr.type.Primitive;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeInferenceStatePoint;
import org.teavm.flavour.expr.type.TypeUtils;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.Variance;

public class TypeInference {
    private GenericTypeNavigator typeNavigator;
    private Map<TypeVar, InferenceVar> inferenceVars = new LinkedHashMap<TypeVar, InferenceVar>();
    private Set<InferenceVar> unresolvedVars = new HashSet<InferenceVar>();
    private LeastUpperBoundFinder lubFinder;
    List<TypeInferenceStatePoint> statePoints = new ArrayList<TypeInferenceStatePoint>();
    TypeInferenceStatePoint currentStatePoint;
    private Substitutions substitutions = var -> {
        InferenceVar inferenceVar = this.inferenceVars.get(var);
        return inferenceVar != null ? inferenceVar.find().instantiation : null;
    };

    public TypeInference(GenericTypeNavigator typeNavigator) {
        this.typeNavigator = typeNavigator;
        this.lubFinder = new LeastUpperBoundFinder(typeNavigator);
        this.statePoints.add(new TypeInferenceStatePoint(this, 0));
        this.currentStatePoint = this.statePoints.get(0);
    }

    public TypeInferenceStatePoint createStatePoint() {
        TypeInferenceStatePoint statePoint = new TypeInferenceStatePoint(this, this.statePoints.size());
        TypeInferenceStatePoint previousStatePoint = this.currentStatePoint;
        this.statePoints.add(statePoint);
        this.currentStatePoint = statePoint;
        return previousStatePoint;
    }

    void rollBack(TypeInferenceStatePoint statePoint) {
        if (statePoint.addedTypeVars != null) {
            this.inferenceVars.keySet().removeAll(statePoint.addedTypeVars);
        }
        if (statePoint.inferenceVarsBackup != null) {
            for (Map.Entry<Object, InferenceVar> entry : statePoint.inferenceVarsBackup.entrySet()) {
                InferenceVar inferenceVar = (InferenceVar)entry.getKey();
                inferenceVar.restore(entry.getValue());
            }
        }
        if (statePoint.inferenceVarMapBackup != null) {
            for (Map.Entry<Object, InferenceVar> entry : statePoint.inferenceVarMapBackup.entrySet()) {
                if (!this.inferenceVars.containsKey(entry.getKey())) continue;
                this.inferenceVars.put((TypeVar)entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean addVariables(Collection<? extends TypeVar> vars) {
        for (TypeVar typeVar : vars) {
            if (this.inferenceVars.containsKey(typeVar)) continue;
            InferenceVar inferenceVar = new InferenceVar(typeVar);
            this.inferenceVars.put(typeVar, inferenceVar);
            this.currentStatePoint.addTypeVar(typeVar);
        }
        for (InferenceVar inferenceVar : this.inferenceVars.values()) {
            for (TypeVar typeVar : inferenceVar.variables) {
                for (GenericType genericType : typeVar.getLowerBound()) {
                    if (inferenceVar.addLowerBound(genericType)) continue;
                    inferenceVar.fail();
                    return false;
                }
                for (GenericType genericType : typeVar.getUpperBound()) {
                    if (inferenceVar.addUpperBound(genericType)) continue;
                    inferenceVar.fail();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean resolve() {
        this.unresolvedVars = new HashSet<InferenceVar>(this.inferenceVars.values());
        while (!this.unresolvedVars.isEmpty()) {
            this.unresolvedVars = new LinkedHashSet<InferenceVar>(this.inferenceVars.values().stream().map(InferenceVar::find).filter(v -> v.instantiation == null).collect(Collectors.toList()));
            Set<InferenceVar> variablesToResolve = this.findVariablesToResolve();
            if (variablesToResolve.stream().noneMatch(v -> v.captureConversionBound != null)) {
                TypeInferenceStatePoint statePoint = this.createStatePoint();
                if (this.resolveVariablesSimple(variablesToResolve)) continue;
                statePoint.restoreTo();
            }
            if (this.resolveVariablesCaptured(variablesToResolve)) continue;
            return false;
        }
        return true;
    }

    private boolean resolveVariablesSimple(Collection<? extends InferenceVar> variablesToResolve) {
        HashMap improperLowerBounds = new HashMap();
        HashMap improperUpperBounds = new HashMap();
        HashMap<InferenceVar, GenericType> improperExactBounds = new HashMap<InferenceVar, GenericType>();
        for (InferenceVar inferenceVar : variablesToResolve) {
            improperLowerBounds.put(inferenceVar, inferenceVar.lowerBounds.stream().filter(bound -> !this.isProperType((ValueType)bound)).collect(Collectors.toList()));
            improperUpperBounds.put(inferenceVar, inferenceVar.upperBounds.stream().filter(bound -> !this.isProperType((ValueType)bound)).collect(Collectors.toList()));
            if (inferenceVar.exactBound != null && !this.isProperType(inferenceVar.exactBound)) {
                inferenceVar.takeSnapshot();
                improperExactBounds.put(inferenceVar, inferenceVar.exactBound);
                inferenceVar.exactBound = null;
            }
            if (this.resolveSimple(inferenceVar)) continue;
            return false;
        }
        for (InferenceVar inferenceVar : variablesToResolve) {
            inferenceVar.takeSnapshot();
            inferenceVar.instantiation = inferenceVar.pendingInstantiation;
            inferenceVar.exactBound = inferenceVar.pendingInstantiation;
        }
        for (InferenceVar inferenceVar : variablesToResolve) {
            for (GenericType bound2 : (List)improperLowerBounds.get(inferenceVar)) {
                if (inferenceVar.addLowerBound(bound2.substitute(this.substitutions))) continue;
                return false;
            }
            for (GenericType bound2 : (List)improperUpperBounds.get(inferenceVar)) {
                if (inferenceVar.addUpperBound(bound2.substitute(this.substitutions))) continue;
                return false;
            }
            GenericType exactBound = (GenericType)improperExactBounds.get(inferenceVar);
            if (exactBound == null || inferenceVar.addExactBound(exactBound.substitute(this.substitutions))) continue;
            return false;
        }
        return true;
    }

    private boolean resolveVariablesCaptured(Collection<? extends InferenceVar> variablesToResolve) {
        InferenceVar originalVar;
        int i;
        for (InferenceVar inferenceVar : variablesToResolve) {
            inferenceVar.takeSnapshot();
        }
        ArrayList<? extends InferenceVar> originalVariables = new ArrayList<InferenceVar>(variablesToResolve);
        ArrayList<TypeVar> arrayList = new ArrayList<TypeVar>();
        HashMap<TypeVar, GenericType> typeMap = new HashMap<TypeVar, GenericType>();
        for (int i2 = 0; i2 < originalVariables.size(); ++i2) {
            TypeVar freshTypeVar = new TypeVar();
            arrayList.add(freshTypeVar);
            for (TypeVar originalTypeVar : ((InferenceVar)originalVariables.get((int)i2)).variables) {
                typeMap.put(originalTypeVar, new GenericReference(freshTypeVar));
            }
        }
        MapSubstitutions freshSubstitutions = new MapSubstitutions(typeMap);
        for (i = 0; i < originalVariables.size(); ++i) {
            originalVar = (InferenceVar)originalVariables.get(i);
            List<GenericType> lowerBounds = originalVar.lowerBounds.stream().filter(this::isProperType).map(b -> b.substitute(this.substitutions)).collect(Collectors.toList());
            if (!lowerBounds.isEmpty()) {
                ((TypeVar)arrayList.get(i)).withLowerBound(this.lubFinder.find(lowerBounds));
                continue;
            }
            List upperBounds = originalVar.upperBounds.stream().map(b -> b.substitute(this.substitutions)).map(b -> b.substitute(freshSubstitutions)).collect(Collectors.toList());
            ((TypeVar)arrayList.get(i)).withUpperBound(this.intersect(upperBounds));
        }
        for (i = 0; i < originalVariables.size(); ++i) {
            originalVar = (InferenceVar)originalVariables.get(i);
            originalVar.instantiation = new GenericReference((TypeVar)arrayList.get(i));
            originalVar.captureConversionBound = null;
        }
        return true;
    }

    private Set<InferenceVar> findVariablesToResolve() {
        this.calculateUnresolvedDependantVars();
        HashSet<InferenceVar> result = new HashSet<InferenceVar>();
        HashSet<InferenceVar> visited = new HashSet<InferenceVar>();
        HashSet<InferenceVar> visiting = new HashSet<InferenceVar>();
        ArrayList<InferenceVar> path = new ArrayList<InferenceVar>();
        for (InferenceVar var : this.unresolvedVars) {
            this.findVariablesToResolve(var, result, visited, visiting, path);
        }
        return result;
    }

    private void findVariablesToResolve(InferenceVar currentVar, Set<InferenceVar> result, Set<InferenceVar> visited, Set<InferenceVar> visiting, List<InferenceVar> path) {
        if (visited.contains(currentVar)) {
            return;
        }
        visiting.add(currentVar);
        path.add(currentVar);
        int bestMatchingIndex = path.size() - 1;
        boolean matched = true;
        for (InferenceVar dependantVar : currentVar.unresolvedDependantVars) {
            if (visiting.contains(dependantVar)) {
                bestMatchingIndex = Math.min(bestMatchingIndex, path.lastIndexOf(dependantVar));
                continue;
            }
            matched = false;
            this.findVariablesToResolve(dependantVar, result, visited, visiting, path);
        }
        if (matched) {
            result.addAll(path.subList(bestMatchingIndex, path.size()));
        }
        path.remove(path.size() - 1);
        visited.add(currentVar);
        visiting.remove(currentVar);
    }

    private void calculateUnresolvedDependantVars() {
        for (InferenceVar v : this.inferenceVars.values()) {
            v.unresolvedDependantVars.clear();
        }
        for (InferenceVar v : this.inferenceVars.values()) {
            Stream<Stream> stream = Stream.of(v.lowerBounds.stream(), v.upperBounds.stream(), v.exactBound != null ? Stream.of(v.exactBound) : Stream.empty());
            List varsInConstraints = stream.flatMap(types -> types).flatMap(this::collectInferenceVars).filter(var -> var.instantiation == null).collect(Collectors.toList());
            if (v.captureConversionBound == null) {
                v.unresolvedDependantVars.addAll(varsInConstraints);
                continue;
            }
            for (InferenceVar inferenceVar : varsInConstraints) {
                inferenceVar.unresolvedDependantVars.add(v);
            }
            for (InferenceVar inferenceVar : v.captureConversionBound.captureConversion.captureVars) {
                if (inferenceVar == v || inferenceVar == null) continue;
                v.unresolvedDependantVars.add(inferenceVar);
            }
        }
    }

    private boolean resolveSimple(InferenceVar inferenceVar) {
        if (inferenceVar.exactBound != null && this.isProperType(inferenceVar.exactBound)) {
            inferenceVar.pendingInstantiation = inferenceVar.exactBound;
            return true;
        }
        List<GenericType> lowerBounds = inferenceVar.lowerBounds.stream().filter(this::isProperType).map(b -> b.substitute(this.substitutions)).collect(Collectors.toList());
        if (!lowerBounds.isEmpty()) {
            inferenceVar.pendingInstantiation = this.lubFinder.find(lowerBounds);
            return true;
        }
        List upperBounds = inferenceVar.upperBounds.stream().filter(this::isProperType).map(b -> b.substitute(this.substitutions)).collect(Collectors.toList());
        if (!upperBounds.isEmpty()) {
            inferenceVar.pendingInstantiation = this.intersect(upperBounds);
            return true;
        }
        inferenceVar.pendingInstantiation = GenericType.OBJECT;
        return true;
    }

    private GenericType intersect(Collection<? extends GenericType> types) {
        if (types.isEmpty()) {
            return NullType.INSTANCE;
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        HashSet<GenericType> result = new HashSet<GenericType>();
        HashSet<GenericClass> classes = new HashSet<GenericClass>();
        HashSet<GenericType> arrays = new HashSet<GenericType>();
        ArrayList<? extends GenericType> flattenedTypes = new ArrayList<GenericType>();
        for (GenericType genericType : types) {
            if (genericType instanceof IntersectionType) {
                flattenedTypes.addAll(((IntersectionType)genericType).getTypes());
                continue;
            }
            flattenedTypes.add(genericType);
        }
        for (GenericType genericType : flattenedTypes) {
            if (genericType instanceof GenericClass) {
                classes.add((GenericClass)genericType);
                continue;
            }
            if (genericType instanceof GenericArray) {
                arrays.add(((GenericArray)genericType).getElementType());
                continue;
            }
            result.add(genericType);
        }
        if (!classes.isEmpty()) {
            result.addAll(this.intersectClasses(classes));
        }
        if (!arrays.isEmpty()) {
            result.add(new GenericArray(IntersectionType.of(this.intersect(arrays))));
        }
        return IntersectionType.of(result);
    }

    private Collection<? extends GenericClass> intersectClasses(Collection<? extends GenericClass> classes) {
        if (classes.size() == 1) {
            return classes;
        }
        HashSet<GenericClass> allSuperClasses = new HashSet<GenericClass>();
        for (GenericClass genericClass : classes) {
            List<GenericClass> path = this.typeNavigator.sublassPath(genericClass, "java.lang.Object");
            for (int i = 1; i < path.size() && allSuperClasses.add(path.get(i)); ++i) {
            }
        }
        return classes.stream().filter(cls -> !allSuperClasses.contains(cls)).collect(Collectors.toList());
    }

    public boolean equalConstraint(ValueType a, ValueType b) {
        if (a == b) {
            return true;
        }
        if (a instanceof GenericType) {
            a = ((GenericType)a).substitute(this.substitutions);
        }
        if (b instanceof GenericType) {
            b = ((GenericType)b).substitute(this.substitutions);
        }
        if (this.isProperType(a) && this.isProperType(b)) {
            return a.equals(b);
        }
        if (a instanceof NullType || b instanceof NullType) {
            return false;
        }
        if (this.isInferenceVar(a) && this.isInferenceVar(b)) {
            InferenceVar var1 = this.inferenceVars.get(((GenericReference)a).getVar());
            InferenceVar var2 = this.inferenceVars.get(((GenericReference)b).getVar());
            return !var1.union((InferenceVar)var2).inferenceFailed;
        }
        if (this.isInferenceVar(a) && b instanceof GenericType) {
            return this.inferenceVars.get(((GenericReference)a).getVar()).addExactBound((GenericType)b);
        }
        if (this.isInferenceVar(b) && a instanceof GenericType) {
            return this.inferenceVars.get(((GenericReference)b).getVar()).addExactBound((GenericType)a);
        }
        if (a instanceof GenericClass && b instanceof GenericClass) {
            GenericClass s = (GenericClass)a;
            GenericClass t = (GenericClass)b;
            if (!s.getName().equals(t.getName()) || s.getArguments().size() != t.getArguments().size()) {
                return false;
            }
            for (int i = 0; i < s.getArguments().size(); ++i) {
                if (this.equalConstraint(s.getArguments().get(i), t.getArguments().get(i))) continue;
                return false;
            }
            return true;
        }
        if (a instanceof GenericArray && b instanceof GenericArray) {
            GenericArray s = (GenericArray)a;
            GenericArray t = (GenericArray)b;
            return this.equalConstraint(s.getElementType(), t.getElementType());
        }
        return false;
    }

    private boolean equalConstraint(TypeArgument a, TypeArgument b) {
        return a.getVariance() == b.getVariance() && this.equalConstraint(a.getBound(), b.getBound());
    }

    public boolean subtypeConstraint(ValueType subtype, ValueType supertype) {
        if (subtype instanceof GenericType) {
            subtype = ((GenericType)subtype).substitute(this.substitutions);
        }
        if (supertype instanceof GenericType) {
            supertype = ((GenericType)supertype).substitute(this.substitutions);
        }
        if (subtype instanceof Primitive && supertype instanceof Primitive) {
            return TypeUtils.isPrimitiveSubType((Primitive)subtype, (Primitive)supertype);
        }
        if (subtype instanceof Primitive && supertype instanceof GenericClass) {
            return (supertype = TypeUtils.tryUnbox((GenericType)supertype)) instanceof Primitive && TypeUtils.isPrimitiveSubType((Primitive)subtype, (Primitive)supertype);
        }
        if (supertype instanceof Primitive && subtype instanceof GenericClass) {
            return (subtype = TypeUtils.tryUnbox((GenericType)subtype)) instanceof Primitive && TypeUtils.isPrimitiveSubType((Primitive)subtype, (Primitive)supertype);
        }
        if (subtype instanceof NullType) {
            return !(supertype instanceof Primitive);
        }
        if (this.isInferenceVar(subtype)) {
            if (!((supertype = TypeUtils.tryBox(supertype)) instanceof GenericType)) {
                return false;
            }
            InferenceVar inferenceVar = this.inferenceVars.get(((GenericReference)subtype).getVar());
            return inferenceVar.addUpperBound((GenericType)supertype);
        }
        if (this.isInferenceVar(supertype)) {
            if (!((subtype = TypeUtils.tryBox(subtype)) instanceof GenericType)) {
                return false;
            }
            InferenceVar inferenceVar = this.inferenceVars.get(((GenericReference)supertype).getVar());
            return inferenceVar.addLowerBound((GenericType)subtype);
        }
        if (subtype instanceof GenericClass && supertype instanceof GenericClass) {
            GenericClass subclass = (GenericClass)subtype;
            GenericClass superclass = (GenericClass)supertype;
            List<GenericClass> path = this.typeNavigator.sublassPath(subclass, superclass.getName());
            if (path == null) {
                return false;
            }
            List<? extends TypeArgument> subclassArgs = path.get(path.size() - 1).getArguments();
            List<? extends TypeArgument> superclassArgs = superclass.getArguments();
            if (subclassArgs.size() != subclassArgs.size()) {
                return false;
            }
            for (int i = 0; i < subclassArgs.size(); ++i) {
                if (this.isContainedBy(subclassArgs.get(i), superclassArgs.get(i))) continue;
                return false;
            }
            return true;
        }
        if (supertype instanceof GenericClass && ((GenericClass)supertype).getName().equals("java.lang.Object") && subtype instanceof GenericType) {
            return true;
        }
        if (subtype instanceof GenericArray && supertype instanceof GenericArray) {
            return this.subtypeConstraint(((GenericArray)subtype).getElementType(), ((GenericArray)supertype).getElementType());
        }
        if (subtype instanceof GenericReference) {
            TypeVar var = ((GenericReference)subtype).getVar();
            if (supertype instanceof GenericReference && var == ((GenericReference)supertype).getVar()) {
                return true;
            }
            ValueType supertypeCopy = supertype;
            return var.getUpperBound().stream().anyMatch(ub -> this.subtypeConstraint((ValueType)ub, supertypeCopy));
        }
        return false;
    }

    private boolean isContainedBy(TypeArgument a, TypeArgument b) {
        if (a.getVariance() == Variance.COVARIANT && b.getVariance() == Variance.COVARIANT) {
            return this.subtypeConstraint(a.getBound(), b.getBound());
        }
        if ((a.getVariance() == Variance.CONTRAVARIANT || a.getVariance() == Variance.INVARIANT) && b.getVariance() == Variance.CONTRAVARIANT) {
            return this.subtypeConstraint(b.getBound(), a.getBound());
        }
        if (a.getVariance() == Variance.INVARIANT) {
            return this.equalConstraint(a.getBound(), b.getBound());
        }
        return false;
    }

    public List<? extends TypeArgument> captureConversionConstraint(List<? extends TypeVar> typeParameters, List<? extends TypeArgument> typeArguments) {
        InferenceVar captureVar;
        int i;
        TypeVar freshTypeVar;
        if (typeArguments.size() != typeArguments.size()) {
            throw new IllegalArgumentException("Number of type parameters (" + typeArguments.size() + ") is not equal to number of type arguments (" + typeArguments.size() + ")");
        }
        ArrayList<TypeVar> captureTypeVars = new ArrayList<TypeVar>();
        ArrayList<TypeArgument> resultList = new ArrayList<TypeArgument>();
        ArrayList<InferenceVar> captureVars = new ArrayList<InferenceVar>();
        for (int i2 = 0; i2 < typeParameters.size(); ++i2) {
            freshTypeVar = typeArguments.get(i2).getVariance() != Variance.INVARIANT ? new TypeVar() : null;
            captureTypeVars.add(freshTypeVar);
            resultList.add(freshTypeVar != null ? TypeArgument.invariant(new GenericReference(freshTypeVar)) : typeArguments.get(i2));
        }
        if (!this.addVariables(captureTypeVars.stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            return null;
        }
        for (int i2 = 0; i2 < typeParameters.size(); ++i2) {
            freshTypeVar = (TypeVar)captureTypeVars.get(i2);
            captureVars.add(freshTypeVar != null ? this.inferenceVars.get(freshTypeVar) : null);
        }
        CaptureConversion capture = new CaptureConversion(captureVars, typeParameters, typeArguments);
        for (i = 0; i < typeParameters.size(); ++i) {
            captureVar = (InferenceVar)captureVars.get(i);
            if (captureVar == null) continue;
            captureVar.captureConversionBound = new CaptureConversionBound(capture, i);
        }
        block8: for (i = 0; i < typeParameters.size(); ++i) {
            captureVar = (InferenceVar)captureVars.get(i);
            if (captureVar == null) continue;
            for (GenericType genericType : typeParameters.get(i).getLowerBound()) {
                if (captureVar.addLowerBound(genericType)) continue;
                return null;
            }
            for (GenericType genericType : typeParameters.get(i).getUpperBound()) {
                if (captureVar.addUpperBound(genericType)) continue;
                return null;
            }
            TypeArgument typeArgument = typeArguments.get(i);
            switch (typeArgument.getVariance()) {
                case INVARIANT: {
                    if (captureVar.addExactBound(typeArgument.getBound())) continue block8;
                    return null;
                }
                case COVARIANT: {
                    if (captureVar.addUpperBound(typeArgument.getBound())) continue block8;
                    return null;
                }
                case CONTRAVARIANT: {
                    if (captureVar.addLowerBound(typeArgument.getBound())) continue block8;
                    return null;
                }
            }
        }
        return resultList;
    }

    public Substitutions getSubstitutions() {
        return this.substitutions;
    }

    private boolean isInferenceVar(ValueType type) {
        return type instanceof GenericReference && this.isInferenceVar(((GenericReference)type).getVar());
    }

    private boolean isInferenceVar(TypeVar typeVar) {
        InferenceVar inferenceVar = this.inferenceVars.get(typeVar);
        return inferenceVar != null && inferenceVar.find().instantiation == null;
    }

    private boolean isProperType(ValueType type) {
        return !this.collectInferenceVars(type).findAny().isPresent();
    }

    private Stream<InferenceVar> collectInferenceVars(ValueType type) {
        if (type instanceof GenericReference) {
            InferenceVar inferenceVar = this.inferenceVars.get(((GenericReference)type).getVar());
            if (inferenceVar == null) {
                return Stream.empty();
            }
            inferenceVar = inferenceVar.find();
            return inferenceVar.instantiation == null ? Stream.of(inferenceVar) : Stream.empty();
        }
        if (type instanceof GenericClass) {
            return ((GenericClass)type).getArguments().stream().map(arg -> arg.getBound()).flatMap(this::collectInferenceVars);
        }
        if (type instanceof GenericArray) {
            return this.collectInferenceVars(((GenericArray)type).getElementType());
        }
        return Stream.empty();
    }

    class CaptureConversionBound {
        CaptureConversion captureConversion;
        int index;

        CaptureConversionBound(CaptureConversion captureConversion, int index) {
            this.captureConversion = captureConversion;
            this.index = index;
        }
    }

    class CaptureConversion {
        List<? extends InferenceVar> captureVars;
        List<? extends TypeVar> parameters;
        List<? extends TypeArgument> arguments;
        Substitutions substitutions;

        CaptureConversion(List<? extends InferenceVar> captureVars, List<? extends TypeVar> parameters, List<? extends TypeArgument> arguments) {
            this.captureVars = captureVars;
            this.parameters = parameters;
            this.arguments = arguments;
            MapSubstitutions substitutions = new MapSubstitutions(new HashMap<TypeVar, GenericType>());
            for (int i = 0; i < captureVars.size(); ++i) {
                InferenceVar capturingInferenceVar = captureVars.get(i);
                if (capturingInferenceVar == null) continue;
                TypeVar capturingVar = capturingInferenceVar.variables.iterator().next();
                substitutions.getMap().put(parameters.get(i), new GenericReference(capturingVar));
                TypeInference.this.inferenceVars.put(parameters.get(i), captureVars.get(i));
            }
            this.substitutions = substitutions;
        }
    }

    class InferenceVar {
        InferenceVar parent;
        int rank;
        Set<TypeVar> variables = new LinkedHashSet<TypeVar>();
        Set<GenericType> lowerBounds = new LinkedHashSet<GenericType>();
        Set<GenericType> upperBounds = new LinkedHashSet<GenericType>();
        CaptureConversionBound captureConversionBound;
        GenericType exactBound;
        GenericType instantiation;
        GenericType pendingInstantiation;
        boolean inferenceFailed;
        Set<InferenceVar> unresolvedDependantVars = new LinkedHashSet<InferenceVar>();

        InferenceVar(TypeVar var) {
            this.variables.add(var);
            this.lowerBounds.addAll(var.getLowerBound());
            this.upperBounds.addAll(var.getUpperBound());
        }

        private InferenceVar() {
        }

        InferenceVar backup() {
            InferenceVar copy = new InferenceVar();
            copy.parent = this.parent;
            copy.rank = this.rank;
            copy.variables.addAll(this.variables);
            copy.lowerBounds.addAll(this.lowerBounds);
            copy.upperBounds.addAll(this.upperBounds);
            copy.captureConversionBound = this.captureConversionBound;
            copy.exactBound = this.exactBound;
            copy.instantiation = this.instantiation;
            copy.inferenceFailed = this.inferenceFailed;
            return copy;
        }

        void restore(InferenceVar backup) {
            this.parent = backup.parent;
            this.rank = backup.rank;
            this.variables.retainAll(backup.variables);
            this.lowerBounds.retainAll(backup.lowerBounds);
            this.upperBounds.retainAll(backup.upperBounds);
            this.captureConversionBound = backup.captureConversionBound;
            this.exactBound = backup.exactBound;
            this.instantiation = backup.instantiation;
            this.inferenceFailed = backup.inferenceFailed;
        }

        void takeSnapshot() {
            TypeInference.this.currentStatePoint.backup(this);
        }

        InferenceVar find() {
            if (this.parent == null) {
                return this;
            }
            if (this.parent.parent == null) {
                return this.parent;
            }
            ArrayList<InferenceVar> path = new ArrayList<InferenceVar>();
            InferenceVar v = this;
            while (v.parent != null) {
                path.add(v);
                v = v.parent;
            }
            for (InferenceVar u : path) {
                u.takeSnapshot();
                u.parent = v;
            }
            return v;
        }

        private TypeArgument getCaptureTypeArgument() {
            if (this.captureConversionBound == null) {
                return null;
            }
            return this.captureConversionBound.captureConversion.arguments.get(this.captureConversionBound.index);
        }

        private TypeVar getCaptureTypeParameter() {
            if (this.captureConversionBound == null) {
                return null;
            }
            return this.captureConversionBound.captureConversion.parameters.get(this.captureConversionBound.index);
        }

        private boolean shouldIncorporateWithCaptureConversion(GenericType type) {
            return this.captureConversionBound != null && type instanceof GenericReference && !TypeInference.this.isProperType(type);
        }

        boolean addExactBound(GenericType type) {
            if (this.shouldIncorporateWithCaptureConversion(type)) {
                return false;
            }
            type = type.substitute(TypeInference.this.substitutions);
            if (this.exactBound == null) {
                this.takeSnapshot();
                this.exactBound = type;
                for (GenericType lowerBound : this.lowerBounds) {
                    if (TypeInference.this.subtypeConstraint(lowerBound, this.exactBound)) continue;
                    return false;
                }
                for (GenericType upperBound : this.upperBounds) {
                    if (TypeInference.this.subtypeConstraint(this.exactBound, upperBound)) continue;
                    return false;
                }
            } else if (!TypeInference.this.equalConstraint(this.exactBound, type)) {
                return false;
            }
            return true;
        }

        private GenericType substituteCaptureConversion(GenericType type) {
            return type.substitute(this.captureConversionBound.captureConversion.substitutions);
        }

        boolean addUpperBound(GenericType type) {
            if (!this.addUpperBoundNoCaptureConversion(type)) {
                return false;
            }
            if (this.shouldIncorporateWithCaptureConversion(type)) {
                TypeArgument argument = this.getCaptureTypeArgument();
                TypeVar parameter = this.getCaptureTypeParameter();
                GenericType parameterBound = !parameter.getUpperBound().isEmpty() ? IntersectionType.of(parameter.getUpperBound()) : GenericType.OBJECT;
                switch (argument.getVariance()) {
                    case COVARIANT: {
                        GenericType bound;
                        if (argument.getBound().equals(GenericType.OBJECT) && !TypeInference.this.subtypeConstraint(bound = this.substituteCaptureConversion(parameterBound), type)) {
                            return false;
                        }
                        if (!parameterBound.equals(GenericType.OBJECT) || TypeInference.this.subtypeConstraint(argument.getBound(), type)) break;
                        return false;
                    }
                    case CONTRAVARIANT: {
                        GenericType bound = this.substituteCaptureConversion(parameterBound);
                        if (TypeInference.this.subtypeConstraint(bound, type)) break;
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean addUpperBoundNoCaptureConversion(GenericType type) {
            InferenceVar that;
            if (type instanceof GenericReference && this.variables.contains(((GenericReference)type).getVar())) {
                return true;
            }
            if (type instanceof IntersectionType) {
                return ((IntersectionType)type).getTypes().stream().allMatch(this::addUpperBound);
            }
            type = type.substitute(TypeInference.this.substitutions);
            this.takeSnapshot();
            if (!this.upperBounds.add(type)) {
                return true;
            }
            if (this.exactBound != null && !TypeInference.this.subtypeConstraint(this.exactBound, type)) {
                return false;
            }
            for (GenericType lowerBound : this.lowerBounds) {
                if (TypeInference.this.subtypeConstraint(lowerBound, type)) continue;
                return false;
            }
            if (type instanceof GenericReference && (that = (InferenceVar)TypeInference.this.inferenceVars.get(((GenericReference)type).getVar())) != null) {
                for (TypeVar var : this.variables) {
                    that.addLowerBound(new GenericReference(var));
                }
            }
            return true;
        }

        boolean addLowerBound(GenericType type) {
            if (!this.addLowerBoundNoCaptureConversion(type)) {
                return false;
            }
            if (this.shouldIncorporateWithCaptureConversion(type)) {
                TypeArgument argument = this.getCaptureTypeArgument();
                switch (argument.getVariance()) {
                    case COVARIANT: {
                        return false;
                    }
                    case CONTRAVARIANT: {
                        if (TypeInference.this.subtypeConstraint(type, argument.getBound())) break;
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean addLowerBoundNoCaptureConversion(GenericType type) {
            InferenceVar that;
            if (type instanceof GenericReference && this.variables.contains(((GenericReference)type).getVar())) {
                return true;
            }
            type = type.substitute(TypeInference.this.substitutions);
            this.takeSnapshot();
            if (!this.lowerBounds.add(type)) {
                return true;
            }
            if (this.exactBound != null && !TypeInference.this.subtypeConstraint(type, this.exactBound)) {
                return false;
            }
            for (GenericType upperBound : this.upperBounds) {
                if (TypeInference.this.subtypeConstraint(type, upperBound)) continue;
                return false;
            }
            if (type instanceof GenericReference && (that = (InferenceVar)TypeInference.this.inferenceVars.get(((GenericReference)type).getVar())) != null) {
                for (TypeVar var : this.variables) {
                    that.addUpperBound(new GenericReference(var));
                }
            }
            return true;
        }

        InferenceVar union(InferenceVar other) {
            return this.find().unionImpl(other.find());
        }

        private InferenceVar unionImpl(InferenceVar other) {
            if (this == other) {
                return this;
            }
            this.takeSnapshot();
            other.takeSnapshot();
            if (this.rank > other.rank) {
                other.parent = this;
                if (!this.mergeData(other)) {
                    this.fail();
                }
                return this;
            }
            if (this.rank < other.rank) {
                this.parent = other;
                if (!other.mergeData(this)) {
                    this.fail();
                }
                return other;
            }
            other.parent = this;
            ++this.rank;
            if (!this.mergeData(other)) {
                this.fail();
            }
            return this;
        }

        private boolean mergeData(InferenceVar other) {
            if (this.instantiation != null && other.instantiation != null) {
                return this.instantiation.equals(other.instantiation);
            }
            if (this.instantiation != null) {
                return other.addExactBound(this.instantiation);
            }
            if (other.instantiation != null) {
                return this.addExactBound(other.instantiation);
            }
            this.variables.addAll(other.variables);
            ArrayList<GenericType> existingLowerBounds = new ArrayList<GenericType>(this.lowerBounds);
            ArrayList<GenericType> existingUpperBounds = new ArrayList<GenericType>(this.upperBounds);
            ArrayList<GenericType> newLowerBounds = new ArrayList<GenericType>(other.lowerBounds);
            ArrayList<GenericType> newUpperBounds = new ArrayList<GenericType>(other.upperBounds);
            GenericType existingExactBound = this.exactBound;
            GenericType newExactBound = other.exactBound;
            if (existingExactBound != null) {
                if (newExactBound != null && !TypeInference.this.equalConstraint(existingExactBound, newExactBound)) {
                    return false;
                }
            } else {
                this.exactBound = newExactBound;
            }
            this.lowerBounds.addAll(newLowerBounds);
            this.upperBounds.addAll(newUpperBounds);
            if (!this.incorporateLowerAndUpperBoundsWithExactBound(newExactBound, existingLowerBounds, existingUpperBounds)) {
                return false;
            }
            if (!this.incorporateLowerAndUpperBoundsWithExactBound(existingExactBound, newLowerBounds, newUpperBounds)) {
                return false;
            }
            if (!this.incorporateLowerAndUpperBounds(existingLowerBounds, newUpperBounds)) {
                return false;
            }
            if (!this.incorporateLowerAndUpperBounds(newLowerBounds, existingUpperBounds)) {
                return false;
            }
            for (TypeVar var : other.variables) {
                if (TypeInference.this.currentStatePoint.inferenceVarMapBackup == null) {
                    TypeInference.this.currentStatePoint.inferenceVarMapBackup = new HashMap<TypeVar, InferenceVar>();
                }
                InferenceVar old = TypeInference.this.inferenceVars.put(var, this);
                TypeInference.this.currentStatePoint.inferenceVarMapBackup.put(var, old);
            }
            return true;
        }

        private boolean incorporateLowerAndUpperBoundsWithExactBound(GenericType exactBound, List<GenericType> lowerBounds, List<GenericType> upperBounds) {
            if (exactBound != null) {
                for (GenericType lowerBound : lowerBounds) {
                    if (TypeInference.this.subtypeConstraint(lowerBound, exactBound)) continue;
                    return false;
                }
                for (GenericType upperBound : upperBounds) {
                    if (TypeInference.this.subtypeConstraint(exactBound, upperBound)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean incorporateLowerAndUpperBounds(List<GenericType> lowerBounds, List<GenericType> upperBounds) {
            for (GenericType lowerBound : lowerBounds) {
                for (GenericType upperBound : upperBounds) {
                    if (TypeInference.this.subtypeConstraint(lowerBound, upperBound)) continue;
                    return false;
                }
            }
            return true;
        }

        void fail() {
            this.takeSnapshot();
            if (!this.inferenceFailed) {
                this.inferenceFailed = true;
            }
        }
    }
}

