/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.flavour.expr.type.TypeInference;
import org.teavm.flavour.expr.type.TypeVar;

public class TypeInferenceStatePoint
implements AutoCloseable {
    TypeInference typeInference;
    int index;
    Set<TypeVar> addedTypeVars;
    Map<TypeInference.InferenceVar, TypeInference.InferenceVar> inferenceVarsBackup;
    Map<TypeVar, TypeInference.InferenceVar> inferenceVarMapBackup;

    TypeInferenceStatePoint(TypeInference typeInference, int index) {
        this.typeInference = typeInference;
        this.index = index;
    }

    void addTypeVar(TypeVar typeVar) {
        if (this.addedTypeVars == null) {
            this.addedTypeVars = new HashSet<TypeVar>();
        }
        this.addedTypeVars.add(typeVar);
    }

    void backup(TypeInference.InferenceVar inferenceVar) {
        if (this.inferenceVarsBackup == null) {
            this.inferenceVarsBackup = new HashMap<TypeInference.InferenceVar, TypeInference.InferenceVar>();
        }
        if (!this.inferenceVarsBackup.containsKey(inferenceVar)) {
            this.inferenceVarsBackup.put(inferenceVar, inferenceVar.backup());
        }
    }

    public void restoreTo() {
        if (this.typeInference.statePoints.size() <= this.index) {
            throw new IllegalStateException("This state point already has been rolled back");
        }
        while (this.typeInference.statePoints.size() > this.index + 1) {
            this.typeInference.rollBack(this.typeInference.statePoints.remove(this.typeInference.statePoints.size() - 1));
        }
        this.typeInference.currentStatePoint = new TypeInferenceStatePoint(this.typeInference, this.typeInference.statePoints.size());
        this.typeInference.statePoints.add(this.typeInference.currentStatePoint);
    }

    @Override
    public void close() {
        this.restoreTo();
    }
}

