/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.MapSubstitutions;
import org.teavm.flavour.expr.type.MethodWithFreshTypeVars;
import org.teavm.flavour.expr.type.Primitive;
import org.teavm.flavour.expr.type.PrimitiveKind;
import org.teavm.flavour.expr.type.TypeInference;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;

public final class TypeUtils {
    public static final GenericClass BOOLEAN_CLASS = new GenericClass("java.lang.Boolean");
    public static final GenericClass CHARACTER_CLASS = new GenericClass("java.lang.Character");
    public static final GenericClass BYTE_CLASS = new GenericClass("java.lang.Byte");
    public static final GenericClass SHORT_CLASS = new GenericClass("java.lang.Short");
    public static final GenericClass INTEGER_CLASS = new GenericClass("java.lang.Integer");
    public static final GenericClass LONG_CLASS = new GenericClass("java.lang.Long");
    public static final GenericClass FLOAT_CLASS = new GenericClass("java.lang.Float");
    public static final GenericClass DOUBLE_CLASS = new GenericClass("java.lang.Double");
    public static final GenericClass STRING_CLASS = new GenericClass("java.lang.String");
    static final Map<Primitive, GenericClass> primitivesToWrappers = new HashMap<Primitive, GenericClass>();
    static final Map<GenericClass, Primitive> wrappersToPrimitives = new HashMap<GenericClass, Primitive>();

    private TypeUtils() {
    }

    private static void primitiveAndWrapper(Primitive primitive, GenericClass wrapper) {
        primitivesToWrappers.put(primitive, wrapper);
        wrappersToPrimitives.put(wrapper, primitive);
    }

    public static ValueType tryUnbox(GenericType type) {
        if (type instanceof GenericReference) {
            TypeVar v = ((GenericReference)type).getVar();
            return v.getLowerBound().stream().map(wrappersToPrimitives::get).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return wrappersToPrimitives.get(type);
    }

    public static Primitive unbox(GenericType type) {
        ValueType result = TypeUtils.tryUnbox(type);
        return result instanceof Primitive ? (Primitive)result : null;
    }

    public static ValueType tryBox(ValueType type) {
        GenericClass wrapper = primitivesToWrappers.get(type);
        if (wrapper == null) {
            return type;
        }
        return wrapper;
    }

    public static GenericClass box(ValueType type) {
        ValueType result = TypeUtils.tryBox(type);
        return result != type ? (GenericClass)result : null;
    }

    public static boolean isPrimitiveSubType(Primitive subtype, Primitive supertype) {
        if (subtype == supertype) {
            return true;
        }
        switch (supertype.getKind()) {
            case DOUBLE: {
                switch (subtype.getKind()) {
                    case FLOAT: 
                    case LONG: 
                    case INT: 
                    case CHAR: 
                    case SHORT: 
                    case BYTE: {
                        return true;
                    }
                }
                return false;
            }
            case FLOAT: {
                switch (subtype.getKind()) {
                    case LONG: 
                    case INT: 
                    case CHAR: 
                    case SHORT: 
                    case BYTE: {
                        return true;
                    }
                }
                return false;
            }
            case LONG: {
                switch (subtype.getKind()) {
                    case INT: 
                    case CHAR: 
                    case SHORT: 
                    case BYTE: {
                        return true;
                    }
                }
                return false;
            }
            case INT: {
                switch (subtype.getKind()) {
                    case CHAR: 
                    case SHORT: 
                    case BYTE: {
                        return true;
                    }
                }
                return false;
            }
            case SHORT: {
                return subtype.getKind() == PrimitiveKind.BYTE;
            }
        }
        return false;
    }

    public static MethodWithFreshTypeVars withFreshTypeVars(GenericMethod method, TypeInference inference) {
        TypeVar[] params = method.getDescriber().getTypeVariables();
        if (params.length == 0) {
            return new MethodWithFreshTypeVars(method, params);
        }
        HashMap<TypeVar, GenericType> substitutionMap = new HashMap<TypeVar, GenericType>();
        TypeVar[] freshVars = new TypeVar[params.length];
        for (int i = 0; i < params.length; ++i) {
            TypeVar freshVar = new TypeVar(params[i].getName());
            substitutionMap.put(params[i], new GenericReference(freshVar));
            freshVars[i] = freshVar;
        }
        MapSubstitutions substitution = new MapSubstitutions(substitutionMap);
        method = method.substitute(substitution);
        for (int i = 0; i < params.length; ++i) {
            TypeVar param = params[i];
            TypeVar freshVar = freshVars[i];
            if (!param.getLowerBound().isEmpty()) {
                freshVar.withLowerBound((GenericType[])param.getLowerBound().stream().map(bound -> bound.substitute(substitution)).toArray(GenericType[]::new));
                continue;
            }
            freshVar.withUpperBound((GenericType[])param.getUpperBound().stream().map(bound -> bound.substitute(substitution)).toArray(GenericType[]::new));
        }
        if (!inference.addVariables(Arrays.asList(freshVars))) {
            return null;
        }
        return new MethodWithFreshTypeVars(method, freshVars);
    }

    static {
        TypeUtils.primitiveAndWrapper(Primitive.BOOLEAN, BOOLEAN_CLASS);
        TypeUtils.primitiveAndWrapper(Primitive.CHAR, CHARACTER_CLASS);
        TypeUtils.primitiveAndWrapper(Primitive.BYTE, BYTE_CLASS);
        TypeUtils.primitiveAndWrapper(Primitive.SHORT, SHORT_CLASS);
        TypeUtils.primitiveAndWrapper(Primitive.INT, INTEGER_CLASS);
        TypeUtils.primitiveAndWrapper(Primitive.LONG, LONG_CLASS);
        TypeUtils.primitiveAndWrapper(Primitive.FLOAT, FLOAT_CLASS);
        TypeUtils.primitiveAndWrapper(Primitive.DOUBLE, DOUBLE_CLASS);
    }
}

