/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.teavm.flavour.expr.type.GenericArray;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.IntersectionType;
import org.teavm.flavour.expr.type.NullType;
import org.teavm.flavour.expr.type.Primitive;
import org.teavm.flavour.expr.type.PrimitiveArray;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;

public class ValueTypeFormatter {
    private Map<TypeVar, String> typeVarNames = new HashMap<TypeVar, String>();
    private boolean usingShortClassNames;
    private boolean usingWildcardChars;

    public boolean isUsingShortClassNames() {
        return this.usingShortClassNames;
    }

    public void setUsingShortClassNames(boolean usingShortClassNames) {
        this.usingShortClassNames = usingShortClassNames;
    }

    public boolean isUsingWildcardChars() {
        return this.usingWildcardChars;
    }

    public void setUsingWildcardChars(boolean usingWildcardChars) {
        this.usingWildcardChars = usingWildcardChars;
    }

    public String format(ValueType type) {
        StringBuilder sb = new StringBuilder();
        this.format(type, sb);
        return sb.toString();
    }

    public void format(ValueType type, StringBuilder sb) {
        block29: {
            block28: {
                if (type == null) {
                    sb.append('?');
                    return;
                }
                if (!(type instanceof Primitive)) break block28;
                switch (((Primitive)type).getKind()) {
                    case BOOLEAN: {
                        sb.append("boolean");
                        break block29;
                    }
                    case CHAR: {
                        sb.append("char");
                        break block29;
                    }
                    case BYTE: {
                        sb.append("byte");
                        break block29;
                    }
                    case SHORT: {
                        sb.append("short");
                        break block29;
                    }
                    case INT: {
                        sb.append("int");
                        break block29;
                    }
                    case LONG: {
                        sb.append("long");
                        break block29;
                    }
                    case FLOAT: {
                        sb.append("float");
                        break block29;
                    }
                    case DOUBLE: {
                        sb.append("double");
                        break block29;
                    }
                    default: {
                        throw new AssertionError((Object)"Unexpected primitive type");
                    }
                }
            }
            if (type instanceof GenericClass) {
                GenericClass cls = (GenericClass)type;
                if (!this.usingShortClassNames) {
                    sb.append(cls.getName());
                } else {
                    int index = cls.getName().lastIndexOf(46);
                    sb.append(cls.getName().substring(index + 1));
                }
                if (!cls.getArguments().isEmpty()) {
                    sb.append('<');
                    for (int i = 0; i < cls.getArguments().size(); ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        this.format(cls.getArguments().get(i), sb);
                    }
                    sb.append('>');
                }
            } else if (type instanceof GenericArray) {
                GenericArray array = (GenericArray)type;
                this.format(array.getElementType(), sb);
                sb.append("[]");
            } else if (type instanceof PrimitiveArray) {
                PrimitiveArray array = (PrimitiveArray)type;
                this.format(array.getElementType(), sb);
                sb.append("[]");
            } else if (type instanceof GenericReference) {
                GenericReference ref = (GenericReference)type;
                sb.append(this.getNameOfTypeVar(ref.getVar()));
            } else if (type instanceof NullType) {
                sb.append("-null-");
            } else if (type instanceof IntersectionType) {
                sb.append(((IntersectionType)type).getTypes().stream().map(t -> {
                    StringBuilder innerSb = new StringBuilder();
                    this.format((ValueType)t, innerSb);
                    return innerSb.toString();
                }).sorted().collect(Collectors.joining(" & ")));
            } else {
                throw new AssertionError((Object)("Unexpected type: " + type.getClass().getName()));
            }
        }
    }

    public void format(TypeArgument type, StringBuilder sb) {
        switch (type.getVariance()) {
            case INVARIANT: {
                this.format(type.getBound(), sb);
                break;
            }
            case COVARIANT: {
                if (type.getBound() instanceof GenericClass && ((GenericClass)type.getBound()).getName().equals("java.lang.Object")) {
                    sb.append("?");
                    break;
                }
                sb.append("? extends ");
                this.format(type.getBound(), sb);
                break;
            }
            case CONTRAVARIANT: {
                sb.append("? super ");
                this.format(type.getBound(), sb);
            }
        }
    }

    private String getNameOfTypeVar(TypeVar var) {
        if (var.getName() != null) {
            return var.getName();
        }
        if (this.usingWildcardChars) {
            return "?";
        }
        return this.typeVarNames.computeIfAbsent(var, k -> this.generateName(this.typeVarNames.size()));
    }

    private String generateName(int index) {
        int letterIndex = index % 26;
        int suffix = index / 26;
        StringBuilder sb = new StringBuilder("'");
        sb.append((char)(97 + letterIndex));
        if (suffix > 0) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

