/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type.meta;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathAnnotationsDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.MethodDescriber;

abstract class ClassPathAbstractMethodDescriber
extends ClassPathAnnotationsDescriber
implements MethodDescriber {
    private ClassPathClassDescriber owner;
    private TypeVar[] typeVariables;
    private ValueType[] parameterTypes;
    private ValueType[] rawArgumentTypes;
    private ValueType returnType;
    private ValueType rawReturnType;

    ClassPathAbstractMethodDescriber(ClassPathClassDescriber classDescriber) {
        this.owner = classDescriber;
    }

    @Override
    public ClassDescriber getOwner() {
        return this.owner;
    }

    @Override
    public TypeVar[] getTypeVariables() {
        if (this.typeVariables == null) {
            TypeVariable<?>[] javaVars = this.getJavaTypeVariables();
            this.typeVariables = new TypeVar[javaVars.length];
            for (int i = 0; i < javaVars.length; ++i) {
                this.typeVariables[i] = this.owner.repository.getTypeVariable(javaVars[i]);
            }
        }
        return (TypeVar[])this.typeVariables.clone();
    }

    abstract TypeVariable<?>[] getJavaTypeVariables();

    @Override
    public ValueType[] getParameterTypes() {
        if (this.parameterTypes == null) {
            Type[] javaArgs = this.getJavaArgumentTypes();
            this.parameterTypes = new ValueType[javaArgs.length];
            for (int i = 0; i < javaArgs.length; ++i) {
                this.parameterTypes[i] = this.owner.repository.convertGenericType(javaArgs[i]);
            }
        }
        return (ValueType[])this.parameterTypes.clone();
    }

    abstract Type[] getJavaArgumentTypes();

    @Override
    public ValueType[] getRawParameterTypes() {
        if (this.rawArgumentTypes == null) {
            Class<?>[] javaArgs = this.getJavaRawArgumentTypes();
            this.rawArgumentTypes = new ValueType[javaArgs.length];
            for (int i = 0; i < javaArgs.length; ++i) {
                this.rawArgumentTypes[i] = this.owner.repository.convertGenericType(javaArgs[i]);
            }
        }
        return (ValueType[])this.rawArgumentTypes.clone();
    }

    abstract Class<?>[] getJavaRawArgumentTypes();

    @Override
    public ValueType getReturnType() {
        if (this.returnType == null && !this.getJavaReturnType().equals(Void.TYPE)) {
            this.returnType = this.owner.repository.convertGenericType(this.getJavaReturnType());
        }
        return this.returnType;
    }

    abstract Type getJavaReturnType();

    @Override
    public ValueType getRawReturnType() {
        if (this.rawReturnType == null && !this.getJavaRawReturnType().equals(Void.TYPE)) {
            this.rawReturnType = this.owner.repository.convertGenericType(this.getJavaRawReturnType());
        }
        return this.rawReturnType;
    }

    abstract Type getJavaRawReturnType();

    @Override
    ClassPathClassDescriberRepository getRepository() {
        return this.owner.repository;
    }
}

