/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.teavm.flavour.expr.type.meta.AnnotationBoolean;
import org.teavm.flavour.expr.type.meta.AnnotationByte;
import org.teavm.flavour.expr.type.meta.AnnotationClass;
import org.teavm.flavour.expr.type.meta.AnnotationDescriber;
import org.teavm.flavour.expr.type.meta.AnnotationDouble;
import org.teavm.flavour.expr.type.meta.AnnotationEnum;
import org.teavm.flavour.expr.type.meta.AnnotationFloat;
import org.teavm.flavour.expr.type.meta.AnnotationInt;
import org.teavm.flavour.expr.type.meta.AnnotationList;
import org.teavm.flavour.expr.type.meta.AnnotationLong;
import org.teavm.flavour.expr.type.meta.AnnotationReference;
import org.teavm.flavour.expr.type.meta.AnnotationShort;
import org.teavm.flavour.expr.type.meta.AnnotationString;
import org.teavm.flavour.expr.type.meta.AnnotationValue;

class ClassPathAnnotationDescriber
implements AnnotationDescriber {
    private Annotation javaAnnotation;

    ClassPathAnnotationDescriber(Annotation javaAnnotation) {
        this.javaAnnotation = javaAnnotation;
    }

    @Override
    public AnnotationValue getValue(String name) {
        Object javaValue;
        Method method;
        try {
            method = this.javaAnnotation.getClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            javaValue = method.invoke((Object)this.javaAnnotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException();
        }
        return javaValue != null ? this.convertValue(javaValue) : null;
    }

    AnnotationValue convertValue(Object javaValue) {
        if (javaValue instanceof Boolean) {
            return new AnnotationBoolean((Boolean)javaValue);
        }
        if (javaValue instanceof Byte) {
            return new AnnotationByte((Byte)javaValue);
        }
        if (javaValue instanceof Short) {
            return new AnnotationShort((Short)javaValue);
        }
        if (javaValue instanceof Integer) {
            return new AnnotationInt((Integer)javaValue);
        }
        if (javaValue instanceof Long) {
            return new AnnotationLong((Long)javaValue);
        }
        if (javaValue instanceof Float) {
            return new AnnotationFloat(((Float)javaValue).floatValue());
        }
        if (javaValue instanceof Double) {
            return new AnnotationDouble((Double)javaValue);
        }
        if (javaValue instanceof String) {
            return new AnnotationString((String)javaValue);
        }
        if (javaValue instanceof Class) {
            return new AnnotationClass(((Class)javaValue).getName());
        }
        if (javaValue instanceof Enum) {
            return new AnnotationEnum(javaValue.getClass().getName(), ((Enum)javaValue).name());
        }
        if (javaValue.getClass().isArray()) {
            AnnotationValue[] list = new AnnotationValue[Array.getLength(javaValue)];
            for (int i = 0; i < list.length; ++i) {
                list[i] = this.convertValue(Array.get(javaValue, i));
            }
            return new AnnotationList(Arrays.asList(list));
        }
        if (javaValue instanceof Annotation) {
            return new AnnotationReference(new ClassPathAnnotationDescriber((Annotation)javaValue));
        }
        throw new AssertionError((Object)("Don't know how to convert " + javaValue + " into annotation value"));
    }
}

