/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.expr.type.meta.AnnotationDescriber;
import org.teavm.flavour.expr.type.meta.AnnotationsDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathAnnotationDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriberRepository;

abstract class ClassPathAnnotationsDescriber
implements AnnotationsDescriber {
    private Map<Annotation, ClassPathAnnotationDescriber> annotationCache = new HashMap<Annotation, ClassPathAnnotationDescriber>();
    private AnnotationDescriber[] annotations;

    ClassPathAnnotationsDescriber() {
    }

    abstract AnnotatedElement getAnnotatedElement();

    abstract ClassPathClassDescriberRepository getRepository();

    @Override
    public AnnotationDescriber[] getAnnotations() {
        if (this.annotations == null) {
            Annotation[] javaAnnotations = this.getAnnotatedElement().getDeclaredAnnotations();
            this.annotations = new AnnotationDescriber[javaAnnotations.length];
            for (int i = 0; i < javaAnnotations.length; ++i) {
                this.annotations[i] = this.getAnnotation(javaAnnotations[i]);
            }
        }
        return (AnnotationDescriber[])this.annotations.clone();
    }

    @Override
    public AnnotationDescriber getAnnotation(String className) {
        Class<?> cls;
        try {
            cls = Class.forName(className, false, this.getRepository().classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Object javaAnnotation = this.getAnnotatedElement().getAnnotation(cls);
        return javaAnnotation != null ? this.getAnnotation((Annotation)javaAnnotation) : null;
    }

    private AnnotationDescriber getAnnotation(Annotation javaAnnotation) {
        ClassPathAnnotationDescriber annotation = this.annotationCache.get(javaAnnotation);
        if (annotation == null) {
            annotation = new ClassPathAnnotationDescriber(javaAnnotation);
            this.annotationCache.put(javaAnnotation, annotation);
        }
        return annotation;
    }
}

