/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type.meta;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathAbstractMethodDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathAnnotationsDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.ClassPathConstructorDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathFieldDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathMethodDescriber;
import org.teavm.flavour.expr.type.meta.FieldDescriber;
import org.teavm.flavour.expr.type.meta.MethodDescriber;

class ClassPathClassDescriber
extends ClassPathAnnotationsDescriber
implements ClassDescriber {
    ClassPathClassDescriberRepository repository;
    private Class<?> cls;
    private TypeVar[] typeVariables;
    private GenericClass supertype;
    private GenericClass[] interfaces;
    private ClassPathAbstractMethodDescriber[] methods;
    private Map<Method, ClassPathMethodDescriber> methodMap = new HashMap<Method, ClassPathMethodDescriber>();
    private Map<Constructor<?>, ClassPathConstructorDescriber> constructorMap = new HashMap();
    private ClassPathFieldDescriber[] fields;
    private Map<Field, ClassPathFieldDescriber> fieldMap = new HashMap<Field, ClassPathFieldDescriber>();

    ClassPathClassDescriber(ClassPathClassDescriberRepository repository, Class<?> cls) {
        this.repository = repository;
        this.cls = cls;
    }

    @Override
    public String getName() {
        return this.cls.getName();
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this.cls.getModifiers());
    }

    @Override
    public TypeVar[] getTypeVariables() {
        if (this.typeVariables == null) {
            TypeVariable<Class<?>>[] javaTypeVariables = this.cls.getTypeParameters();
            this.typeVariables = new TypeVar[javaTypeVariables.length];
            for (int i = 0; i < this.typeVariables.length; ++i) {
                this.typeVariables[i] = this.repository.getTypeVariable(javaTypeVariables[i]);
            }
        }
        return this.typeVariables;
    }

    @Override
    public GenericClass getSupertype() {
        if (this.supertype == null) {
            Object nativeSuperclass = this.cls.getGenericSuperclass();
            if (nativeSuperclass == null && this.cls.isInterface()) {
                nativeSuperclass = Object.class;
            }
            this.supertype = nativeSuperclass != null ? (GenericClass)this.repository.convertGenericType((Type)nativeSuperclass) : null;
        }
        return this.supertype;
    }

    @Override
    public GenericClass[] getInterfaces() {
        if (this.interfaces == null) {
            Type[] javaInterfaces = this.cls.getGenericInterfaces();
            this.interfaces = new GenericClass[javaInterfaces.length];
            for (int i = 0; i < javaInterfaces.length; ++i) {
                this.interfaces[i] = (GenericClass)this.repository.convertGenericType(javaInterfaces[i]);
            }
        }
        return (GenericClass[])this.interfaces.clone();
    }

    @Override
    public MethodDescriber[] getMethods() {
        if (this.methods == null) {
            ClassPathAbstractMethodDescriber method;
            int i;
            Method[] javaMethods = this.cls.getDeclaredMethods();
            Constructor<?>[] javaConstructors = this.cls.getDeclaredConstructors();
            this.methods = new ClassPathAbstractMethodDescriber[javaMethods.length + javaConstructors.length];
            int j = 0;
            for (i = 0; i < javaMethods.length; ++i) {
                method = this.getMethod(javaMethods[i]);
                if (method == null) continue;
                this.methods[j++] = method;
            }
            for (i = 0; i < javaConstructors.length; ++i) {
                method = this.getMethod(javaConstructors[i]);
                if (method == null) continue;
                this.methods[j++] = method;
            }
            this.methods = Arrays.copyOf(this.methods, j);
        }
        return (MethodDescriber[])this.methods.clone();
    }

    @Override
    public MethodDescriber getMethod(String name, ValueType ... parameterTypes) {
        Class[] javaArgs = new Class[parameterTypes.length];
        for (int i = 0; i < javaArgs.length; ++i) {
            javaArgs[i] = this.repository.convertToRawType(parameterTypes[i]);
        }
        try {
            if (name.equals("<init>")) {
                Constructor<?> javaConstructor = this.cls.getDeclaredConstructor(javaArgs);
                return this.getMethod(javaConstructor);
            }
            Method javaMethod = this.cls.getDeclaredMethod(name, javaArgs);
            return this.getMethod(javaMethod);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private ClassPathMethodDescriber getMethod(Method javaMethod) {
        if (!Modifier.isPublic(javaMethod.getModifiers())) {
            return null;
        }
        ClassPathMethodDescriber method = this.methodMap.get(javaMethod);
        if (method == null) {
            method = new ClassPathMethodDescriber(this, javaMethod);
            this.methodMap.put(javaMethod, method);
        }
        return method;
    }

    private ClassPathConstructorDescriber getMethod(Constructor<?> javaConstructor) {
        if (!Modifier.isPublic(javaConstructor.getModifiers())) {
            return null;
        }
        ClassPathConstructorDescriber ctor = this.constructorMap.get(javaConstructor);
        if (ctor == null) {
            ctor = new ClassPathConstructorDescriber(this, javaConstructor);
            this.constructorMap.put(javaConstructor, ctor);
        }
        return ctor;
    }

    @Override
    public FieldDescriber[] getFields() {
        if (this.fields == null) {
            Field[] javaFields = this.cls.getDeclaredFields();
            this.fields = new ClassPathFieldDescriber[javaFields.length];
            int j = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                ClassPathFieldDescriber field = this.getField(javaFields[i]);
                if (field == null) continue;
                this.fields[j++] = field;
            }
            this.fields = Arrays.copyOf(this.fields, j);
        }
        return (FieldDescriber[])this.fields.clone();
    }

    @Override
    public FieldDescriber getField(String name) {
        try {
            Field javaField = this.cls.getDeclaredField(name);
            return this.getField(javaField);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private ClassPathFieldDescriber getField(Field javaField) {
        if (!Modifier.isPublic(javaField.getModifiers())) {
            return null;
        }
        ClassPathFieldDescriber field = this.fieldMap.get(javaField);
        if (field == null) {
            field = new ClassPathFieldDescriber(this, javaField);
            this.fieldMap.put(javaField, field);
        }
        return field;
    }

    @Override
    AnnotatedElement getAnnotatedElement() {
        return this.cls;
    }

    @Override
    ClassPathClassDescriberRepository getRepository() {
        return this.repository;
    }
}

