/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type.meta;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.teavm.flavour.expr.type.GenericArray;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.IntersectionType;
import org.teavm.flavour.expr.type.Primitive;
import org.teavm.flavour.expr.type.PrimitiveArray;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriber;

public class ClassPathClassDescriberRepository
implements ClassDescriberRepository {
    private static final Map<String, Primitive> primitiveMap = new HashMap<String, Primitive>();
    ClassLoader classLoader;
    private Map<String, Holder> cache = new HashMap<String, Holder>();
    private Map<TypeVariable<?>, TypeVar> typeVarCache = new HashMap();

    public ClassPathClassDescriberRepository() {
        this(ClassLoader.getSystemClassLoader());
    }

    public ClassPathClassDescriberRepository(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassDescriber describe(String className) {
        Holder holder = this.cache.get(className);
        if (holder == null) {
            holder = new Holder();
            try {
                holder.classDescriber = new ClassPathClassDescriber(this, Class.forName(className, false, this.classLoader));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.cache.put(className, holder);
        }
        return holder.classDescriber;
    }

    TypeVar getTypeVariable(TypeVariable<?> javaVar) {
        TypeVar var = this.typeVarCache.get(javaVar);
        if (var == null) {
            var = new TypeVar(javaVar.getName());
            this.typeVarCache.put(javaVar, var);
            Type[] javaBounds = javaVar.getBounds();
            if (javaBounds.length > 0) {
                var.withUpperBound((GenericClass)this.convertGenericType(javaBounds[0]));
            }
        }
        return var;
    }

    public ValueType convertGenericType(Type javaType) {
        if (javaType instanceof Class) {
            Class javaClass = (Class)javaType;
            if (javaClass.isPrimitive()) {
                return primitiveMap.get(javaClass.getName());
            }
            if (javaClass.isArray()) {
                if (javaClass.getComponentType().isPrimitive()) {
                    return new PrimitiveArray((Primitive)this.convertGenericType(javaClass.getComponentType()));
                }
                return new GenericArray((GenericType)this.convertGenericType(javaClass.getComponentType()));
            }
            return new GenericClass(javaClass.getName(), Collections.emptyList());
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType javaGenericType = (ParameterizedType)javaType;
            Class javaRawClass = (Class)javaGenericType.getRawType();
            Type[] javaArgs = javaGenericType.getActualTypeArguments();
            TypeArgument[] args = new TypeArgument[javaArgs.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.convertTypeArgument(javaArgs[i]);
            }
            return new GenericClass(javaRawClass.getName(), Arrays.asList(args));
        }
        if (javaType instanceof GenericArrayType) {
            GenericArrayType javaArray = (GenericArrayType)javaType;
            return new GenericArray((GenericType)this.convertGenericType(javaArray.getGenericComponentType()));
        }
        if (javaType instanceof TypeVariable) {
            TypeVariable javaVar = (TypeVariable)javaType;
            return new GenericReference(this.getTypeVariable(javaVar));
        }
        throw new AssertionError((Object)("Unsupported type: " + javaType));
    }

    private TypeArgument convertTypeArgument(Type javaType) {
        if (javaType instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)javaType;
            Type[] upperBounds = wildcard.getUpperBounds();
            Type[] lowerBounds = wildcard.getLowerBounds();
            if (lowerBounds.length > 0) {
                return TypeArgument.contravariant(IntersectionType.of(Arrays.stream(lowerBounds).map(bound -> (GenericType)this.convertGenericType((Type)bound)).collect(Collectors.toList())));
            }
            if (upperBounds.length > 0) {
                return TypeArgument.covariant(IntersectionType.of(Arrays.stream(upperBounds).map(bound -> (GenericType)this.convertGenericType((Type)bound)).collect(Collectors.toList())));
            }
            return TypeArgument.covariant(GenericType.OBJECT);
        }
        return TypeArgument.invariant((GenericType)this.convertGenericType(javaType));
    }

    Class<?> convertToRawType(ValueType type) {
        if (type instanceof Primitive) {
            switch (((Primitive)type).getKind()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case INT: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
            }
            throw new AssertionError();
        }
        if (type instanceof GenericArray) {
            GenericArray array = (GenericArray)type;
            return Array.newInstance(this.convertToRawType(array.getElementType()), 0).getClass();
        }
        if (type instanceof GenericClass) {
            GenericClass cls = (GenericClass)type;
            try {
                return Class.forName(cls.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + cls.getName());
            }
        }
        if (type instanceof GenericReference) {
            return Object.class;
        }
        throw new AssertionError((Object)("Can't convert type: " + type));
    }

    static {
        primitiveMap.put("boolean", Primitive.BOOLEAN);
        primitiveMap.put("char", Primitive.CHAR);
        primitiveMap.put("byte", Primitive.BYTE);
        primitiveMap.put("short", Primitive.SHORT);
        primitiveMap.put("int", Primitive.INT);
        primitiveMap.put("long", Primitive.LONG);
        primitiveMap.put("float", Primitive.FLOAT);
        primitiveMap.put("double", Primitive.DOUBLE);
    }

    static class Holder {
        ClassPathClassDescriber classDescriber;

        Holder() {
        }
    }
}

