/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr.type.meta;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathAnnotationsDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.FieldDescriber;

class ClassPathFieldDescriber
extends ClassPathAnnotationsDescriber
implements FieldDescriber {
    private ClassPathClassDescriber owner;
    private Field javaField;
    private ValueType type;
    private ValueType rawType;

    ClassPathFieldDescriber(ClassPathClassDescriber owner, Field javaField) {
        this.owner = owner;
        this.javaField = javaField;
    }

    @Override
    public ClassDescriber getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.javaField.getName();
    }

    @Override
    public ValueType getType() {
        if (this.type == null) {
            this.type = this.owner.repository.convertGenericType(this.javaField.getGenericType());
        }
        return this.type;
    }

    @Override
    public ValueType getRawType() {
        if (this.rawType == null) {
            this.rawType = this.owner.repository.convertGenericType(this.javaField.getType());
        }
        return this.rawType;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.javaField.getModifiers());
    }

    @Override
    AnnotatedElement getAnnotatedElement() {
        return this.javaField;
    }

    @Override
    ClassPathClassDescriberRepository getRepository() {
        return this.owner.repository;
    }
}

