/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.deserializer;

import java.util.ArrayList;
import org.teavm.flavour.json.deserializer.JsonDeserializer;
import org.teavm.flavour.json.deserializer.JsonDeserializerContext;
import org.teavm.flavour.json.tree.ArrayNode;
import org.teavm.flavour.json.tree.Node;

public class ListDeserializer
extends JsonDeserializer {
    private JsonDeserializer itemDeserializer;

    public ListDeserializer(JsonDeserializer itemDeserializer) {
        this.itemDeserializer = itemDeserializer;
    }

    @Override
    public Object deserialize(JsonDeserializerContext context, Node node) {
        if (node.isNull()) {
            return null;
        }
        if (!node.isArray()) {
            throw new IllegalArgumentException("Can't deserialize non-array node as a list");
        }
        ArrayNode arrayNode = (ArrayNode)node;
        ArrayList<Object> list = new ArrayList<Object>(arrayNode.size());
        for (int i = 0; i < arrayNode.size(); ++i) {
            list.add(this.itemDeserializer.deserialize(context, arrayNode.get(i)));
        }
        return list;
    }
}

