/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.emit;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import org.teavm.flavour.json.JSON;
import org.teavm.flavour.json.JsonPersistable;
import org.teavm.flavour.json.deserializer.ArrayDeserializer;
import org.teavm.flavour.json.deserializer.BooleanArrayDeserializer;
import org.teavm.flavour.json.deserializer.BooleanDeserializer;
import org.teavm.flavour.json.deserializer.ByteArrayDeserializer;
import org.teavm.flavour.json.deserializer.ByteDeserializer;
import org.teavm.flavour.json.deserializer.CharArrayDeserializer;
import org.teavm.flavour.json.deserializer.CharacterDeserializer;
import org.teavm.flavour.json.deserializer.DoubleArrayDeserializer;
import org.teavm.flavour.json.deserializer.DoubleDeserializer;
import org.teavm.flavour.json.deserializer.FloatArrayDeserializer;
import org.teavm.flavour.json.deserializer.FloatDeserializer;
import org.teavm.flavour.json.deserializer.IntArrayDeserializer;
import org.teavm.flavour.json.deserializer.IntegerDeserializer;
import org.teavm.flavour.json.deserializer.JsonDeserializer;
import org.teavm.flavour.json.deserializer.JsonDeserializerContext;
import org.teavm.flavour.json.deserializer.ListDeserializer;
import org.teavm.flavour.json.deserializer.LongArrayDeserializer;
import org.teavm.flavour.json.deserializer.LongDeserializer;
import org.teavm.flavour.json.deserializer.MapDeserializer;
import org.teavm.flavour.json.deserializer.ObjectDeserializer;
import org.teavm.flavour.json.deserializer.SetDeserializer;
import org.teavm.flavour.json.deserializer.ShortArrayDeserializer;
import org.teavm.flavour.json.deserializer.ShortDeserializer;
import org.teavm.flavour.json.deserializer.StringDeserializer;
import org.teavm.flavour.json.emit.ClassInformation;
import org.teavm.flavour.json.emit.ClassInformationProvider;
import org.teavm.flavour.json.emit.DateFormatInformation;
import org.teavm.flavour.json.emit.GenericTypeProvider;
import org.teavm.flavour.json.emit.InheritanceValue;
import org.teavm.flavour.json.emit.PropertyInformation;
import org.teavm.flavour.json.tree.ArrayNode;
import org.teavm.flavour.json.tree.Node;
import org.teavm.flavour.json.tree.NumberNode;
import org.teavm.flavour.json.tree.ObjectNode;
import org.teavm.flavour.json.tree.StringNode;
import org.teavm.metaprogramming.Diagnostics;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.reflect.ReflectAnnotatedElement;
import org.teavm.metaprogramming.reflect.ReflectField;
import org.teavm.metaprogramming.reflect.ReflectMethod;

public class JsonDeserializerEmitter {
    private Diagnostics diagnostics = Metaprogramming.getDiagnostics();
    private ClassLoader classLoader = Metaprogramming.getClassLoader();
    private ClassInformationProvider informationProvider = ClassInformationProvider.getInstance();
    private GenericTypeProvider genericTypeProvider = new GenericTypeProvider(this.classLoader);
    private static Map<String, Class<?>> predefinedDeserializers = new HashMap();

    public Value<? extends JsonDeserializer> getClassDeserializer(ReflectClass<?> cls) {
        Value<JsonDeserializer> deserializer = this.tryGetPredefinedDeserializer(cls);
        if (deserializer == null) {
            deserializer = cls.isArray() ? this.emitArrayDeserializer(cls) : (cls.isEnum() ? this.emitEnumDeserializer(cls) : this.emitClassDeserializer(cls));
        }
        return deserializer;
    }

    private Value<JsonDeserializer> tryGetPredefinedDeserializer(ReflectClass<?> cls) {
        if (cls.isArray() || cls.isPrimitive()) {
            return null;
        }
        Class<?> serializerClass = predefinedDeserializers.get(cls.getName());
        if (serializerClass != null) {
            ReflectMethod ctor = Metaprogramming.findClass((String)serializerClass.getName()).getMethod("<init>", new ReflectClass[0]);
            return Metaprogramming.emit(() -> (JsonDeserializer)ctor.construct(new Object[0]));
        }
        if (Metaprogramming.findClass(Map.class).isAssignableFrom(cls)) {
            return Metaprogramming.emit(() -> new MapDeserializer(new ObjectDeserializer(), new ObjectDeserializer()));
        }
        if (Metaprogramming.findClass(Collection.class).isAssignableFrom(cls)) {
            return Metaprogramming.emit(() -> new ListDeserializer(new ObjectDeserializer()));
        }
        return null;
    }

    private Value<? extends JsonDeserializer> emitArrayDeserializer(ReflectClass<?> cls) {
        Value<? extends JsonDeserializer> itemDeserializer;
        if (cls.getComponentType().isPrimitive()) {
            String name;
            switch (name = cls.getComponentType().getName()) {
                case "boolean": {
                    return Metaprogramming.emit(() -> new BooleanArrayDeserializer());
                }
                case "byte": {
                    return Metaprogramming.emit(() -> new ByteArrayDeserializer());
                }
                case "short": {
                    return Metaprogramming.emit(() -> new ShortArrayDeserializer());
                }
                case "char": {
                    return Metaprogramming.emit(() -> new CharArrayDeserializer());
                }
                case "int": {
                    return Metaprogramming.emit(() -> new IntArrayDeserializer());
                }
                case "long": {
                    return Metaprogramming.emit(() -> new LongArrayDeserializer());
                }
                case "float": {
                    return Metaprogramming.emit(() -> new FloatArrayDeserializer());
                }
                case "double": {
                    return Metaprogramming.emit(() -> new DoubleArrayDeserializer());
                }
            }
        }
        if ((itemDeserializer = this.getClassDeserializer(cls.getComponentType())) == null) {
            return null;
        }
        return Metaprogramming.emit(() -> new ArrayDeserializer(cls.asJavaClass(), (JsonDeserializer)itemDeserializer.get()));
    }

    private Value<? extends JsonDeserializer> emitEnumDeserializer(ReflectClass<?> cls) {
        if (cls.getAnnotation(JsonPersistable.class) == null) {
            return null;
        }
        return Metaprogramming.proxy(JsonDeserializer.class, (instance, method, args) -> {
            Value node = Metaprogramming.emit(() -> (Node)args[1]);
            this.emitEnumDeserializer(cls, (Value<Node>)node);
        });
    }

    private Value<? extends JsonDeserializer> emitClassDeserializer(ReflectClass<?> cls) {
        ClassInformation information = this.informationProvider.get(cls.getName());
        if (information == null || !information.persistable) {
            return null;
        }
        return Metaprogramming.proxy(JsonDeserializer.class, (instance, method, args) -> {
            Value context = Metaprogramming.emit(() -> (JsonDeserializerContext)args[0]);
            Value node = Metaprogramming.emit(() -> (Node)args[1]);
            Value<Object> result = Metaprogramming.lazyFragment(() -> this.emitSubTypes(information, (Value<Node>)node, (Value<JsonDeserializerContext>)context, contentNode -> {
                if (information.isAbstract) {
                    return Metaprogramming.emit(() -> null);
                }
                Value<Object> target = this.emitConstructor(information, (Value<ObjectNode>)contentNode, (Value<JsonDeserializerContext>)context);
                this.emitIdRegistration(information, target, (Value<ObjectNode>)contentNode, (Value<JsonDeserializerContext>)context);
                this.emitProperties(information, target, (Value<ObjectNode>)contentNode, (Value<JsonDeserializerContext>)context);
                return Metaprogramming.emit(() -> target.get());
            }));
            Value<Object> finalResult = result = this.emitNodeTypeCheck((Value<Node>)node, result, this.emitIdCheck(information, (Value<Node>)node, (Value<JsonDeserializerContext>)context));
            Metaprogramming.exit(() -> ((Node)node.get()).isNull() ? null : finalResult.get());
        });
    }

    private void emitEnumDeserializer(ReflectClass<?> cls, Value<Node> node) {
        String className = cls.getName();
        Value text = Metaprogramming.emit(() -> ((StringNode)node.get()).getValue());
        Value result = Metaprogramming.lazy(() -> {
            throw new IllegalArgumentException("Can't convert to " + className + ": " + ((Node)node.get()).stringify());
        });
        for (ReflectField field : cls.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            String fieldName = field.getName();
            Value currentResult = result;
            result = Metaprogramming.lazy(() -> ((String)text.get()).equals(fieldName) ? field.get(null) : currentResult.get());
        }
        Value finalResult = result;
        Metaprogramming.exit(() -> {
            if (((Node)node.get()).isNull()) {
                return null;
            }
            if (!((Node)node.get()).isString()) {
                throw new IllegalArgumentException("Can't convert to " + className + ": " + ((Node)node.get()).stringify());
            }
            return finalResult.get();
        });
    }

    private Value<Object> emitIdCheck(ClassInformation information, Value<Node> node, Value<JsonDeserializerContext> context) {
        String className = information.className;
        switch (information.idGenerator) {
            case INTEGER: {
                return this.emitIntegerIdCheck(information, node, context);
            }
            case PROPERTY: {
                return this.emitPropertyIdCheck(information, node, context);
            }
            case NONE: {
                return Metaprogramming.lazy(() -> {
                    throw new IllegalArgumentException("Can't deserialize node " + ((Node)node.get()).stringify() + " to an instance of " + className);
                });
            }
        }
        throw new AssertionError((Object)("Unsupported id kind: " + (Object)((Object)information.idGenerator)));
    }

    private Value<Object> emitIntegerIdCheck(ClassInformation information, Value<Node> node, Value<JsonDeserializerContext> context) {
        String className = information.className;
        return Metaprogramming.lazy(() -> {
            if (((Node)node.get()).isNumber()) {
                NumberNode number = (NumberNode)node.get();
                return ((JsonDeserializerContext)context.get()).get(number.getIntValue());
            }
            throw new IllegalArgumentException("Can't deserialize node " + ((Node)node.get()).stringify() + " to an instance of " + className);
        });
    }

    private Value<Object> emitPropertyIdCheck(ClassInformation information, Value<Node> node, Value<JsonDeserializerContext> context) {
        PropertyInformation property = information.properties.get(information.idProperty);
        String className = information.className;
        if (property == null) {
            return Metaprogramming.lazy(() -> {
                throw new IllegalArgumentException("Can't deserialize node " + ((Node)node.get()).stringify() + " to an instance of " + className);
            });
        }
        Type type = this.getPropertyGenericType(property);
        if (type != null) {
            Value<Object> converted = this.convert(node, context, type, (ReflectAnnotatedElement)property.setter);
            return Metaprogramming.lazy(() -> ((JsonDeserializerContext)context.get()).get(converted.get()));
        }
        return Metaprogramming.lazy(() -> {
            throw new IllegalArgumentException("Can't deserialize node " + ((Node)node.get()).stringify() + " to an instance of " + className);
        });
    }

    private Value<Object> emitNodeTypeCheck(Value<Node> node, Value<Object> defaultValue, Value<Object> idValue) {
        return Metaprogramming.lazy(() -> ((Node)node.get()).isArray() || ((Node)node.get()).isObject() ? defaultValue.get() : idValue.get());
    }

    private Value<Object> emitSubTypes(ClassInformation information, Value<Node> node, Value<JsonDeserializerContext> context, Function<Value<ObjectNode>, Value<Object>> consumer) {
        if (information.inheritance.subTypes.isEmpty() || information.inheritance.value == InheritanceValue.NONE) {
            return consumer.apply((Value<ObjectNode>)Metaprogramming.lazy(() -> (ObjectNode)node.get()));
        }
        ObjectWithTag taggedObject = this.emitTypeNameExtractor(information, node);
        if (taggedObject == null) {
            return consumer.apply((Value<ObjectNode>)Metaprogramming.lazy(() -> (ObjectNode)node.get()));
        }
        Value<ObjectNode> contentNode = taggedObject.object;
        Value<String> tag = taggedObject.tag;
        Value result = Metaprogramming.lazy(() -> {
            throw new IllegalArgumentException("Invalid type tag: " + (String)tag.get());
        });
        for (ClassInformation subType : information.inheritance.subTypes) {
            String typeName = this.getTypeName(information, subType);
            ReflectClass subclass = Metaprogramming.findClass((String)subType.className);
            Value currentResult = result;
            result = Metaprogramming.lazy(() -> {
                if (((String)tag.get()).equals(typeName)) {
                    return JSON.getClassDeserializer(subclass.asJavaClass()).deserialize((JsonDeserializerContext)context.get(), (Node)contentNode.get());
                }
                return currentResult.get();
            });
        }
        Value finalResult = result;
        String defaultTypeName = this.getTypeName(information, information);
        Value<Object> defaultValue = consumer.apply(taggedObject.object);
        return Metaprogramming.lazy(() -> ((String)tag.get()).equals(defaultTypeName) ? defaultValue.get() : finalResult.get());
    }

    private ObjectWithTag emitTypeNameExtractor(ClassInformation information, Value<Node> node) {
        switch (information.inheritance.key) {
            case PROPERTY: {
                return this.emitPropertyTypeNameExtractor(information, node);
            }
            case WRAPPER_ARRAY: {
                return this.emitArrayTypeNameExtractor(node);
            }
            case WRAPPER_OBJECT: {
                return this.emitObjectTypeNameExtractor(node);
            }
        }
        return null;
    }

    private ObjectWithTag emitPropertyTypeNameExtractor(ClassInformation information, Value<Node> node) {
        String propertyName = information.inheritance.propertyName;
        String defaultTypeName = this.getTypeName(information, information);
        Value contentNode = Metaprogramming.emit(() -> (ObjectNode)node.get());
        Value typeName = Metaprogramming.emit(() -> ((ObjectNode)contentNode.get()).has(propertyName) ? ((StringNode)((ObjectNode)contentNode.get()).get(propertyName)).getValue() : defaultTypeName);
        return new ObjectWithTag((Value<String>)typeName, (Value<ObjectNode>)contentNode);
    }

    private ObjectWithTag emitArrayTypeNameExtractor(Value<Node> node) {
        Value array = Metaprogramming.emit(() -> (ArrayNode)node.get());
        Value tag = Metaprogramming.emit(() -> ((StringNode)((ArrayNode)array.get()).get(0)).getValue());
        Value valueNode = Metaprogramming.emit(() -> (ObjectNode)((ArrayNode)array.get()).get(1));
        return new ObjectWithTag((Value<String>)tag, (Value<ObjectNode>)valueNode);
    }

    private ObjectWithTag emitObjectTypeNameExtractor(Value<Node> node) {
        Value obj = Metaprogramming.emit(() -> (ObjectNode)node.get());
        Value tag = Metaprogramming.emit(() -> ((ObjectNode)obj.get()).allKeys()[0]);
        Value valueNode = Metaprogramming.emit(() -> (ObjectNode)((ObjectNode)obj.get()).get((String)tag.get()));
        return new ObjectWithTag((Value<String>)tag, (Value<ObjectNode>)valueNode);
    }

    private String getTypeName(ClassInformation baseType, ClassInformation type) {
        switch (baseType.inheritance.value) {
            case CLASS: {
                return type.className;
            }
            case MINIMAL_CLASS: {
                return ClassInformationProvider.getUnqualifiedName(type.className);
            }
            case NAME: {
                return !type.typeName.isEmpty() ? type.typeName : ClassInformationProvider.getUnqualifiedName(type.className);
            }
        }
        return "";
    }

    private Value<Object> emitConstructor(ClassInformation information, Value<ObjectNode> node, Value<JsonDeserializerContext> context) {
        if (information.constructor == null) {
            this.diagnostics.error(null, "Neither non-argument constructor nor @JsonCreator were found in {{c0}}", new Object[]{information.className});
            return Metaprogramming.emit(() -> null);
        }
        int paramCount = information.constructorArgs.size();
        Value args = Metaprogramming.emit(() -> new Object[paramCount]);
        Type[] genericTypes = this.genericTypeProvider.getGenericTypesForConstructor(information);
        int i = 0;
        while (i < paramCount) {
            Value<Object> paramValue;
            PropertyInformation property = information.constructorArgs.get(i);
            if (property != null) {
                String propertyName = property.outputName;
                Type type = genericTypes[i];
                Value valueNode = Metaprogramming.emit(() -> ((ObjectNode)node.get()).get(propertyName));
                paramValue = this.convert((Value<Node>)valueNode, context, type, information.constructor.getParameterAnnotations(i));
            } else {
                paramValue = this.defaultValue(information.constructor.getParameterType(i));
            }
            int index = i++;
            Metaprogramming.emit(() -> {
                Object object = paramValue.get();
                ((Object[])args.get())[index] = object;
                return object;
            });
        }
        ReflectMethod ctor = information.constructor;
        return ctor.getName().equals("<init>") ? Metaprogramming.emit(() -> ctor.construct((Object[])args.get())) : Metaprogramming.emit(() -> ctor.invoke(null, (Object[])args.get()));
    }

    private void emitIdRegistration(ClassInformation information, Value<Object> object, Value<ObjectNode> node, Value<JsonDeserializerContext> context) {
        Value register = Metaprogramming.lazyFragment(() -> {
            Value<Object> id;
            switch (information.idGenerator) {
                case INTEGER: {
                    id = this.emitIntegerIdRegistration(information, node);
                    break;
                }
                case PROPERTY: {
                    id = this.emitPropertyIdRegistration(information, node, context);
                    break;
                }
                default: {
                    id = null;
                }
            }
            if (id != null) {
                Metaprogramming.emit(() -> ((JsonDeserializerContext)context.get()).register(id.get(), object.get()));
            }
            return null;
        });
        String idProperty = information.idProperty;
        if (idProperty != null) {
            Metaprogramming.emit(() -> {
                if (((ObjectNode)node.get()).has(idProperty)) {
                    register.get();
                }
            });
        }
    }

    private Value<Object> emitIntegerIdRegistration(ClassInformation information, Value<ObjectNode> node) {
        String idProperty = information.idProperty;
        return Metaprogramming.emit(() -> JSON.deserializeInt(((ObjectNode)node.get()).get(idProperty)));
    }

    private Value<Object> emitPropertyIdRegistration(ClassInformation information, Value<ObjectNode> node, Value<JsonDeserializerContext> context) {
        PropertyInformation property = information.properties.get(information.idProperty);
        if (property == null) {
            return null;
        }
        String idProperty = information.idProperty;
        Value id = Metaprogramming.emit(() -> ((ObjectNode)node.get()).get(idProperty));
        Type type = this.getPropertyGenericType(property);
        if (type == null) {
            return null;
        }
        return this.convert((Value<Node>)id, context, type, (ReflectAnnotatedElement)property.setter);
    }

    private void emitProperties(ClassInformation information, Value<Object> target, Value<ObjectNode> node, Value<JsonDeserializerContext> context) {
        for (PropertyInformation property : information.properties.values()) {
            if (property.ignored) continue;
            if (property.setter != null) {
                this.emitSetter(property, target, node, context);
                continue;
            }
            if (property.field == null) continue;
            this.emitField(property, target, node, context);
        }
    }

    private void emitSetter(PropertyInformation property, Value<Object> target, Value<ObjectNode> node, Value<JsonDeserializerContext> context) {
        ReflectMethod method = property.setter;
        Method javaMethod = this.genericTypeProvider.findMethod(method);
        Type type = javaMethod.getGenericParameterTypes()[0];
        String propertyName = property.outputName;
        Value jsonValue = Metaprogramming.emit(() -> ((ObjectNode)node.get()).get(propertyName));
        Value<Object> value = this.convert((Value<Node>)jsonValue, context, type, (ReflectAnnotatedElement)method);
        Metaprogramming.emit(() -> method.invoke(target.get(), new Object[]{value.get()}));
    }

    private void emitField(PropertyInformation property, Value<Object> target, Value<ObjectNode> node, Value<JsonDeserializerContext> context) {
        ReflectField field = property.field;
        Field javaField = this.genericTypeProvider.findField(field);
        Type type = javaField.getGenericType();
        String propertyName = property.outputName;
        Value jsonValue = Metaprogramming.emit(() -> ((ObjectNode)node.get()).get(propertyName));
        Value<Object> value = this.convert((Value<Node>)jsonValue, context, type, (ReflectAnnotatedElement)field);
        Metaprogramming.emit(() -> field.set(target.get(), value.get()));
    }

    private Type getPropertyGenericType(PropertyInformation property) {
        Field field;
        Method getter;
        Type type = null;
        if (property.getter != null && (getter = this.genericTypeProvider.findMethod(property.getter)) != null) {
            type = getter.getGenericReturnType();
        }
        if (type == null && property.field != null && (field = this.genericTypeProvider.findField(property.field)) != null) {
            type = field.getGenericType();
        }
        return type;
    }

    private Value<Object> convert(Value<Node> node, Value<JsonDeserializerContext> context, Type type, ReflectAnnotatedElement annotations) {
        Class cls;
        if (type instanceof Class && (cls = (Class)type).isPrimitive()) {
            return this.convertPrimitive(node, cls);
        }
        return this.convertNullable(node, context, type, annotations);
    }

    private Value<Object> convertNullable(Value<Node> node, Value<JsonDeserializerContext> context, Type type, ReflectAnnotatedElement annotations) {
        if (type instanceof Class && Date.class.isAssignableFrom((Class)type)) {
            return this.convertDate(node, annotations);
        }
        Value<JsonDeserializer> deserializer = this.createDeserializer(type, annotations);
        return Metaprogramming.emit(() -> ((JsonDeserializer)deserializer.get()).deserialize((JsonDeserializerContext)context.get(), (Node)node.get()));
    }

    private Value<JsonDeserializer> createDeserializer(Type type, ReflectAnnotatedElement annotations) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isArray() ? this.createArrayDeserializer(cls, annotations) : this.createObjectDeserializer(cls);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (paramType.getRawType().equals(Map.class)) {
                return this.createMapDeserializer(typeArgs[0], typeArgs[1], annotations);
            }
            if (paramType.getRawType().equals(List.class)) {
                return this.createListDeserializer(typeArgs[0], annotations);
            }
            if (paramType.getRawType().equals(Set.class)) {
                return this.createSetDeserializer(typeArgs[0], annotations);
            }
            return this.createDeserializer(paramType.getRawType(), annotations);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            Type upperBound = wildcard.getUpperBounds()[0];
            Class upperCls = Object.class;
            if (upperBound instanceof Class) {
                upperCls = (Class)upperBound;
            }
            return this.createObjectDeserializer(upperCls);
        }
        if (type instanceof TypeVariable) {
            TypeVariable tyvar = (TypeVariable)type;
            Type upperBound = tyvar.getBounds()[0];
            Class upperCls = Object.class;
            if (upperBound instanceof Class) {
                upperCls = (Class)upperBound;
            }
            return this.createObjectDeserializer(upperCls);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type;
            return this.createArrayDeserializer(array, annotations);
        }
        return this.createObjectDeserializer(Object.class);
    }

    private Value<Object> convertPrimitive(Value<Node> node, Class<?> type) {
        switch (type.getName()) {
            case "boolean": {
                return Metaprogramming.emit(() -> JSON.deserializeBoolean((Node)node.get()));
            }
            case "byte": {
                return Metaprogramming.emit(() -> JSON.deserializeByte((Node)node.get()));
            }
            case "short": {
                return Metaprogramming.emit(() -> JSON.deserializeShort((Node)node.get()));
            }
            case "int": {
                return Metaprogramming.emit(() -> JSON.deserializeInt((Node)node.get()));
            }
            case "long": {
                return Metaprogramming.emit(() -> JSON.deserializeLong((Node)node.get()));
            }
            case "float": {
                return Metaprogramming.emit(() -> Float.valueOf(JSON.deserializeFloat((Node)node.get())));
            }
            case "double": {
                return Metaprogramming.emit(() -> JSON.deserializeDouble((Node)node.get()));
            }
            case "char": {
                return Metaprogramming.emit(() -> Character.valueOf(JSON.deserializeChar((Node)node.get())));
            }
        }
        throw new AssertionError((Object)("Unknown primitive type: " + type));
    }

    private Value<JsonDeserializer> createArrayDeserializer(GenericArrayType type, ReflectAnnotatedElement annotations) {
        Value<JsonDeserializer> itemDeserializer = this.createDeserializer(type.getGenericComponentType(), annotations);
        Class<?> cls = GenericTypeProvider.rawType(type);
        return Metaprogramming.emit(() -> new ArrayDeserializer(cls, (JsonDeserializer)itemDeserializer.get()));
    }

    private Value<JsonDeserializer> createArrayDeserializer(Class<?> type, ReflectAnnotatedElement annotations) {
        Value<JsonDeserializer> itemDeserializer;
        if (type.getComponentType().isPrimitive()) {
            String name;
            switch (name = type.getComponentType().getName()) {
                case "boolean": {
                    return Metaprogramming.emit(() -> new BooleanArrayDeserializer());
                }
                case "byte": {
                    return Metaprogramming.emit(() -> new ByteArrayDeserializer());
                }
                case "short": {
                    return Metaprogramming.emit(() -> new ShortArrayDeserializer());
                }
                case "char": {
                    return Metaprogramming.emit(() -> new CharArrayDeserializer());
                }
                case "int": {
                    return Metaprogramming.emit(() -> new IntArrayDeserializer());
                }
                case "long": {
                    return Metaprogramming.emit(() -> new LongArrayDeserializer());
                }
                case "float": {
                    return Metaprogramming.emit(() -> new FloatArrayDeserializer());
                }
                case "double": {
                    return Metaprogramming.emit(() -> new DoubleArrayDeserializer());
                }
            }
        }
        if ((itemDeserializer = this.createDeserializer(type.getComponentType(), annotations)) == null) {
            return null;
        }
        return Metaprogramming.emit(() -> new ArrayDeserializer(type, (JsonDeserializer)itemDeserializer.get()));
    }

    private Value<JsonDeserializer> createObjectDeserializer(Class<?> type) {
        return Metaprogramming.emit(() -> {
            JsonDeserializer deserializer = JSON.getClassDeserializer(type);
            if (deserializer == null) {
                throw new IllegalArgumentException("Don't know how to deserialize class " + type.getName());
            }
            return deserializer;
        });
    }

    private Value<JsonDeserializer> createMapDeserializer(Type keyType, Type valueType, ReflectAnnotatedElement annotations) {
        Value<JsonDeserializer> keyDeserializer = this.createDeserializer(keyType, annotations);
        Value<JsonDeserializer> valueDeserializer = this.createDeserializer(valueType, annotations);
        return Metaprogramming.emit(() -> new MapDeserializer((JsonDeserializer)keyDeserializer.get(), (JsonDeserializer)valueDeserializer.get()));
    }

    private Value<JsonDeserializer> createListDeserializer(Type itemType, ReflectAnnotatedElement annotations) {
        Value<JsonDeserializer> itemDeserializer = this.createDeserializer(itemType, annotations);
        return Metaprogramming.emit(() -> new ListDeserializer((JsonDeserializer)itemDeserializer.get()));
    }

    private Value<JsonDeserializer> createSetDeserializer(Type itemType, ReflectAnnotatedElement annotations) {
        Value<JsonDeserializer> itemDeserializer = this.createDeserializer(itemType, annotations);
        return Metaprogramming.emit(() -> new SetDeserializer((JsonDeserializer)itemDeserializer.get()));
    }

    private Value<Object> convertDate(Value<Node> value, ReflectAnnotatedElement annotations) {
        DateFormatInformation formatInfo = DateFormatInformation.get(annotations);
        if (formatInfo.asString) {
            String localeName = formatInfo.locale;
            String pattern = formatInfo.pattern;
            Value locale = formatInfo.locale != null ? Metaprogramming.emit(() -> new Locale(localeName)) : Metaprogramming.emit(() -> Locale.getDefault());
            return Metaprogramming.emit(() -> {
                SimpleDateFormat format = new SimpleDateFormat(pattern, (Locale)locale.get());
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    return !((Node)value.get()).isNull() ? format.parse(((StringNode)value.get()).getValue()) : null;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return Metaprogramming.emit(() -> {
            Node node = (Node)value.get();
            return !node.isNull() ? new Date((long)((NumberNode)node).getValue()) : null;
        });
    }

    private Value<Object> defaultValue(ReflectClass<?> type) {
        if (type.isPrimitive()) {
            switch (type.getName()) {
                case "boolean": {
                    return Metaprogramming.emit(() -> false);
                }
                case "byte": {
                    return Metaprogramming.emit(() -> (byte)0);
                }
                case "short": {
                    return Metaprogramming.emit(() -> (short)0);
                }
                case "char": {
                    return Metaprogramming.emit(() -> Character.valueOf('\u0000'));
                }
                case "int": {
                    return Metaprogramming.emit(() -> 0);
                }
                case "long": {
                    return Metaprogramming.emit(() -> 0L);
                }
                case "float": {
                    return Metaprogramming.emit(() -> Float.valueOf(0.0f));
                }
                case "double": {
                    return Metaprogramming.emit(() -> 0.0);
                }
            }
        }
        return Metaprogramming.emit(() -> null);
    }

    static {
        predefinedDeserializers.put(Object.class.getName(), BooleanDeserializer.class);
        predefinedDeserializers.put(Number.class.getName(), BooleanDeserializer.class);
        predefinedDeserializers.put(Boolean.class.getName(), BooleanDeserializer.class);
        predefinedDeserializers.put(Byte.class.getName(), ByteDeserializer.class);
        predefinedDeserializers.put(Short.class.getName(), ShortDeserializer.class);
        predefinedDeserializers.put(Character.class.getName(), CharacterDeserializer.class);
        predefinedDeserializers.put(Integer.class.getName(), IntegerDeserializer.class);
        predefinedDeserializers.put(Long.class.getName(), LongDeserializer.class);
        predefinedDeserializers.put(Float.class.getName(), FloatDeserializer.class);
        predefinedDeserializers.put(Double.class.getName(), DoubleDeserializer.class);
        predefinedDeserializers.put(String.class.getName(), StringDeserializer.class);
    }

    static class ObjectWithTag {
        Value<String> tag;
        Value<ObjectNode> object;

        ObjectWithTag(Value<String> tag, Value<ObjectNode> object) {
            this.tag = tag;
            this.object = object;
        }
    }
}

