/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.serializer;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class JsonSerializerContext {
    private int lastId;
    private Map<Object, Integer> ids = new IdentityHashMap<Object, Integer>();
    private Set<Object> touchedObjects = Collections.newSetFromMap(new IdentityHashMap());

    public boolean hasId(Object object) {
        return this.ids.containsKey(object);
    }

    public int getId(Object object) {
        Integer id = this.ids.get(object);
        if (id == null) {
            id = this.lastId++;
            this.ids.put(object, id);
        }
        return id;
    }

    public void touch(Object object) {
        if (this.touchedObjects.contains(object)) {
            throw new IllegalArgumentException("Object has already been serialized: " + object);
        }
        this.touchedObjects.add(object);
    }
}

