/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.teavm.classlib.java.util.TGenericEnumSet;

public abstract class TEnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    public static <E extends Enum<E>> TEnumSet<E> noneOf(Class<E> elementType) {
        return new TGenericEnumSet<E>(elementType);
    }

    public static <E extends Enum<E>> TEnumSet<E> allOf(Class<E> elementType) {
        Enum<E>[] constants = TGenericEnumSet.getConstants(elementType);
        if (constants == null) {
            throw new ClassCastException();
        }
        int count = constants.length;
        int[] bits = new int[count == 0 ? 0 : (count - 1) / 32 + 1];
        Arrays.fill(bits, -1);
        if (count > 0) {
            TEnumSet.zeroHighBits(bits, count);
        }
        return new TGenericEnumSet<E>(elementType, bits);
    }

    public static <E extends Enum<E>> TEnumSet<E> copyOf(TEnumSet<E> s) {
        TGenericEnumSet other = (TGenericEnumSet)s;
        return new TGenericEnumSet(other.cls, (int[])other.bits.clone());
    }

    public static <E extends Enum<E>> TEnumSet<E> copyOf(Collection<E> c) {
        if (c instanceof TEnumSet) {
            return TEnumSet.copyOf((TEnumSet)c);
        }
        Iterator<E> iter = c.iterator();
        if (!iter.hasNext()) {
            throw new IllegalArgumentException();
        }
        Enum first = (Enum)iter.next();
        TEnumSet<Enum> result = TEnumSet.noneOf(first.getDeclaringClass());
        result.add(first);
        while (iter.hasNext()) {
            result.add((Enum)iter.next());
        }
        return result;
    }

    public static <E extends Enum<E>> TEnumSet<E> complementOf(TEnumSet<E> s) {
        TGenericEnumSet other = (TGenericEnumSet)s;
        int count = TGenericEnumSet.getConstants(other.cls).length;
        int[] bits = new int[other.bits.length];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = ~other.bits[i];
        }
        TEnumSet.zeroHighBits(bits, count);
        return new TGenericEnumSet(other.cls, bits);
    }

    public static <E extends Enum<E>> TEnumSet<E> of(E e) {
        TEnumSet<E> result = TEnumSet.noneOf(e.getDeclaringClass());
        result.fastAdd(e);
        return result;
    }

    public static <E extends Enum<E>> TEnumSet<E> of(E e1, E e2) {
        TEnumSet<E> result = TEnumSet.noneOf(e1.getDeclaringClass());
        result.fastAdd(e1);
        result.fastAdd(e2);
        return result;
    }

    public static <E extends Enum<E>> TEnumSet<E> of(E e1, E e2, E e3) {
        TEnumSet<E> result = TEnumSet.noneOf(e1.getDeclaringClass());
        result.fastAdd(e1);
        result.fastAdd(e2);
        result.fastAdd(e3);
        return result;
    }

    public static <E extends Enum<E>> TEnumSet<E> of(E e1, E e2, E e3, E e4) {
        TEnumSet<E> result = TEnumSet.noneOf(e1.getDeclaringClass());
        result.fastAdd(e1);
        result.fastAdd(e2);
        result.fastAdd(e3);
        result.fastAdd(e4);
        return result;
    }

    public static <E extends Enum<E>> TEnumSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        TEnumSet<E> result = TEnumSet.noneOf(e1.getDeclaringClass());
        result.fastAdd(e1);
        result.fastAdd(e2);
        result.fastAdd(e3);
        result.fastAdd(e4);
        result.fastAdd(e5);
        return result;
    }

    @SafeVarargs
    public static <E extends Enum<E>> TEnumSet<E> of(E first, E ... rest) {
        TEnumSet<E> result = TEnumSet.noneOf(first.getDeclaringClass());
        result.fastAdd(first);
        for (E e : rest) {
            result.fastAdd(e);
        }
        return result;
    }

    public TEnumSet<E> clone() {
        return TEnumSet.copyOf(this);
    }

    public static <E extends Enum<E>> TEnumSet<E> range(E from, E to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        int fromIndex = from.ordinal();
        int toIndex = to.ordinal();
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        TEnumSet<E> result = TEnumSet.noneOf(from.getDeclaringClass());
        for (int i = fromIndex; i <= toIndex; ++i) {
            result.fastAdd(i);
        }
        return result;
    }

    void fastAdd(E t) {
        this.fastAdd(((Enum)t).ordinal());
    }

    abstract void fastAdd(int var1);

    private static void zeroHighBits(int[] bits, int count) {
        int n = bits.length - 1;
        bits[n] = bits[n] & -1 >>> 32 - count % 32;
    }
}

