/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import java.lang.reflect.Modifier;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TNoSuchFieldException;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.util.concurrent.atomic.TReflectionBasedAtomicReferenceFieldUpdater;

public abstract class TAtomicReferenceFieldUpdater<T, V> {
    protected TAtomicReferenceFieldUpdater() {
    }

    public static <U, W> TAtomicReferenceFieldUpdater<U, W> newUpdater(TClass<U> tclass, TClass<W> vclass, String fieldName) {
        try {
            TField field = tclass.getDeclaredField(fieldName);
            if (field.getType() != vclass) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) {
                throw new IllegalArgumentException();
            }
            field.checkGetAccess();
            field.checkSetAccess();
            return new TReflectionBasedAtomicReferenceFieldUpdater(field);
        }
        catch (TIllegalAccessException | TNoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T obj, V newValue) {
        V currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue)) {
        }
        return currentValue;
    }

    public final V getAndUpdate(T obj, UnaryOperator<V> updateFunction) {
        Object newValue;
        V currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = updateFunction.apply(currentValue))) {
        }
        return currentValue;
    }

    public final V updateAndGet(T obj, UnaryOperator<V> updateFunction) {
        Object newValue;
        V currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = updateFunction.apply(currentValue))) {
        }
        return (V)newValue;
    }

    public final V getAndAccumulate(T obj, V x, BinaryOperator<V> accumulatorFunction) {
        Object newValue;
        V currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = accumulatorFunction.apply(currentValue, x))) {
        }
        return currentValue;
    }

    public final V accumulateAndGet(T obj, V x, BinaryOperator<V> accumulatorFunction) {
        Object newValue;
        V currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = accumulatorFunction.apply(currentValue, x))) {
        }
        return (V)newValue;
    }
}

