/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.reflection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.teavm.common.DisjointSet;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.ProgramUtils;

public class ReflectionTransformer
implements ClassHolderTransformer {
    private static final MethodReference getNameMethod = new MethodReference(Class.class, "getName", new Class[]{String.class});
    private static final MethodReference forNameMethod = new MethodReference(Class.class, "forName", new Class[]{String.class, Boolean.TYPE, ClassLoader.class, Class.class});
    private static final MethodReference forNameShortMethod = new MethodReference(Class.class, "forName", new Class[]{String.class, Class.class});
    private static final MethodReference newRefUpdaterMethod = new MethodReference(AtomicReferenceFieldUpdater.class, "newUpdater", new Class[]{Class.class, Class.class, String.class, AtomicReferenceFieldUpdater.class});
    private static final MethodReference newIntUpdaterMethod = new MethodReference(AtomicIntegerFieldUpdater.class, "newUpdater", new Class[]{Class.class, String.class, AtomicIntegerFieldUpdater.class});
    private static final MethodReference newLongUpdaterMethod = new MethodReference(AtomicLongFieldUpdater.class, "newUpdater", new Class[]{Class.class, String.class, AtomicLongFieldUpdater.class});
    private static final MethodReference initMethod = new MethodReference(Class.class, "initialize", new Class[]{Void.TYPE});
    private Map<String, String> updaterClasses = new HashMap<String, String>();
    private boolean prepared;
    private DisjointSet varSet;
    private int[] nameRepresentatives;
    private String[] stringConstantsByClasses;
    private ValueType[] classConstantsByClasses;
    private boolean hasTruncatedBlocks;

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            Program program = method.getProgram();
            if (program == null) continue;
            this.transformProgram(program, context);
        }
    }

    private void transformProgram(Program program, ClassHolderTransformerContext context) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                if (!(instruction instanceof InvokeInstruction)) continue;
                InvokeInstruction invoke = (InvokeInstruction)instruction;
                MethodReference method = invoke.getMethod();
                if (method.equals((Object)forNameMethod) || method.equals((Object)forNameShortMethod)) {
                    this.transformForName(program, invoke, context);
                    continue;
                }
                if (method.equals((Object)newRefUpdaterMethod)) {
                    this.transformRefUpdater(program, invoke, context);
                    continue;
                }
                if (method.equals((Object)newIntUpdaterMethod)) {
                    this.transformPrimitiveUpdater(program, invoke, "java.util.concurrent.atomic.BaseAtomicIntegerFieldUpdater", (ValueType)ValueType.INTEGER, context);
                    continue;
                }
                if (!method.equals((Object)newLongUpdaterMethod)) continue;
                this.transformPrimitiveUpdater(program, invoke, "java.util.concurrent.atomic.BaseAtomicLongFieldUpdater", (ValueType)ValueType.LONG, context);
            }
        }
        if (this.hasTruncatedBlocks) {
            new UnreachableBasicBlockEliminator().optimize(program);
        }
        this.cleanup();
    }

    private void prepare(Program program) {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        this.varSet = new DisjointSet();
        for (int i = 0; i < program.variableCount(); ++i) {
            this.varSet.create();
        }
        int[] nameIndexes = new int[program.variableCount()];
        String[] stringConstants = new String[program.variableCount()];
        ValueType[] classConstants = new ValueType[program.variableCount()];
        Arrays.fill(nameIndexes, -1);
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                if (instruction instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)instruction;
                    if (!invoke.getMethod().equals((Object)getNameMethod) || invoke.getReceiver() == null) continue;
                    nameIndexes[invoke.getReceiver().getIndex()] = invoke.getInstance().getIndex();
                    continue;
                }
                if (instruction instanceof StringConstantInstruction) {
                    StringConstantInstruction stringConstant = (StringConstantInstruction)instruction;
                    stringConstants[stringConstant.getReceiver().getIndex()] = stringConstant.getConstant();
                    continue;
                }
                if (instruction instanceof ClassConstantInstruction) {
                    ClassConstantInstruction classConstant = (ClassConstantInstruction)instruction;
                    classConstants[classConstant.getReceiver().getIndex()] = classConstant.getConstant();
                    continue;
                }
                if (!(instruction instanceof AssignInstruction)) continue;
                AssignInstruction assign = (AssignInstruction)instruction;
                this.varSet.union(assign.getAssignee().getIndex(), assign.getReceiver().getIndex());
            }
        }
        this.nameRepresentatives = new int[this.varSet.size()];
        Arrays.fill(this.nameRepresentatives, -1);
        this.stringConstantsByClasses = new String[this.varSet.size()];
        this.classConstantsByClasses = new ValueType[this.varSet.size()];
        for (int i = 0; i < program.variableCount(); ++i) {
            int varClass = this.varSet.find(i);
            if (nameIndexes[i] >= 0) {
                this.nameRepresentatives[varClass] = this.varSet.find(nameIndexes[i]);
            }
            this.stringConstantsByClasses[varClass] = stringConstants[i];
            this.classConstantsByClasses[varClass] = classConstants[i];
        }
    }

    private void cleanup() {
        if (this.prepared) {
            this.prepared = false;
            this.hasTruncatedBlocks = false;
            this.varSet = null;
            this.nameRepresentatives = null;
            this.stringConstantsByClasses = null;
            this.classConstantsByClasses = null;
        }
    }

    private void transformForName(Program program, InvokeInstruction invoke, ClassHolderTransformerContext context) {
        Variable representative;
        ClassHierarchy hierarchy = context.getHierarchy();
        this.prepare(program);
        int classNameIndex = this.varSet.find(((Variable)invoke.getArguments().get(0)).getIndex());
        int nameIndex = this.nameRepresentatives[classNameIndex];
        String constant = this.stringConstantsByClasses[classNameIndex];
        if (nameIndex >= 0) {
            representative = program.variableAt(nameIndex);
        } else if (constant != null) {
            if (hierarchy.getClassSource().get(constant) == null || !this.filterClassName(constant)) {
                this.emitException((Instruction)invoke, ClassNotFoundException.class);
                return;
            }
            ClassConstantInstruction classConstant = new ClassConstantInstruction();
            classConstant.setConstant((ValueType)ValueType.object((String)constant));
            classConstant.setReceiver(program.createVariable());
            classConstant.setLocation(invoke.getLocation());
            invoke.insertPrevious((Instruction)classConstant);
            representative = classConstant.getReceiver();
        } else {
            return;
        }
        InvokeInstruction initInvoke = new InvokeInstruction();
        initInvoke.setLocation(invoke.getLocation());
        initInvoke.setType(InvocationType.SPECIAL);
        initInvoke.setMethod(initMethod);
        initInvoke.setInstance(representative);
        invoke.insertPrevious((Instruction)initInvoke);
        if (invoke.getReceiver() == null) {
            invoke.delete();
        } else {
            AssignInstruction assign = new AssignInstruction();
            assign.setLocation(invoke.getLocation());
            assign.setAssignee(representative);
            assign.setReceiver(invoke.getReceiver());
            invoke.replace((Instruction)assign);
        }
    }

    private void transformRefUpdater(Program program, InvokeInstruction invoke, ClassHolderTransformerContext context) {
        this.prepare(program);
        ValueType targetTypeConstant = this.classConstantsByClasses[this.varSet.find(((Variable)invoke.getArguments().get(0)).getIndex())];
        ValueType varTypeConstant = this.classConstantsByClasses[this.varSet.find(((Variable)invoke.getArguments().get(1)).getIndex())];
        String nameConstant = this.stringConstantsByClasses[this.varSet.find(((Variable)invoke.getArguments().get(2)).getIndex())];
        if (targetTypeConstant == null || varTypeConstant == null || nameConstant == null) {
            return;
        }
        if (!(targetTypeConstant instanceof ValueType.Object)) {
            this.emitException((Instruction)invoke, IllegalArgumentException.class);
            return;
        }
        String className = ((ValueType.Object)targetTypeConstant).getClassName();
        ClassReader cls = context.getHierarchy().getClassSource().get(className);
        if (cls == null) {
            this.emitException((Instruction)invoke, NoClassDefFoundError.class);
            return;
        }
        FieldReader field = cls.getField(nameConstant);
        if (field == null) {
            this.emitException((Instruction)invoke, RuntimeException.class, NoSuchFieldException.class);
            return;
        }
        if (!field.getType().equals(varTypeConstant)) {
            this.emitException((Instruction)invoke, ClassCastException.class);
            return;
        }
        if (!field.hasModifier(ElementModifier.VOLATILE) || varTypeConstant instanceof ValueType.Primitive || varTypeConstant == ValueType.VOID || field.hasModifier(ElementModifier.STATIC)) {
            this.emitException((Instruction)invoke, IllegalArgumentException.class);
            return;
        }
        String updaterClassName = this.getRefUpdaterClass(context, field);
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference(updaterClassName, "INSTANCE"));
        getField.setFieldType((ValueType)ValueType.object((String)updaterClassName));
        getField.setLocation(invoke.getLocation());
        getField.setReceiver(invoke.getReceiver());
        invoke.replace((Instruction)getField);
    }

    private String getRefUpdaterClass(ClassHolderTransformerContext context, FieldReader field) {
        String key = field.getReference().toString();
        return this.updaterClasses.computeIfAbsent(key, k -> this.createRefUpdaterClass(context, field));
    }

    private String createRefUpdaterClass(ClassHolderTransformerContext context, FieldReader field) {
        String className = field.getOwnerName() + "$" + field.getName() + "$_AtomicUpdater$";
        ClassHolder updaterClass = new ClassHolder(className);
        updaterClass.setLevel(AccessLevel.PUBLIC);
        updaterClass.setParent("java.util.concurrent.atomic.BaseAtomicReferenceFieldUpdater");
        this.fillClass(updaterClass, field.getOwnerName(), context.getHierarchy());
        updaterClass.addMethod(this.createGetRefMethod(field, className, context.getHierarchy()));
        updaterClass.addMethod(this.createSetRefMethod(field, className, context.getHierarchy()));
        context.submit(updaterClass);
        return className;
    }

    private MethodHolder createGetRefMethod(FieldReader field, String className, ClassHierarchy hierarchy) {
        MethodHolder method = new MethodHolder("get", new ValueType[]{ValueType.object((String)"java.lang.Object"), ValueType.object((String)"java.lang.Object")});
        method.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter instance = pe.var(1, Object.class);
        pe.invoke(className, "check", (ValueType)ValueType.object((String)field.getOwnerName()), new ValueEmitter[]{instance}).getField(field.getName(), field.getType()).returnValue();
        return method;
    }

    private MethodHolder createSetRefMethod(FieldReader field, String className, ClassHierarchy hierarchy) {
        MethodHolder method = new MethodHolder("set", new ValueType[]{ValueType.object((String)"java.lang.Object"), ValueType.object((String)"java.lang.Object"), ValueType.VOID});
        method.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter instance = pe.var(1, Object.class);
        ValueEmitter value = pe.var(2, Object.class);
        pe.invoke(className, "check", (ValueType)ValueType.object((String)field.getOwnerName()), new ValueEmitter[]{instance}).setField(field.getName(), value.cast(field.getType()));
        pe.exit();
        return method;
    }

    private void transformPrimitiveUpdater(Program program, InvokeInstruction invoke, String superclass, ValueType primitiveType, ClassHolderTransformerContext context) {
        this.prepare(program);
        ValueType targetTypeConstant = this.classConstantsByClasses[this.varSet.find(((Variable)invoke.getArguments().get(0)).getIndex())];
        String nameConstant = this.stringConstantsByClasses[this.varSet.find(((Variable)invoke.getArguments().get(1)).getIndex())];
        if (targetTypeConstant == null || nameConstant == null) {
            return;
        }
        if (!(targetTypeConstant instanceof ValueType.Object)) {
            this.emitException((Instruction)invoke, IllegalArgumentException.class);
            return;
        }
        String className = ((ValueType.Object)targetTypeConstant).getClassName();
        ClassReader cls = context.getHierarchy().getClassSource().get(className);
        if (cls == null) {
            this.emitException((Instruction)invoke, NoClassDefFoundError.class);
            return;
        }
        FieldReader field = cls.getField(nameConstant);
        if (field == null) {
            this.emitException((Instruction)invoke, RuntimeException.class, NoSuchFieldException.class);
            return;
        }
        if (!field.hasModifier(ElementModifier.VOLATILE) || field.hasModifier(ElementModifier.STATIC) || !field.getType().equals(primitiveType)) {
            this.emitException((Instruction)invoke, IllegalArgumentException.class);
            return;
        }
        String updaterClassName = this.getPrimitiveUpdaterClass(context, field, superclass);
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference(updaterClassName, "INSTANCE"));
        getField.setFieldType((ValueType)ValueType.object((String)updaterClassName));
        getField.setLocation(invoke.getLocation());
        getField.setReceiver(invoke.getReceiver());
        invoke.replace((Instruction)getField);
    }

    private String getPrimitiveUpdaterClass(ClassHolderTransformerContext context, FieldReader field, String superclass) {
        String key = field.getReference().toString();
        return this.updaterClasses.computeIfAbsent(key, k -> this.createPrimitiveUpdaterClass(context, field, superclass));
    }

    private String createPrimitiveUpdaterClass(ClassHolderTransformerContext context, FieldReader field, String superclass) {
        String className = field.getOwnerName() + "$" + field.getName() + "$_AtomicUpdater$";
        ClassHolder updaterClass = new ClassHolder(className);
        updaterClass.setLevel(AccessLevel.PUBLIC);
        updaterClass.setParent(superclass);
        this.fillClass(updaterClass, field.getOwnerName(), context.getHierarchy());
        updaterClass.addMethod(this.createGetPrimitiveMethod(field, className, context.getHierarchy()));
        updaterClass.addMethod(this.createSetPrimitiveMethod(field, className, context.getHierarchy()));
        context.submit(updaterClass);
        return className;
    }

    private MethodHolder createGetPrimitiveMethod(FieldReader field, String className, ClassHierarchy hierarchy) {
        MethodHolder method = new MethodHolder("get", new ValueType[]{ValueType.object((String)"java.lang.Object"), field.getType()});
        method.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter instance = pe.var(1, Object.class);
        pe.invoke(className, "check", (ValueType)ValueType.object((String)field.getOwnerName()), new ValueEmitter[]{instance}).getField(field.getName(), field.getType()).returnValue();
        return method;
    }

    private MethodHolder createSetPrimitiveMethod(FieldReader field, String className, ClassHierarchy hierarchy) {
        MethodHolder method = new MethodHolder("set", new ValueType[]{ValueType.object((String)"java.lang.Object"), field.getType(), ValueType.VOID});
        method.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter instance = pe.var(1, Object.class);
        ValueEmitter value = pe.var(2, field.getType());
        pe.invoke(className, "check", (ValueType)ValueType.object((String)field.getOwnerName()), new ValueEmitter[]{instance}).setField(field.getName(), value);
        pe.exit();
        return method;
    }

    private void fillClass(ClassHolder cls, String targetClassName, ClassHierarchy hierarchy) {
        FieldHolder instanceField = new FieldHolder("INSTANCE");
        instanceField.setType((ValueType)ValueType.object((String)cls.getName()));
        instanceField.setLevel(AccessLevel.PUBLIC);
        instanceField.getModifiers().add(ElementModifier.STATIC);
        cls.addField(instanceField);
        cls.addMethod(this.createConstructor(cls, hierarchy));
        cls.addMethod(this.createInitializer(cls, hierarchy));
        cls.addMethod(this.createCheck(targetClassName, hierarchy));
    }

    private MethodHolder createConstructor(ClassHolder cls, ClassHierarchy hierarchy) {
        MethodHolder ctor = new MethodHolder("<init>", new ValueType[]{ValueType.VOID});
        ctor.setLevel(AccessLevel.PRIVATE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)ctor, (ClassHierarchy)hierarchy);
        pe.var(0, AtomicReferenceFieldUpdater.class).invokeSpecial(cls.getParent(), "<init>", (ValueType)ValueType.VOID, new ValueEmitter[0]);
        pe.exit();
        return ctor;
    }

    private MethodHolder createInitializer(ClassHolder cls, ClassHierarchy hierarchy) {
        MethodHolder initializer = new MethodHolder("<clinit>", new ValueType[]{ValueType.VOID});
        initializer.setLevel(AccessLevel.PRIVATE);
        initializer.getModifiers().add(ElementModifier.STATIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)initializer, (ClassHierarchy)hierarchy);
        pe.setField(cls.getName(), "INSTANCE", pe.construct(cls.getName(), new ValueEmitter[0]));
        pe.exit();
        return initializer;
    }

    private MethodHolder createCheck(String targetClassName, ClassHierarchy hierarchy) {
        MethodHolder method = new MethodHolder("check", new ValueType[]{ValueType.object((String)"java.lang.Object"), ValueType.object((String)targetClassName)});
        method.setLevel(AccessLevel.PRIVATE);
        method.getModifiers().add(ElementModifier.STATIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter instance = pe.var(1, (ValueType)ValueType.object((String)"java.lang.Object"));
        pe.when(instance.isNull()).thenDo(() -> pe.construct(ClassCastException.class, new ValueEmitter[0]).raise());
        instance.cast((ValueType)ValueType.object((String)targetClassName)).returnValue();
        return method;
    }

    private void emitException(Instruction instruction, Class<?> exceptionType) {
        this.emitException(instruction, exceptionType, null);
    }

    private void emitException(Instruction instruction, Class<?> exceptionType, Class<?> wrappedExceptionType) {
        this.hasTruncatedBlocks = true;
        ProgramUtils.truncateBlock((Instruction)instruction);
        Program program = instruction.getProgram();
        BasicBlock block = instruction.getBasicBlock();
        ConstructInstruction construct = new ConstructInstruction();
        construct.setType(exceptionType.getName());
        construct.setReceiver(program.createVariable());
        construct.setLocation(instruction.getLocation());
        block.add((Instruction)construct);
        InvokeInstruction init = new InvokeInstruction();
        init.setType(InvocationType.SPECIAL);
        init.setInstance(construct.getReceiver());
        if (wrappedExceptionType != null) {
            ConstructInstruction wrappedConstruct = new ConstructInstruction();
            wrappedConstruct.setType(wrappedExceptionType.getName());
            wrappedConstruct.setReceiver(program.createVariable());
            wrappedConstruct.setLocation(instruction.getLocation());
            block.add((Instruction)wrappedConstruct);
            InvokeInstruction wrappedInit = new InvokeInstruction();
            wrappedInit.setType(InvocationType.SPECIAL);
            wrappedInit.setInstance(wrappedConstruct.getReceiver());
            wrappedInit.setMethod(new MethodReference(wrappedExceptionType, "<init>", new Class[]{Void.TYPE}));
            wrappedInit.setLocation(instruction.getLocation());
            block.add((Instruction)wrappedInit);
            init.setMethod(new MethodReference(exceptionType, "<init>", new Class[]{Throwable.class, Void.TYPE}));
            init.setArguments(new Variable[]{wrappedConstruct.getReceiver()});
        } else {
            init.setMethod(new MethodReference(exceptionType, "<init>", new Class[]{Void.TYPE}));
        }
        init.setLocation(instruction.getLocation());
        block.add((Instruction)init);
        RaiseInstruction raise = new RaiseInstruction();
        raise.setException(construct.getReceiver());
        raise.setLocation(instruction.getLocation());
        block.add((Instruction)raise);
        instruction.delete();
    }

    private boolean filterClassName(String className) {
        switch (className) {
            case "kotlin.reflect.jvm.internal.ReflectionFactoryImpl": {
                return false;
            }
        }
        return true;
    }
}

