/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import org.teavm.classlib.impl.reflection.Converter;
import org.teavm.classlib.impl.reflection.Flags;
import org.teavm.classlib.impl.reflection.JSFieldGetter;
import org.teavm.classlib.impl.reflection.JSFieldSetter;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.reflect.TAccessibleObject;
import org.teavm.classlib.java.lang.reflect.TMember;
import org.teavm.classlib.java.lang.reflect.TModifier;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformObject;

public class TField
extends TAccessibleObject
implements TMember {
    private TClass<?> declaringClass;
    private String name;
    private int modifiers;
    private int accessLevel;
    private TClass<?> type;
    private JSFieldGetter getter;
    private JSFieldSetter setter;

    public TField(TClass<?> declaringClass, String name, int modifiers, int accessLevel, TClass<?> type, JSFieldGetter getter, JSFieldSetter setter) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.modifiers = modifiers;
        this.accessLevel = accessLevel;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public TClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return Flags.getModifiers(this.modifiers, this.accessLevel);
    }

    public boolean isEnumConstant() {
        return (this.modifiers & 8) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.modifiers & 0x20) != 0;
    }

    public TClass<?> getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TModifier.toString(this.getModifiers()));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getType().getName()).append(' ').append(this.declaringClass.getName()).append(".").append(this.name);
        return sb.toString();
    }

    public Object get(Object obj) throws TIllegalArgumentException, TIllegalAccessException {
        this.checkGetAccess();
        this.checkInstance(obj);
        return this.getWithoutCheck(obj);
    }

    public Object getWithoutCheck(Object obj) {
        PlatformObject result = this.getter.get(Platform.getPlatformObject((Object)obj));
        return Converter.toJava(result);
    }

    public void set(Object obj, Object value) throws TIllegalArgumentException, TIllegalAccessException {
        this.checkSetAccess();
        this.checkInstance(obj);
        this.setWithoutCheck(obj, value);
    }

    public void setWithoutCheck(Object obj, Object value) {
        this.setter.set(Platform.getPlatformObject((Object)obj), Converter.fromJava(value));
    }

    private void checkInstance(Object obj) {
        if ((this.modifiers & 0x200) == 0) {
            if (obj == null) {
                throw new NullPointerException();
            }
            if (!this.declaringClass.isInstance((TObject)obj)) {
                throw new TIllegalArgumentException();
            }
        }
    }

    public void checkGetAccess() throws TIllegalAccessException {
        if (this.getter == null) {
            throw new TIllegalAccessException();
        }
    }

    public void checkSetAccess() throws TIllegalAccessException {
        if (this.setter == null) {
            throw new TIllegalAccessException();
        }
    }
}

