/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.io.TReader;
import org.teavm.classlib.java.io.TUnsupportedEncodingException;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.TCharsetDecoder;
import org.teavm.classlib.java.nio.charset.TCoderResult;
import org.teavm.classlib.java.nio.charset.TCodingErrorAction;
import org.teavm.classlib.java.nio.charset.TUnsupportedCharsetException;
import org.teavm.classlib.java.nio.charset.impl.TUTF8Charset;

public class TInputStreamReader
extends TReader {
    private TInputStream stream;
    private TCharsetDecoder decoder;
    private byte[] inData = new byte[8192];
    private TByteBuffer inBuffer = TByteBuffer.wrap(this.inData);
    private char[] outData = new char[1024];
    private TCharBuffer outBuffer = TCharBuffer.wrap(this.outData);
    private boolean streamEof;
    private boolean eof;

    public TInputStreamReader(TInputStream in, String charsetName) throws TUnsupportedEncodingException {
        this(in, TInputStreamReader.getCharset(charsetName));
    }

    public TInputStreamReader(TInputStream in, TCharset charset) {
        this(in, charset.newDecoder().onMalformedInput(TCodingErrorAction.REPLACE).onUnmappableCharacter(TCodingErrorAction.REPLACE));
    }

    public TInputStreamReader(TInputStream in) {
        this(in, TUTF8Charset.INSTANCE);
    }

    public TInputStreamReader(TInputStream in, TCharsetDecoder decoder) {
        this.stream = in;
        this.decoder = decoder;
        this.outBuffer.position(this.outBuffer.limit());
        this.inBuffer.position(this.inBuffer.limit());
    }

    private static TCharset getCharset(String charsetName) throws TUnsupportedEncodingException {
        try {
            return TCharset.forName(charsetName.toString());
        }
        catch (TUnsupportedCharsetException e) {
            throw new TUnsupportedEncodingException(charsetName);
        }
    }

    public String getEncoding() {
        return this.decoder.charset().name();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public int read() throws IOException {
        if (this.eof && !this.outBuffer.hasRemaining()) {
            return -1;
        }
        this.ensureBufferHasData(true);
        return this.outBuffer.hasRemaining() ? (int)this.outBuffer.get() : -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int sz;
        if (!this.outBuffer.hasRemaining()) {
            if (this.eof) {
                return -1;
            }
            if (len == 0) {
                return 0;
            }
            this.ensureBufferHasData(true);
        } else if (len == 0) {
            return 0;
        }
        int bytesRead = 0;
        do {
            sz = Math.min(len, this.outBuffer.remaining());
            this.outBuffer.get(cbuf, off + bytesRead, sz);
            bytesRead += sz;
        } while ((len -= sz) > 0 && this.ensureBufferHasData(false));
        return bytesRead;
    }

    private boolean ensureBufferHasData(boolean force) throws IOException {
        if (this.outBuffer.hasRemaining()) {
            return true;
        }
        return this.fillBuffer(force);
    }

    private boolean fillBuffer(boolean force) throws IOException {
        if (this.eof) {
            return false;
        }
        this.outBuffer.compact();
        boolean readSomething = !force;
        boolean hasAvailable = true;
        boolean decoderCalled = false;
        while (true) {
            if (this.inBuffer.hasRemaining()) {
                int posBefore = this.outBuffer.position();
                TCoderResult result = this.decoder.decode(this.inBuffer, this.outBuffer, this.streamEof);
                decoderCalled = true;
                readSomething |= this.outBuffer.position() > posBefore;
                if (result.isOverflow()) break;
                if (!result.isUnderflow()) continue;
            }
            if (this.stream.available() <= 0 && readSomething) {
                hasAvailable = false;
                break;
            }
            if (!this.fillReadBuffer()) break;
        }
        if (!this.inBuffer.hasRemaining() && this.streamEof && (!decoderCalled || this.decoder.flush(this.outBuffer).isUnderflow())) {
            this.eof = true;
        }
        this.outBuffer.flip();
        return hasAvailable;
    }

    private boolean fillReadBuffer() throws IOException {
        if (this.streamEof) {
            return false;
        }
        this.inBuffer.compact();
        while (this.inBuffer.hasRemaining()) {
            int bytesRead = this.stream.read(this.inBuffer.array(), this.inBuffer.position(), this.inBuffer.remaining());
            if (bytesRead == -1) {
                this.streamEof = true;
                break;
            }
            if (bytesRead <= 0) continue;
            this.inBuffer.position(this.inBuffer.position() + bytesRead);
            break;
        }
        this.inBuffer.flip();
        return true;
    }

    @Override
    public boolean ready() throws IOException {
        return this.outBuffer.hasRemaining() || this.inBuffer.hasRemaining() || this.stream.available() > 0;
    }
}

