/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TInvalidMarkException;

public abstract class TBuffer {
    TBuffer nextRef;
    int position;
    int limit;
    int mark = -1;

    TBuffer() {
    }

    public final int capacity() {
        return this.capacityImpl();
    }

    abstract int capacityImpl();

    public final int position() {
        return this.position;
    }

    public TBuffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException("New position " + newPosition + " is outside of range [0;" + this.limit + "]");
        }
        this.position = newPosition;
        if (newPosition < this.mark) {
            this.mark = 0;
        }
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public TBuffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.capacity()) {
            throw new IllegalArgumentException();
        }
        if (this.mark > newLimit) {
            this.mark = -1;
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        return this;
    }

    public TBuffer mark() {
        this.mark = this.position;
        return this;
    }

    public TBuffer reset() {
        if (this.mark < 0) {
            throw new TInvalidMarkException();
        }
        this.position = this.mark;
        return this;
    }

    public TBuffer clear() {
        this.position = 0;
        this.limit = this.capacity();
        this.mark = -1;
        return this;
    }

    public TBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public TBuffer rewind() {
        this.mark = -1;
        this.position = 0;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    public abstract boolean hasArray();

    public abstract Object array();

    public abstract int arrayOffset();

    public abstract boolean isDirect();
}

