/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferImpl;

class TCharBufferOverArray
extends TCharBufferImpl {
    private boolean readOnly;
    private int start;
    private int capacity;
    private char[] array;

    TCharBufferOverArray(int capacity) {
        this(0, capacity, new char[capacity], 0, capacity, false);
    }

    TCharBufferOverArray(int start, int capacity, char[] array, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TCharBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TCharBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    char getChar(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putChar(int index, char value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    char[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    void getImpl(int index, char[] dst, int offset, int length) {
        System.arraycopy(this.array, this.start + index, dst, offset, length);
    }

    @Override
    void putImpl(int index, char[] src, int offset, int length) {
        System.arraycopy(src, offset, this.array, this.start + index, length);
    }

    @Override
    void putImpl(int index, TCharBuffer src, int offset, int length) {
        if (src.hasArray()) {
            System.arraycopy(src.array(), src.arrayOffset() + offset, this.array, this.start + index, length);
        } else {
            while (length-- > 0) {
                src.put(offset++, this.getChar(index++));
            }
        }
    }

    @Override
    void putImpl(int index, String src, int offset, int length) {
        src.getChars(offset, offset + length, this.array, this.start + index);
    }
}

