/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferImpl;

abstract class TIntBufferOverByteBuffer
extends TIntBufferImpl {
    TByteBufferImpl byteBuffer;
    private boolean readOnly;
    int start;
    private int capacity;

    TIntBufferOverByteBuffer(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.byteBuffer = byteBuffer;
        this.readOnly = readOnly;
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    int[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    void getImpl(int index, int[] dst, int offset, int length) {
        while (length-- > 0) {
            dst[offset++] = this.getElement(index++);
        }
    }

    @Override
    void putImpl(int index, int[] src, int offset, int length) {
        while (length-- > 0) {
            this.putElement(index++, src[offset++]);
        }
    }

    @Override
    void putImpl(int index, TIntBuffer src, int offset, int length) {
        if (src instanceof TIntBufferOverByteBuffer && src.order() == this.order()) {
            TIntBufferOverByteBuffer srcImpl = (TIntBufferOverByteBuffer)src;
            System.arraycopy(srcImpl.byteBuffer.array, srcImpl.start + index * 4, this.byteBuffer.array, this.start + offset * 4, length * 4);
        } else {
            while (length-- > 0) {
                this.putElement(index++, src.getElement(offset++));
            }
        }
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }
}

