/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferImpl;

class TLongBufferOverArray
extends TLongBufferImpl {
    private boolean readOnly;
    private int start;
    private int capacity;
    private long[] array;

    TLongBufferOverArray(int capacity) {
        this(0, capacity, new long[capacity], 0, capacity, false);
    }

    TLongBufferOverArray(int start, int capacity, long[] array, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TLongBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TLongBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    long getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, long value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    long[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    void getImpl(int index, long[] dst, int offset, int length) {
        System.arraycopy(this.array, this.start + index, dst, offset, length);
    }

    @Override
    void putImpl(int index, long[] src, int offset, int length) {
        System.arraycopy(src, offset, this.array, this.start + index, length);
    }

    @Override
    void putImpl(int index, TLongBuffer src, int offset, int length) {
        if (src.hasArray()) {
            System.arraycopy(src.array(), src.arrayOffset() + offset, this.array, this.start + index, length);
        } else {
            while (length-- > 0) {
                src.putElement(offset++, this.getElement(index++));
            }
        }
    }
}

