/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.util.TAbstractList;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TList;
import org.teavm.classlib.java.util.TListIterator;
import org.teavm.classlib.java.util.TRandomAccess;

class TReversedList<E>
extends TAbstractList<E> {
    private final TList<E> base;

    TReversedList(TList<E> base) {
        this.base = base;
    }

    @Override
    public E get(int index) {
        return this.base.get(this.size() - index - 1);
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public E set(int index, E element) {
        return this.base.set(this.size() - index - 1, element);
    }

    @Override
    public void add(int index, E element) {
        this.base.add(this.size() - index, element);
    }

    @Override
    public E remove(int index) {
        return this.base.remove(this.size() - index - 1);
    }

    @Override
    public void addFirst(E element) {
        this.base.addLast(element);
    }

    @Override
    public void addLast(E element) {
        this.base.addFirst(element);
    }

    @Override
    public E removeFirst() {
        return this.base.remove(this.size() - 1);
    }

    @Override
    public E removeLast() {
        return this.base.remove(0);
    }

    @Override
    public E getFirst() {
        return this.base.getLast();
    }

    @Override
    public E getLast() {
        return this.base.getFirst();
    }

    @Override
    public TIterator<E> iterator() {
        final TListIterator<E> lit = this.base.listIterator(this.size());
        return new TIterator<E>(){

            @Override
            public boolean hasNext() {
                return lit.hasPrevious();
            }

            @Override
            public E next() {
                return lit.previous();
            }

            @Override
            public void remove() {
                lit.remove();
            }
        };
    }

    @Override
    public TListIterator<E> listIterator() {
        return new ReversedListIterator<E>(this, this.base.listIterator(this.base.size()));
    }

    @Override
    public TListIterator<E> listIterator(int idx) {
        return new ReversedListIterator<E>(this, this.base.listIterator(this.base.size() - idx));
    }

    @Override
    public void clear() {
        this.base.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.base.contains(o);
    }

    @Override
    public TList<E> reversed() {
        return this.base;
    }

    private static class ReversedListIterator<E>
    implements TListIterator<E> {
        private final TList<E> list;
        private final TListIterator<E> lit;

        private ReversedListIterator(TList<E> list, TListIterator<E> lit) {
            this.list = list;
            this.lit = lit;
        }

        @Override
        public boolean hasPrevious() {
            return this.lit.hasNext();
        }

        @Override
        public E previous() {
            return this.lit.next();
        }

        @Override
        public int nextIndex() {
            return this.list.size() - this.lit.previousIndex() - 1;
        }

        @Override
        public int previousIndex() {
            return this.list.size() - this.lit.nextIndex() - 1;
        }

        @Override
        public void set(E e) {
            this.lit.set(e);
        }

        @Override
        public void add(E e) {
            this.lit.add(e);
        }

        @Override
        public boolean hasNext() {
            return this.lit.hasPrevious();
        }

        @Override
        public E next() {
            return this.lit.previous();
        }

        @Override
        public void remove() {
            this.lit.remove();
        }
    }

    static class RandomAccess<E>
    extends TReversedList<E>
    implements TRandomAccess {
        RandomAccess(TList<E> base) {
            super(base);
        }
    }
}

