/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.Era;
import org.threeten.bp.chrono.JapaneseChronology;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.ValueRange;

public final class JapaneseEra
implements Era,
Serializable {
    static final int ERA_OFFSET = 2;
    public static final JapaneseEra MEIJI = new JapaneseEra(-1, LocalDate.of(1868, 9, 8), "Meiji");
    public static final JapaneseEra TAISHO = new JapaneseEra(0, LocalDate.of(1912, 7, 30), "Taisho");
    public static final JapaneseEra SHOWA = new JapaneseEra(1, LocalDate.of(1926, 12, 25), "Showa");
    public static final JapaneseEra HEISEI = new JapaneseEra(2, LocalDate.of(1989, 1, 8), "Heisei");
    public static final JapaneseEra REIWA = new JapaneseEra(3, LocalDate.of(2019, 5, 1), "Reiwa");
    private static final int ADDITIONAL_VALUE = 4;
    private static JapaneseEra[] knownEras;
    private final int eraValue;
    private final transient LocalDate since;
    private final transient String name;

    private JapaneseEra(int eraValue, LocalDate since, String name) {
        this.eraValue = eraValue;
        this.since = since;
        this.name = name;
    }

    public static JapaneseEra registerEra(LocalDate since, String name) {
        JapaneseEra[] known = knownEras;
        if (known.length > 5) {
            throw new DateTimeException("Only one additional Japanese era can be added");
        }
        Objects.requireNonNull(since, "since");
        Objects.requireNonNull(name, "name");
        if (!since.isAfter(JapaneseEra.REIWA.since)) {
            throw new DateTimeException("Invalid since date for additional Japanese era, must be after Reiwa");
        }
        JapaneseEra era = new JapaneseEra(4, since, name);
        JapaneseEra[] newArray = Arrays.copyOf(known, 6);
        newArray[5] = era;
        knownEras = newArray;
        return era;
    }

    public static JapaneseEra of(int japaneseEra) {
        JapaneseEra[] known = knownEras;
        if (japaneseEra < JapaneseEra.MEIJI.eraValue || japaneseEra > known[known.length - 1].eraValue) {
            throw new DateTimeException("japaneseEra is invalid");
        }
        return known[JapaneseEra.ordinal(japaneseEra)];
    }

    public static JapaneseEra valueOf(String japaneseEra) {
        JapaneseEra[] known;
        Objects.requireNonNull(japaneseEra, "japaneseEra");
        for (JapaneseEra era : known = knownEras) {
            if (!japaneseEra.equals(era.name)) continue;
            return era;
        }
        throw new IllegalArgumentException("Era not found: " + japaneseEra);
    }

    public static JapaneseEra[] values() {
        JapaneseEra[] known = knownEras;
        return Arrays.copyOf(known, known.length);
    }

    static JapaneseEra from(LocalDate date) {
        if (date.isBefore(JapaneseEra.MEIJI.since)) {
            throw new DateTimeException("Date too early: " + String.valueOf(date));
        }
        JapaneseEra[] known = knownEras;
        for (int i = known.length - 1; i >= 0; --i) {
            JapaneseEra era = known[i];
            if (date.compareTo(era.since) < 0) continue;
            return era;
        }
        return null;
    }

    private static int ordinal(int eraValue) {
        return eraValue + 1;
    }

    LocalDate startDate() {
        return this.since;
    }

    LocalDate endDate() {
        JapaneseEra[] eras;
        int ordinal = JapaneseEra.ordinal(this.eraValue);
        if (ordinal >= (eras = JapaneseEra.values()).length - 1) {
            return LocalDate.MAX;
        }
        return eras[ordinal + 1].startDate().minusDays(1L);
    }

    @Override
    public int getValue() {
        return this.eraValue;
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.ERA) {
            return JapaneseChronology.INSTANCE.range(ChronoField.ERA);
        }
        return Era.super.range(field);
    }

    public String toString() {
        return this.name;
    }

    static {
        JapaneseEra[] array = new JapaneseEra[]{MEIJI, TAISHO, SHOWA, HEISEI, REIWA};
        knownEras = array;
    }
}

