/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.teavm.classlib.impl.Base46;
import org.teavm.classlib.impl.CharFlow;
import org.teavm.classlib.impl.tz.AliasDateTimeZone;
import org.teavm.classlib.impl.tz.DateTimeZone;
import org.teavm.classlib.impl.tz.FixedDateTimeZone;
import org.teavm.classlib.impl.tz.StorableDateTimeZone;
import org.teavm.classlib.impl.tz.TimeZoneGenerator;
import org.teavm.classlib.impl.tz.ZoneInfoCompiler;

public class TimeZoneCache {
    public void write(OutputStream output, Collection<StorableDateTimeZone> timeZones) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (StorableDateTimeZone timeZone : timeZones) {
            writer.append(timeZone.getID()).append(' ');
            timeZone.write(sb);
            writer.append(sb);
            sb.setLength(0);
            writer.append('\n');
        }
        writer.flush();
    }

    public Map<String, StorableDateTimeZone> read(InputStream input) throws IOException {
        String line;
        HashMap<String, StorableDateTimeZone> result = new HashMap<String, StorableDateTimeZone>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        ArrayList<String> aliasLines = new ArrayList<String>();
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            int index = line.indexOf(32);
            String string = line.substring(0, index);
            String data = line.substring(index + 1);
            CharFlow flow = new CharFlow(data.toCharArray());
            if (Base46.decodeUnsigned(flow) == 4) {
                aliasLines.add(line);
                continue;
            }
            result.put(string, StorableDateTimeZone.read(string, data));
        }
        HashMap<AliasDateTimeZone, String> unresolvedAliases = new HashMap<AliasDateTimeZone, String>();
        for (String string : aliasLines) {
            int index = string.indexOf(32);
            String id = string.substring(0, index);
            String data = string.substring(index + 1);
            CharFlow flow = new CharFlow(data.toCharArray());
            Base46.decode(flow);
            String targetId = data.substring(flow.pointer);
            AliasDateTimeZone tz = new AliasDateTimeZone(id, (DateTimeZone)result.get(targetId));
            result.put(id, tz);
            if (tz.innerZone != null) continue;
            unresolvedAliases.put(tz, targetId);
        }
        for (Map.Entry entry : unresolvedAliases.entrySet()) {
            ((AliasDateTimeZone)entry.getKey()).innerZone = (DateTimeZone)result.get(entry.getValue());
            if (((AliasDateTimeZone)entry.getKey()).innerZone != null) continue;
            ((AliasDateTimeZone)entry.getKey()).innerZone = new FixedDateTimeZone((String)entry.getValue(), 0, 0);
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        ZoneInfoCompiler compiler = new ZoneInfoCompiler();
        TimeZoneGenerator.compile(compiler, TimeZoneCache.class.getClassLoader());
        File file = new File(args[0]);
        file.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(file);){
            new TimeZoneCache().write(output, compiler.compile().values());
        }
    }
}

