/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.teavm.classlib.impl.unicode.CLDRCurrency;
import org.teavm.classlib.impl.unicode.CLDRDateFormats;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRTimeZone;
import org.teavm.common.json.JsonConsumer;
import org.teavm.common.json.JsonObjectValue;
import org.teavm.common.json.JsonParser;
import org.teavm.common.json.JsonValue;
import org.teavm.common.json.JsonValueParserVisitor;
import org.teavm.common.json.JsonValueProvider;
import org.teavm.common.json.JsonVisitingConsumer;
import org.teavm.common.json.JsonVisitor;

public class CLDRReader {
    private static final String[] weekdayKeys = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    private static CLDRReader lastInstance;
    private Map<String, CLDRLocale> knownLocales = new LinkedHashMap<String, CLDRLocale>();
    private Map<String, Integer> minDaysMap = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> firstDayMap = new LinkedHashMap<String, Integer>();
    private Map<String, String> likelySubtags = new LinkedHashMap<String, String>();
    private Set<String> availableLocales = new LinkedHashSet<String>();
    private Set<String> availableLanguages = new LinkedHashSet<String>();
    private Set<String> availableCountries = new LinkedHashSet<String>();
    private boolean initialized;
    private ClassLoader classLoader;
    private String availableLocalesString;

    private CLDRReader(ClassLoader classLoader, String availableLocalesString) {
        this.classLoader = classLoader;
        this.availableLocalesString = availableLocalesString;
    }

    public static CLDRReader getInstance(Properties properties, ClassLoader classLoader) {
        String availableLocalesString = properties.getProperty("java.util.Locale.available", "en_EN").trim();
        if (lastInstance == null || !CLDRReader.lastInstance.availableLocalesString.equals(availableLocalesString) || CLDRReader.lastInstance.classLoader != classLoader) {
            lastInstance = new CLDRReader(classLoader, availableLocalesString);
        }
        return lastInstance;
    }

    private synchronized void ensureInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.findAvailableLocales();
            this.readCLDR(this.classLoader);
        }
    }

    private void findAvailableLocales() {
        for (String locale : Arrays.asList(this.availableLocalesString.split(" *, *"))) {
            int countryIndex = locale.indexOf(95);
            if (countryIndex > 0) {
                String language = locale.substring(0, countryIndex);
                String country = locale.substring(countryIndex + 1);
                this.availableLocales.add(language + "-" + country);
                this.availableLocales.add(language);
                this.availableLanguages.add(language);
                this.availableCountries.add(country);
                continue;
            }
            this.availableLocales.add(locale);
            this.availableLanguages.add(locale);
        }
    }

    private void readCLDR(ClassLoader classLoader) {
        try (ZipInputStream input = new ZipInputStream(new BufferedInputStream(classLoader.getResourceAsStream("org/teavm/classlib/impl/unicode/cldr-json.zip")));){
            ZipEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                int objectIndex;
                if (!entry.getName().endsWith(".json")) continue;
                if (entry.getName().equals("supplemental/weekData.json")) {
                    this.readWeekData(input);
                    continue;
                }
                if (entry.getName().equals("supplemental/likelySubtags.json")) {
                    this.readLikelySubtags(input);
                }
                if ((objectIndex = entry.getName().lastIndexOf(47)) < 0) continue;
                String objectName = entry.getName().substring(objectIndex + 1);
                String localeName = entry.getName().substring(0, objectIndex);
                if (localeName.startsWith("/")) {
                    localeName = localeName.substring(1);
                }
                if (!localeName.equals("root") && !this.availableLocales.contains(localeName)) continue;
                CLDRLocale localeInfo = this.knownLocales.get(localeName);
                if (localeInfo == null) {
                    localeInfo = new CLDRLocale();
                    this.knownLocales.put(localeName, localeInfo);
                }
                switch (objectName) {
                    case "languages.json": {
                        this.readLanguages(localeName, localeInfo, input);
                        break;
                    }
                    case "territories.json": {
                        this.readCountries(localeName, localeInfo, input);
                        break;
                    }
                    case "timeZoneNames.json": {
                        this.readTimeZones(localeName, localeInfo, input);
                        break;
                    }
                    case "ca-gregorian.json": {
                        JsonObjectValue root = (JsonObjectValue)this.parse(input);
                        this.readEras(localeName, localeInfo, root);
                        this.readAmPms(localeName, localeInfo, root);
                        this.readMonths(localeName, localeInfo, root);
                        this.readShortMonths(localeName, localeInfo, root);
                        this.readWeekdays(localeName, localeInfo, root);
                        this.readShortWeekdays(localeName, localeInfo, root);
                        this.readDateFormats(localeName, localeInfo, root);
                        this.readTimeFormats(localeName, localeInfo, root);
                        this.readDateTimeFormats(localeName, localeInfo, root);
                        break;
                    }
                    case "currencies.json": {
                        this.readCurrencies(localeName, localeInfo, input);
                        break;
                    }
                    case "numbers.json": {
                        this.readNumbers(localeName, localeInfo, input);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading CLDR file", e);
        }
    }

    private void readLanguages(String localeCode, CLDRLocale locale, InputStream input) {
        JsonObjectValue root = this.parse(input).asObject();
        JsonObjectValue languagesJson = root.get("main").asObject().get(localeCode).asObject().get("localeDisplayNames").asObject().get("languages").asObject();
        for (Map.Entry property : languagesJson.entrySet()) {
            String language = (String)property.getKey();
            if (!this.availableLanguages.contains(language)) continue;
            locale.languages.put(language, ((JsonValue)property.getValue()).asString());
        }
    }

    private void readCountries(String localeCode, CLDRLocale locale, InputStream input) {
        JsonObjectValue root = this.parse(input).asObject();
        JsonObjectValue countriesJson = root.get("main").asObject().get(localeCode).asObject().get("localeDisplayNames").asObject().get("territories").asObject();
        for (Map.Entry property : countriesJson.entrySet()) {
            String country = (String)property.getKey();
            if (!this.availableCountries.contains(country)) continue;
            locale.territories.put(country, ((JsonValue)property.getValue()).asString());
        }
    }

    private void readTimeZones(String localeCode, CLDRLocale locale, InputStream input) {
        JsonObjectValue root = this.parse(input).asObject();
        JsonObjectValue zonesJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("timeZoneNames").asObject().get("zone").asObject();
        ArrayList<CLDRTimeZone> timeZones = new ArrayList<CLDRTimeZone>();
        for (Map.Entry area : zonesJson.entrySet()) {
            String areaName = (String)area.getKey();
            for (Map.Entry location : ((JsonValue)area.getValue()).asObject().entrySet()) {
                String locationName = (String)location.getKey();
                JsonValue city = ((JsonValue)location.getValue()).asObject().get("exemplarCity");
                if (city != null) {
                    CLDRTimeZone tz = new CLDRTimeZone(areaName, locationName, city.asString());
                    timeZones.add(tz);
                    continue;
                }
                for (Map.Entry sublocation : ((JsonValue)location.getValue()).asObject().entrySet()) {
                    city = ((JsonValue)location.getValue()).asObject().get("exemplarCity");
                    if (city == null) continue;
                    CLDRTimeZone tz = new CLDRTimeZone(areaName, locationName + "/" + (String)sublocation.getKey(), city.asString());
                    timeZones.add(tz);
                }
            }
        }
        locale.timeZones = timeZones.toArray(new CLDRTimeZone[timeZones.size()]);
    }

    private void readCurrencies(String localeCode, CLDRLocale locale, InputStream input) {
        JsonObjectValue root = this.parse(input).asObject();
        JsonObjectValue currenciesJson = root.get("main").asObject().get(localeCode).asObject().get("numbers").asObject().get("currencies").asObject();
        for (Map.Entry currencyEntry : currenciesJson.entrySet()) {
            String currencyCode = (String)currencyEntry.getKey();
            JsonObjectValue currencyJson = ((JsonValue)currencyEntry.getValue()).asObject();
            CLDRCurrency currency = new CLDRCurrency();
            currency.name = currencyJson.get("displayName").asString();
            if (currencyJson.has("symbol")) {
                currency.symbol = currencyJson.get("symbol").asString();
            }
            locale.currencies.put(currencyCode, currency);
        }
    }

    private void readNumbers(String localeCode, CLDRLocale locale, InputStream input) {
        JsonObjectValue root = this.parse(input).asObject();
        JsonObjectValue numbersJson = root.get("main").asObject().get(localeCode).asObject().get("numbers").asObject();
        String numbering = numbersJson.get("defaultNumberingSystem").asString();
        JsonObjectValue symbolsJson = numbersJson.get("symbols-numberSystem-" + numbering).asObject();
        locale.decimalData.decimalSeparator = symbolsJson.get("decimal").asString().charAt(0);
        locale.decimalData.groupingSeparator = symbolsJson.get("group").asString().charAt(0);
        locale.decimalData.listSeparator = symbolsJson.get("list").asString().charAt(0);
        locale.decimalData.percent = symbolsJson.get("percentSign").asString().charAt(0);
        locale.decimalData.minusSign = symbolsJson.get("minusSign").asString().charAt(0);
        locale.decimalData.exponentSeparator = symbolsJson.get("exponential").asString();
        locale.decimalData.perMille = symbolsJson.get("perMille").asString().charAt(0);
        locale.decimalData.infinity = symbolsJson.get("infinity").asString();
        locale.decimalData.nan = symbolsJson.get("nan").asString();
        JsonObjectValue numberJson = numbersJson.get("decimalFormats-numberSystem-" + numbering).asObject();
        locale.numberFormat = numberJson.get("standard").asString();
        JsonObjectValue percentJson = numbersJson.get("percentFormats-numberSystem-" + numbering).asObject();
        locale.percentFormat = percentJson.get("standard").asString();
        JsonObjectValue currencyJson = numbersJson.get("currencyFormats-numberSystem-" + numbering).asObject();
        locale.currencyFormat = currencyJson.get("standard").asString();
    }

    private void readEras(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue erasJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("eras").asObject().get("eraAbbr").asObject();
        String bc = erasJson.get("0").asString();
        String ac = erasJson.get("1").asString();
        locale.eras = new String[]{bc, ac};
    }

    private void readAmPms(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue ampmJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("dayPeriods").asObject().get("format").asObject().get("abbreviated").asObject();
        String am = ampmJson.get("am").asString();
        String pm = ampmJson.get("pm").asString();
        locale.dayPeriods = new String[]{am, pm};
    }

    private void readMonths(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue monthsJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("months").asObject().get("format").asObject().get("wide").asObject();
        locale.months = new String[12];
        for (int i = 0; i < 12; ++i) {
            locale.months[i] = monthsJson.get(String.valueOf(i + 1)).asString();
        }
    }

    private void readShortMonths(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue monthsJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("months").asObject().get("format").asObject().get("abbreviated").asObject();
        locale.shortMonths = new String[12];
        for (int i = 0; i < 12; ++i) {
            locale.shortMonths[i] = monthsJson.get(String.valueOf(i + 1)).asString();
        }
    }

    private void readWeekdays(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue weekdaysJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("days").asObject().get("format").asObject().get("wide").asObject();
        locale.weekdays = new String[7];
        for (int i = 0; i < 7; ++i) {
            locale.weekdays[i] = weekdaysJson.get(weekdayKeys[i]).asString();
        }
    }

    private void readShortWeekdays(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue weekdaysJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("days").asObject().get("format").asObject().get("abbreviated").asObject();
        locale.shortWeekdays = new String[7];
        for (int i = 0; i < 7; ++i) {
            locale.shortWeekdays[i] = weekdaysJson.get(weekdayKeys[i]).asString();
        }
    }

    private void readDateFormats(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue formatsJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("dateFormats").asObject();
        locale.dateFormats = new CLDRDateFormats(formatsJson.get("short").asString(), formatsJson.get("medium").asString(), formatsJson.get("long").asString(), formatsJson.get("full").asString());
    }

    private void readTimeFormats(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue formatsJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("timeFormats").asObject();
        locale.timeFormats = new CLDRDateFormats(formatsJson.get("short").asString(), formatsJson.get("medium").asString(), formatsJson.get("long").asString(), formatsJson.get("full").asString());
    }

    private void readDateTimeFormats(String localeCode, CLDRLocale locale, JsonObjectValue root) {
        JsonObjectValue formatsJson = root.get("main").asObject().get(localeCode).asObject().get("dates").asObject().get("calendars").asObject().get("gregorian").asObject().get("dateTimeFormats").asObject();
        locale.dateTimeFormats = new CLDRDateFormats(formatsJson.get("short").asString(), formatsJson.get("medium").asString(), formatsJson.get("long").asString(), formatsJson.get("full").asString());
    }

    private void readWeekData(InputStream input) {
        JsonObjectValue root = this.parse(input).asObject();
        JsonObjectValue weekJson = root.get("supplemental").asObject().get("weekData").asObject();
        JsonObjectValue minDaysJson = weekJson.get("minDays").asObject();
        for (Map.Entry property : minDaysJson.entrySet()) {
            this.minDaysMap.put((String)property.getKey(), Integer.parseInt(((JsonValue)property.getValue()).asString()));
        }
        JsonObjectValue firstDayJson = weekJson.get("firstDay").asObject();
        for (Map.Entry property : firstDayJson.entrySet()) {
            this.firstDayMap.put((String)property.getKey(), this.getNumericDay(((JsonValue)property.getValue()).asString()));
        }
    }

    private void readLikelySubtags(InputStream input) {
        JsonObjectValue root = this.parse(input).asObject();
        JsonObjectValue likelySubtagsJson = root.get("supplemental").asObject().get("likelySubtags").asObject();
        for (Map.Entry property : likelySubtagsJson.entrySet()) {
            this.likelySubtags.put((String)property.getKey(), ((JsonValue)property.getValue()).asString());
        }
    }

    private int getNumericDay(String day) {
        switch (day) {
            case "sun": {
                return 1;
            }
            case "mon": {
                return 2;
            }
            case "tue": {
                return 3;
            }
            case "wed": {
                return 4;
            }
            case "thu": {
                return 5;
            }
            case "fri": {
                return 6;
            }
            case "sat": {
                return 7;
            }
        }
        throw new IllegalArgumentException("Can't recognize day name: " + day);
    }

    public Map<String, CLDRLocale> getKnownLocales() {
        this.ensureInitialized();
        return Collections.unmodifiableMap(this.knownLocales);
    }

    public Set<String> getAvailableLocales() {
        this.ensureInitialized();
        return Collections.unmodifiableSet(this.availableLocales);
    }

    public Set<String> getAvailableLanguages() {
        this.ensureInitialized();
        return Collections.unmodifiableSet(this.availableLanguages);
    }

    public Set<String> getAvailableCountries() {
        this.ensureInitialized();
        return Collections.unmodifiableSet(this.availableCountries);
    }

    public Map<String, Integer> getMinDaysMap() {
        this.ensureInitialized();
        return Collections.unmodifiableMap(this.minDaysMap);
    }

    public Map<String, Integer> getFirstDayMap() {
        this.ensureInitialized();
        return Collections.unmodifiableMap(this.firstDayMap);
    }

    public Map<String, String> getLikelySubtags() {
        this.ensureInitialized();
        return Collections.unmodifiableMap(this.likelySubtags);
    }

    private JsonValue parse(InputStream input) {
        JsonValueProvider provider = new JsonValueProvider();
        JsonValueParserVisitor visitor = JsonValueParserVisitor.create((Consumer)provider);
        this.parse((JsonVisitor)visitor, input);
        return provider.getValue();
    }

    private void parse(JsonVisitor visitor, InputStream input) {
        JsonVisitingConsumer consumer = new JsonVisitingConsumer(visitor);
        JsonParser parser = new JsonParser((JsonConsumer)consumer);
        try {
            parser.parse((Reader)new InputStreamReader(input, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

