/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferImpl;

class TShortBufferOverArray
extends TShortBufferImpl {
    private boolean readOnly;
    private int start;
    private int capacity;
    private short[] array;

    TShortBufferOverArray(int capacity) {
        this(0, capacity, new short[capacity], 0, capacity, false);
    }

    TShortBufferOverArray(int start, int capacity, short[] array, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TShortBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TShortBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    short getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, short value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    short[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    void getImpl(int index, short[] dst, int offset, int length) {
        System.arraycopy(this.array, this.start + index, dst, offset, length);
    }

    @Override
    void putImpl(int index, short[] src, int offset, int length) {
        System.arraycopy(src, offset, this.array, this.start + index, length);
    }

    @Override
    void putImpl(int index, TShortBuffer src, int offset, int length) {
        if (src.hasArray()) {
            System.arraycopy(src.array(), src.arrayOffset() + offset, this.array, this.start + index, length);
        } else {
            while (length-- > 0) {
                src.putElement(offset++, this.getElement(index++));
            }
        }
    }
}

