/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.util.Arrays;
import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.java.text.TDateFormat;
import org.teavm.classlib.java.text.TDateFormatElement;
import org.teavm.classlib.java.text.TDateFormatSymbols;
import org.teavm.classlib.java.text.TFieldPosition;
import org.teavm.classlib.java.text.TParsePosition;
import org.teavm.classlib.java.text.TSimpleDatePatternParser;
import org.teavm.classlib.java.util.TCalendar;
import org.teavm.classlib.java.util.TDate;
import org.teavm.classlib.java.util.TGregorianCalendar;
import org.teavm.classlib.java.util.TLocale;

public class TSimpleDateFormat
extends TDateFormat {
    private TDateFormatSymbols dateFormatSymbols;
    private TDateFormatElement[] elements;
    private String pattern;
    private TLocale locale;

    public TSimpleDateFormat() {
        this(TSimpleDateFormat.getDefaultPattern());
    }

    private static String getDefaultPattern() {
        TLocale locale = TLocale.getDefault();
        return CLDRHelper.resolveDateFormats(locale.getLanguage(), locale.getCountry()).getMediumFormat();
    }

    public TSimpleDateFormat(String pattern) {
        this(pattern, TLocale.getDefault());
    }

    public TSimpleDateFormat(String pattern, TLocale locale) {
        this(pattern, new TDateFormatSymbols(locale));
        this.locale = locale;
    }

    public TSimpleDateFormat(String pattern, TDateFormatSymbols dateFormatSymbols) {
        this.dateFormatSymbols = (TDateFormatSymbols)dateFormatSymbols.clone();
        this.locale = TLocale.getDefault();
        this.applyPattern(pattern);
    }

    @Override
    public StringBuffer format(TDate date, StringBuffer buffer, TFieldPosition field) {
        TGregorianCalendar calendar = new TGregorianCalendar(this.locale);
        calendar.setTime(date);
        calendar.setTimeZone(this.calendar.getTimeZone());
        for (TDateFormatElement element : this.elements) {
            element.format(calendar, buffer);
        }
        return buffer;
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
        this.reparsePattern();
    }

    private void reparsePattern() {
        TSimpleDatePatternParser parser = new TSimpleDatePatternParser(this.dateFormatSymbols, this.locale);
        parser.parsePattern(this.pattern);
        this.elements = parser.getElements().toArray(new TDateFormatElement[0]);
    }

    @Override
    public TDate parse(String string, TParsePosition position) {
        TCalendar calendar = (TCalendar)this.calendar.clone();
        calendar.clear();
        for (TDateFormatElement element : this.elements) {
            if (position.getIndex() > string.length()) {
                position.setErrorIndex(position.getErrorIndex());
                return null;
            }
            element.parse(string, calendar, position);
            if (position.getErrorIndex() < 0) continue;
            return null;
        }
        return calendar.getTime();
    }

    @Override
    public Object clone() {
        TSimpleDateFormat copy = (TSimpleDateFormat)super.clone();
        copy.dateFormatSymbols = (TDateFormatSymbols)this.dateFormatSymbols.clone();
        copy.elements = (TDateFormatElement[])this.elements.clone();
        return copy;
    }

    public TDateFormatSymbols getDateFormatSymbols() {
        return (TDateFormatSymbols)this.dateFormatSymbols.clone();
    }

    public void setDateFormatSymbols(TDateFormatSymbols newFormatSymbols) {
        this.dateFormatSymbols = (TDateFormatSymbols)newFormatSymbols.clone();
        this.reparsePattern();
    }

    public String toPattern() {
        return this.pattern;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TSimpleDateFormat)) {
            return false;
        }
        TSimpleDateFormat other = (TSimpleDateFormat)object;
        if (!super.equals(other)) {
            return false;
        }
        return Arrays.equals(this.elements, other.elements) && this.dateFormatSymbols.equals(other.dateFormatSymbols) && this.locale.equals(other.locale);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(new int[]{super.hashCode(), this.dateFormatSymbols.hashCode(), Arrays.hashCode(this.elements), this.locale.hashCode()});
    }
}

