/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.util.TEnumeration;
import org.teavm.classlib.java.util.TNoSuchElementException;

public class TStringTokenizer
implements TEnumeration<Object> {
    private String string;
    private String delimiters;
    private boolean returnDelimiters;
    private int position;

    public TStringTokenizer(String string) {
        this(string, " \t\n\r\f", false);
    }

    public TStringTokenizer(String string, String delimiters) {
        this(string, delimiters, false);
    }

    public TStringTokenizer(String string, String delimiters, boolean returnDelimiters) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.string = string;
        this.delimiters = delimiters;
        this.returnDelimiters = returnDelimiters;
        this.position = 0;
    }

    public int countTokens() {
        int count = 0;
        boolean inToken = false;
        int length = this.string.length();
        for (int i = this.position; i < length; ++i) {
            if (this.delimiters.indexOf(this.string.charAt(i), 0) >= 0) {
                if (this.returnDelimiters) {
                    ++count;
                }
                if (!inToken) continue;
                ++count;
                inToken = false;
                continue;
            }
            inToken = true;
        }
        if (inToken) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int length = this.string.length();
        if (this.position < length) {
            if (this.returnDelimiters) {
                return true;
            }
            for (int i = this.position; i < length; ++i) {
                if (this.delimiters.indexOf(this.string.charAt(i), 0) != -1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int i = this.position;
        int length = this.string.length();
        if (i < length) {
            if (this.returnDelimiters) {
                if (this.delimiters.indexOf(this.string.charAt(this.position), 0) >= 0) {
                    return String.valueOf(this.string.charAt(this.position++));
                }
                ++this.position;
                while (this.position < length) {
                    if (this.delimiters.indexOf(this.string.charAt(this.position), 0) >= 0) {
                        return this.string.substring(i, this.position);
                    }
                    ++this.position;
                }
                return this.string.substring(i);
            }
            while (i < length && this.delimiters.indexOf(this.string.charAt(i), 0) >= 0) {
                ++i;
            }
            this.position = i;
            if (i < length) {
                ++this.position;
                while (this.position < length) {
                    if (this.delimiters.indexOf(this.string.charAt(this.position), 0) >= 0) {
                        return this.string.substring(i, this.position);
                    }
                    ++this.position;
                }
                return this.string.substring(i);
            }
        }
        throw new TNoSuchElementException();
    }

    public String nextToken(String delims) {
        this.delimiters = delims;
        return this.nextToken();
    }
}

