/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.util.concurrent.atomic.TAtomicIntegerFieldUpdater;

class TReflectionBasedAtomicIntegerFieldUpdater<T>
extends TAtomicIntegerFieldUpdater<T> {
    private TField field;

    TReflectionBasedAtomicIntegerFieldUpdater(TField field) {
        this.field = field;
    }

    @Override
    public boolean compareAndSet(T obj, int expect, int update) {
        this.checkInstance(obj);
        if ((Integer)this.field.getWithoutCheck(obj) != expect) {
            return false;
        }
        this.field.setWithoutCheck(obj, update);
        return true;
    }

    @Override
    public boolean weakCompareAndSet(T obj, int expect, int update) {
        return this.compareAndSet(obj, expect, update);
    }

    @Override
    public void set(T obj, int newValue) {
        this.checkInstance(obj);
        this.field.setWithoutCheck(obj, newValue);
    }

    @Override
    public void lazySet(T obj, int newValue) {
        this.set(obj, newValue);
    }

    @Override
    public int get(T obj) {
        this.checkInstance(obj);
        return (Integer)this.field.getWithoutCheck(obj);
    }

    private void checkInstance(T obj) {
        if (!this.field.getDeclaringClass().isInstance((TObject)obj)) {
            throw new ClassCastException();
        }
    }
}

