/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.util.Locale;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.IsoChronology;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.UnsupportedTemporalTypeException;
import org.threeten.bp.temporal.ValueRange;

public enum Month implements TemporalAccessor,
TemporalAdjuster
{
    JANUARY,
    FEBRUARY,
    MARCH,
    APRIL,
    MAY,
    JUNE,
    JULY,
    AUGUST,
    SEPTEMBER,
    OCTOBER,
    NOVEMBER,
    DECEMBER;

    public static final TemporalQuery<Month> FROM;
    private static final Month[] ENUMS;

    public static Month of(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid value for MonthOfYear: " + month);
        }
        return ENUMS[month - 1];
    }

    public static Month from(TemporalAccessor temporal) {
        if (temporal instanceof Month) {
            return (Month)temporal;
        }
        try {
            if (!IsoChronology.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = LocalDate.from(temporal);
            }
            return Month.of(temporal.get(ChronoField.MONTH_OF_YEAR));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain Month from TemporalAccessor: " + String.valueOf(temporal) + ", type " + temporal.getClass().getName(), ex);
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.MONTH_OF_YEAR, style).toFormatter(locale).format(this);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.MONTH_OF_YEAR;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + String.valueOf(field));
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + String.valueOf(field));
        }
        return field.getFrom(this);
    }

    public Month plus(long months) {
        int amount = (int)(months % 12L);
        return ENUMS[(this.ordinal() + (amount + 12)) % 12];
    }

    public Month minus(long months) {
        return this.plus(-(months % 12L));
    }

    public int length(boolean leapYear) {
        switch (this.ordinal()) {
            case 1: {
                return leapYear ? 29 : 28;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public int minLength() {
        switch (this.ordinal()) {
            case 1: {
                return 28;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public int maxLength() {
        switch (this.ordinal()) {
            case 1: {
                return 29;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public int firstDayOfYear(boolean leapYear) {
        int leap = leapYear ? 1 : 0;
        switch (this.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 32;
            }
            case 2: {
                return 60 + leap;
            }
            case 3: {
                return 91 + leap;
            }
            case 4: {
                return 121 + leap;
            }
            case 5: {
                return 152 + leap;
            }
            case 6: {
                return 182 + leap;
            }
            case 7: {
                return 213 + leap;
            }
            case 8: {
                return 244 + leap;
            }
            case 9: {
                return 274 + leap;
            }
            case 10: {
                return 305 + leap;
            }
        }
        return 335 + leap;
    }

    public Month firstMonthOfQuarter() {
        return ENUMS[this.ordinal() / 3 * 3];
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.MONTHS;
        }
        if (query == TemporalQueries.localDate() || query == TemporalQueries.localTime() || query == TemporalQueries.zone() || query == TemporalQueries.zoneId() || query == TemporalQueries.offset()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.MONTH_OF_YEAR, this.getValue());
    }

    static {
        FROM = new TemporalQuery<Month>(){

            @Override
            public Month queryFrom(TemporalAccessor temporal) {
                return Month.from(temporal);
            }
        };
        ENUMS = Month.values();
    }
}

