/*
 *  Copyright 2013 Alexey Andreev.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.teavm.classlib.java.io;

public class TFilterOutputStream extends TOutputStream {
    protected TOutputStream out;

    public TFilterOutputStream(TOutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws TIOException {
        out.write(b);
    }

    @Override
    public void close() throws TIOException {
        try {
            out.flush();
        } catch (TIOException e) {
            // do nothing
        }
        out.close();
    }

    @Override
    public void flush() throws TIOException {
        out.flush();
    }
}
