/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.NumericOperandType;

public class NumericClassTransformer
implements ClassHolderTransformer {
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        switch (cls.getName()) {
            case "java.lang.Integer": {
                this.transformInteger(cls);
                break;
            }
            case "java.lang.Long": {
                this.transformLong(cls);
                break;
            }
            case "java.lang.Float": {
                this.transformFloat(cls);
                break;
            }
            case "java.lang.Double": {
                this.transformDouble(cls);
            }
        }
    }

    private void transformInteger(ClassHolder cls) {
        this.transformCompareMethod(cls, (ValueType)ValueType.INTEGER, NumericOperandType.INT);
    }

    private void transformLong(ClassHolder cls) {
        this.transformCompareMethod(cls, (ValueType)ValueType.LONG, NumericOperandType.LONG);
    }

    private void transformFloat(ClassHolder cls) {
        this.transformCompareMethod(cls, (ValueType)ValueType.FLOAT, NumericOperandType.FLOAT);
    }

    private void transformDouble(ClassHolder cls) {
        this.transformCompareMethod(cls, (ValueType)ValueType.DOUBLE, NumericOperandType.DOUBLE);
    }

    private void transformCompareMethod(ClassHolder cls, ValueType type, NumericOperandType insnType) {
        MethodHolder method = cls.getMethod(new MethodDescriptor("compare", new ValueType[]{type, type, ValueType.INTEGER}));
        Program program = new Program();
        program.createVariable();
        Variable firstArg = program.createVariable();
        Variable secondArg = program.createVariable();
        Variable result = program.createVariable();
        BasicBlock block = program.createBasicBlock();
        BinaryInstruction insn = new BinaryInstruction(BinaryOperation.COMPARE, insnType);
        insn.setFirstOperand(firstArg);
        insn.setSecondOperand(secondArg);
        insn.setReceiver(result);
        block.add((Instruction)insn);
        ExitInstruction exit = new ExitInstruction();
        exit.setValueToReturn(result);
        block.add((Instruction)exit);
        method.setProgram(program);
        method.getModifiers().remove(ElementModifier.NATIVE);
    }
}

