/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCharSequence;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TDouble;
import org.teavm.classlib.java.lang.TFloat;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuffer;
import org.teavm.classlib.java.lang.TStringIndexOutOfBoundsException;
import org.teavm.classlib.java.util.TArrays;

class TAbstractStringBuilder
extends TObject
implements TSerializable,
TCharSequence {
    private static final float[] powersOfTen = new float[]{10.0f, 100.0f, 10000.0f, 1.0E8f, 1.0E16f, 1.0E32f};
    private static final double[] doublePowersOfTen = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final float[] negPowersOfTen = new float[]{0.1f, 0.01f, 1.0E-4f, 1.0E-8f, 1.0E-16f, 1.0E-32f};
    private static final double[] negDoublePowersOfTen = new double[]{0.1, 0.01, 1.0E-4, 1.0E-8, 1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
    private static final int[] intPowersOfTen = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final long[] longPowersOfTen = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final long[] longLogPowersOfTen = new long[]{1L, 10L, 100L, 10000L, 100000000L, 10000000000000000L};
    private static final int FLOAT_DECIMAL_PRECISION = 7;
    private static final int DOUBLE_DECIMAL_PRECISION = 16;
    private static final float FLOAT_DECIMAL_FACTOR = 1000000.0f;
    private static final double DOUBLE_DECIMAL_FACTOR = 1.0E15;
    private static final int FLOAT_MAX_EXPONENT = 38;
    private static final int DOUBLE_MAX_EXPONENT = 308;
    private static final int FLOAT_MAX_POS = 1000000;
    private static final long DOUBLE_MAX_POS = 1000000000000000L;
    char[] buffer;
    private int length;

    public TAbstractStringBuilder() {
        this(16);
    }

    public TAbstractStringBuilder(int capacity) {
        this.buffer = new char[capacity];
    }

    public TAbstractStringBuilder(TString value) {
        this((TCharSequence)value);
    }

    public TAbstractStringBuilder(TCharSequence value) {
        this.buffer = new char[value.length()];
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = value.charAt(i);
        }
        this.length = value.length();
    }

    protected TAbstractStringBuilder append(TString string) {
        return this.insert(this.length, string);
    }

    protected TAbstractStringBuilder insert(int index, TString string) {
        if (index < 0 || index > this.length) {
            throw new TStringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = TString.wrap("null");
        } else if (string.isEmpty()) {
            return this;
        }
        this.ensureCapacity(this.length + string.length());
        for (int i = this.length - 1; i >= index; --i) {
            this.buffer[i + string.length()] = this.buffer[i];
        }
        this.length += string.length();
        int j = index;
        for (int i = 0; i < string.length(); ++i) {
            this.buffer[j++] = string.charAt(i);
        }
        return this;
    }

    protected TAbstractStringBuilder append(int value) {
        return this.append(value, 10);
    }

    protected TAbstractStringBuilder insert(int index, int value) {
        return this.insert(index, value, 10);
    }

    TAbstractStringBuilder append(int value, int radix) {
        return this.insert(this.length, value, radix);
    }

    TAbstractStringBuilder insert(int target, int value, int radix) {
        boolean positive = true;
        if (value < 0) {
            positive = false;
            value = -value;
        }
        if (value < radix) {
            if (!positive) {
                this.insertSpace(target, target + 2);
                this.buffer[target++] = 45;
            } else {
                this.insertSpace(target, target + 1);
            }
            this.buffer[target++] = TCharacter.forDigit(value, radix);
        } else {
            int pos = 1;
            int sz = 1;
            int posLimit = Integer.MAX_VALUE / radix;
            while (pos * radix <= value) {
                ++sz;
                if ((pos *= radix) <= posLimit) continue;
            }
            if (!positive) {
                ++sz;
            }
            this.insertSpace(target, target + sz);
            if (!positive) {
                this.buffer[target++] = 45;
            }
            while (pos > 0) {
                this.buffer[target++] = TCharacter.forDigit(value / pos, radix);
                value %= pos;
                pos /= radix;
            }
        }
        return this;
    }

    protected TAbstractStringBuilder append(long value) {
        return this.insert(this.length, value);
    }

    protected TAbstractStringBuilder insert(int target, long value) {
        return this.insert(target, value, 10);
    }

    protected TAbstractStringBuilder insert(int target, long value, int radix) {
        boolean positive = true;
        if (value < 0L) {
            positive = false;
            value = -value;
        }
        if (value < (long)radix) {
            if (!positive) {
                this.insertSpace(target, target + 2);
                this.buffer[target++] = 45;
            } else {
                this.insertSpace(target, target + 1);
            }
            this.buffer[target++] = Character.forDigit((int)value, radix);
        } else {
            int sz = 1;
            long pos = 1L;
            while (pos * (long)radix > pos && pos * (long)radix <= value) {
                pos *= (long)radix;
                ++sz;
            }
            if (!positive) {
                ++sz;
            }
            this.insertSpace(target, target + sz);
            if (!positive) {
                this.buffer[target++] = 45;
            }
            while (pos > 0L) {
                this.buffer[target++] = TCharacter.forDigit((int)(value / pos), radix);
                value %= pos;
                pos /= (long)radix;
            }
        }
        return this;
    }

    protected TAbstractStringBuilder append(float value) {
        return this.insert(this.length, value);
    }

    protected TAbstractStringBuilder insert(int target, float value) {
        int i;
        float digit;
        int bit;
        if (value == 0.0f) {
            this.insertSpace(target, target + 3);
            this.buffer[target++] = 48;
            this.buffer[target++] = 46;
            this.buffer[target++] = 48;
            return this;
        }
        if (value == 0.0f) {
            this.insertSpace(target, target + 4);
            this.buffer[target++] = 45;
            this.buffer[target++] = 48;
            this.buffer[target++] = 46;
            this.buffer[target++] = 48;
            return this;
        }
        if (TFloat.isNaN(value)) {
            this.insertSpace(target, target + 3);
            this.buffer[target++] = 78;
            this.buffer[target++] = 97;
            this.buffer[target++] = 78;
            return this;
        }
        if (TFloat.isInfinite(value)) {
            if (value > 0.0f) {
                this.insertSpace(target, target + 8);
            } else {
                this.insertSpace(target, target + 9);
                this.buffer[target++] = 45;
            }
            this.buffer[target++] = 73;
            this.buffer[target++] = 110;
            this.buffer[target++] = 102;
            this.buffer[target++] = 105;
            this.buffer[target++] = 110;
            this.buffer[target++] = 105;
            this.buffer[target++] = 116;
            this.buffer[target++] = 121;
            return this;
        }
        boolean negative = false;
        int sz = 1;
        if (value < 0.0f) {
            negative = true;
            value = -value;
            ++sz;
        }
        int exp = 0;
        int mantissa = 0;
        int intPart = 1;
        int digits = 0;
        if (value >= 1.0f) {
            bit = 32;
            exp = 0;
            digit = 1.0f;
            for (i = powersOfTen.length - 1; i >= 0; --i) {
                if ((exp | bit) <= 38 && powersOfTen[i] * digit <= value) {
                    digit *= powersOfTen[i];
                    exp |= bit;
                }
                bit >>= 1;
            }
            mantissa = (int)(value / (digit / 1000000.0f) + 0.5f);
        } else {
            bit = 32;
            exp = 0;
            digit = 1.0f;
            for (i = negPowersOfTen.length - 1; i >= 0; --i) {
                if ((exp | bit) <= 38 && negPowersOfTen[i] * digit * 10.0f > value) {
                    digit *= negPowersOfTen[i];
                    exp |= bit;
                }
                bit >>= 1;
            }
            exp = -exp;
            mantissa = (int)(value * 1000000.0f / digit + 0.5f);
        }
        digits = 7;
        int zeros = TAbstractStringBuilder.trailingDecimalZeros(mantissa);
        if (zeros > 0) {
            digits -= zeros;
        }
        if (exp < 7 && exp >= -3) {
            if (exp >= 0) {
                intPart = exp + 1;
                digits = Math.max(digits, intPart + 1);
                exp = 0;
            } else if (exp < 0) {
                mantissa /= intPowersOfTen[-exp];
                digits -= exp;
                exp = 0;
            }
        }
        if (exp != 0) {
            sz += 2;
            if (exp <= -10 || exp >= 10) {
                ++sz;
            }
            if (exp < 0) {
                ++sz;
            }
        }
        if (exp != 0 && digits == intPart) {
            ++digits;
        }
        this.insertSpace(target, target + (sz += digits));
        if (negative) {
            this.buffer[target++] = 45;
        }
        int pos = 1000000;
        for (i = 0; i < digits; ++i) {
            int intDigit;
            if (pos > 0) {
                intDigit = mantissa / pos;
                mantissa %= pos;
            } else {
                intDigit = 0;
            }
            this.buffer[target++] = (char)(48 + intDigit);
            if (--intPart == 0) {
                this.buffer[target++] = 46;
            }
            pos /= 10;
        }
        if (exp != 0) {
            this.buffer[target++] = 69;
            if (exp < 0) {
                exp = -exp;
                this.buffer[target++] = 45;
            }
            if (exp >= 10) {
                this.buffer[target++] = (char)(48 + exp / 10);
            }
            this.buffer[target++] = (char)(48 + exp % 10);
        }
        return this;
    }

    protected TAbstractStringBuilder append(double value) {
        return this.insert(this.length, value);
    }

    protected TAbstractStringBuilder insert(int target, double value) {
        int i;
        double digit;
        int bit;
        if (value == 0.0) {
            this.insertSpace(target, target + 3);
            this.buffer[target++] = 48;
            this.buffer[target++] = 46;
            this.buffer[target++] = 48;
            return this;
        }
        if (value == 0.0) {
            this.insertSpace(target, target + 4);
            this.buffer[target++] = 45;
            this.buffer[target++] = 48;
            this.buffer[target++] = 46;
            this.buffer[target++] = 48;
            return this;
        }
        if (TDouble.isNaN(value)) {
            this.insertSpace(target, target + 3);
            this.buffer[target++] = 78;
            this.buffer[target++] = 97;
            this.buffer[target++] = 78;
            return this;
        }
        if (TDouble.isInfinite(value)) {
            if (value > 0.0) {
                this.insertSpace(target, target + 8);
            } else {
                this.insertSpace(target, target + 9);
                this.buffer[target++] = 45;
            }
            this.buffer[target++] = 73;
            this.buffer[target++] = 110;
            this.buffer[target++] = 102;
            this.buffer[target++] = 105;
            this.buffer[target++] = 110;
            this.buffer[target++] = 105;
            this.buffer[target++] = 116;
            this.buffer[target++] = 121;
            return this;
        }
        boolean negative = false;
        int sz = 1;
        if (value < 0.0) {
            negative = true;
            value = -value;
            ++sz;
        }
        int exp = 0;
        long mantissa = 0L;
        int intPart = 1;
        int digits = 0;
        if (value >= 1.0) {
            bit = 256;
            exp = 0;
            digit = 1.0;
            for (i = doublePowersOfTen.length - 1; i >= 0; --i) {
                if ((exp | bit) <= 308 && doublePowersOfTen[i] * digit <= value) {
                    digit *= doublePowersOfTen[i];
                    exp |= bit;
                }
                bit >>= 1;
            }
            mantissa = (long)(value / digit * 1.0E15 + 0.5);
        } else {
            bit = 256;
            exp = 0;
            digit = 1.0;
            for (i = negDoublePowersOfTen.length - 1; i >= 0; --i) {
                if ((exp | bit) <= 308 && negDoublePowersOfTen[i] * digit * 10.0 > value) {
                    digit *= negDoublePowersOfTen[i];
                    exp |= bit;
                }
                bit >>= 1;
            }
            exp = -exp;
            mantissa = (long)(value * 1.0E15 / digit + 0.5);
        }
        digits = 16;
        int zeros = TAbstractStringBuilder.trailingDecimalZeros(mantissa);
        if (zeros > 0) {
            digits -= zeros;
        }
        if (exp < 7 && exp >= -3) {
            if (exp >= 0) {
                intPart = exp + 1;
                digits = Math.max(digits, intPart + 1);
                exp = 0;
            } else if (exp < 0) {
                mantissa /= longPowersOfTen[-exp];
                digits -= exp;
                exp = 0;
            }
        }
        if (exp != 0) {
            sz += 2;
            if (exp <= -10 || exp >= 10) {
                ++sz;
            }
            if (exp <= -100 || exp >= 100) {
                ++sz;
            }
            if (exp < 0) {
                ++sz;
            }
        }
        if (exp != 0 && digits == intPart) {
            ++digits;
        }
        this.insertSpace(target, target + (sz += digits));
        if (negative) {
            this.buffer[target++] = 45;
        }
        long pos = 1000000000000000L;
        for (i = 0; i < digits; ++i) {
            int intDigit;
            if (pos > 0L) {
                intDigit = (int)(mantissa / pos);
                mantissa %= pos;
            } else {
                intDigit = 0;
            }
            this.buffer[target++] = (char)(48 + intDigit);
            if (--intPart == 0) {
                this.buffer[target++] = 46;
            }
            pos /= 10L;
        }
        if (exp != 0) {
            this.buffer[target++] = 69;
            if (exp < 0) {
                exp = -exp;
                this.buffer[target++] = 45;
            }
            if (exp >= 100) {
                this.buffer[target++] = (char)(48 + exp / 100);
                this.buffer[target++] = (char)(48 + (exp %= 100) / 10);
            } else if (exp >= 10) {
                this.buffer[target++] = (char)(48 + exp / 10);
            }
            this.buffer[target++] = (char)(48 + exp % 10);
        }
        return this;
    }

    private static int trailingDecimalZeros(int n) {
        if (n % 1000000000 == 0) {
            return 9;
        }
        int result = 0;
        int zeros = 1;
        if (n % 100000000 == 0) {
            result |= 8;
            zeros *= 100000000;
        }
        if (n % (zeros * 10000) == 0) {
            result |= 4;
            zeros *= 10000;
        }
        if (n % (zeros * 100) == 0) {
            result |= 2;
            zeros *= 100;
        }
        if (n % (zeros * 10) == 0) {
            result |= 1;
        }
        return result;
    }

    private static int trailingDecimalZeros(long n) {
        long zeros = 1L;
        int result = 0;
        int bit = 16;
        for (int i = longLogPowersOfTen.length - 1; i >= 0; --i) {
            if (n % (zeros * longLogPowersOfTen[i]) == 0L) {
                result |= bit;
                zeros *= longLogPowersOfTen[i];
            }
            bit >>>= 1;
        }
        return result;
    }

    protected TAbstractStringBuilder append(char c) {
        return this.insert(this.length, c);
    }

    protected TAbstractStringBuilder insert(int index, char c) {
        this.insertSpace(index, index + 1);
        this.buffer[index++] = c;
        return this;
    }

    protected TAbstractStringBuilder appendCodePoint(int codePoint) {
        if (codePoint < 65536) {
            return this.append((char)codePoint);
        }
        this.ensureCapacity(this.length + 2);
        this.buffer[this.length++] = TCharacter.highSurrogate(codePoint);
        this.buffer[this.length++] = TCharacter.lowSurrogate(codePoint);
        return this;
    }

    protected TAbstractStringBuilder append(TObject obj) {
        return this.insert(this.length, obj);
    }

    protected TAbstractStringBuilder insert(int index, TObject obj) {
        return this.insert(index, TString.wrap(obj != null ? obj.toString() : "null"));
    }

    protected TAbstractStringBuilder append(boolean b) {
        return this.insert(this.length, b);
    }

    protected TAbstractStringBuilder insert(int index, boolean b) {
        return this.insert(index, b ? TString.wrap("true") : TString.wrap("false"));
    }

    public void ensureCapacity(int capacity) {
        if (this.buffer.length >= capacity) {
            return;
        }
        int newLength = this.buffer.length < 0x3FFFFFFF ? Math.max(capacity, Math.max(this.buffer.length * 2, 5)) : Integer.MAX_VALUE;
        this.buffer = TArrays.copyOf(this.buffer, newLength);
    }

    public void trimToSize() {
        if (this.buffer.length > this.length) {
            this.buffer = TArrays.copyOf(this.buffer, this.length);
        }
    }

    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new TIndexOutOfBoundsException();
        }
        return this.buffer[index];
    }

    protected TAbstractStringBuilder append(TCharSequence s, int start, int end) {
        return this.insert(this.length, s, start, end);
    }

    protected TAbstractStringBuilder insert(int index, TCharSequence s, int start, int end) {
        if (start > end || end > s.length() || start < 0) {
            throw new TIndexOutOfBoundsException();
        }
        this.insertSpace(index, index + end - start);
        for (int i = start; i < end; ++i) {
            this.buffer[index++] = s.charAt(i);
        }
        return this;
    }

    protected TAbstractStringBuilder append(TCharSequence s) {
        return this.append(s, 0, s.length());
    }

    protected TAbstractStringBuilder append(TStringBuffer s) {
        return this.append((TCharSequence)s);
    }

    protected TAbstractStringBuilder insert(int index, TCharSequence s) {
        return this.insert(index, s, 0, s.length());
    }

    protected TAbstractStringBuilder append(char[] chars, int offset, int len) {
        return this.insert(this.length, chars, offset, len);
    }

    protected TAbstractStringBuilder insert(int index, char[] chars) {
        return this.insert(index, chars, 0, chars.length);
    }

    protected TAbstractStringBuilder insert(int index, char[] chars, int offset, int len) {
        this.insertSpace(index, index + len);
        len += offset;
        while (offset < len) {
            this.buffer[index++] = chars[offset++];
        }
        return this;
    }

    protected TAbstractStringBuilder append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    @Override
    public TCharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin > srcEnd) {
            throw new TIndexOutOfBoundsException(TString.wrap("Index out of bounds"));
        }
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = this.buffer[srcBegin++];
        }
    }

    public void setLength(int newLength) {
        this.length = newLength;
    }

    public TAbstractStringBuilder deleteCharAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new TStringIndexOutOfBoundsException();
        }
        --this.length;
        for (int i = index; i < this.length; ++i) {
            this.buffer[i] = this.buffer[i + 1];
        }
        return this;
    }

    public TAbstractStringBuilder delete(int start, int end) {
        if (start > end || start > this.length) {
            throw new TStringIndexOutOfBoundsException();
        }
        if (start == end) {
            return this;
        }
        int sz = this.length - end;
        this.length -= end - start;
        for (int i = 0; i < sz; ++i) {
            this.buffer[start++] = this.buffer[end++];
        }
        return this;
    }

    public TAbstractStringBuilder replace(int start, int end, TString str) {
        int oldSize = end - start;
        if (str.length() > oldSize) {
            this.insertSpace(end, start + str.length());
        } else if (str.length() < oldSize) {
            this.delete(start + str.length(), end);
        }
        for (int i = 0; i < str.length(); ++i) {
            this.buffer[start++] = str.charAt(i);
        }
        return this;
    }

    private void insertSpace(int start, int end) {
        int sz = this.length - start;
        this.ensureCapacity(this.length + end - start);
        for (int i = sz - 1; i >= 0; --i) {
            this.buffer[end + i] = this.buffer[start + i];
        }
        this.length += end - start;
    }

    public int indexOf(TString str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(TString str, int fromIndex) {
        int sz = this.length - str.length();
        block0: for (int i = fromIndex; i < sz; ++i) {
            for (int j = 0; j < str.length(); ++j) {
                if (this.buffer[i + j] != str.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOf(TString str) {
        return this.lastIndexOf(str, this.length + 1);
    }

    public int lastIndexOf(TString str, int fromIndex) {
        block0: for (int i = fromIndex; i >= 0; --i) {
            for (int j = 0; j < str.length(); ++j) {
                if (this.buffer[i + j] != str.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public TAbstractStringBuilder reverse() {
        int half = this.length / 2;
        for (int i = 0; i < half; ++i) {
            char tmp = this.buffer[i];
            this.buffer[i] = this.buffer[this.length - i - 1];
            this.buffer[this.length - i - 1] = tmp;
        }
        return this;
    }

    public TString substring(int from, int to) {
        if (from > to || from < 0 || to > this.length) {
            throw new TIndexOutOfBoundsException();
        }
        return new TString(this.buffer, from, to - from);
    }

    public TString substring(int from) {
        return this.substring(from, this.length);
    }

    public void setCharAt(int index, char ch) {
        if (index > this.length) {
            throw new TIndexOutOfBoundsException();
        }
        this.buffer[index] = ch;
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return TCharacter.offsetByCodePoints(this, index, codePointOffset);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return TCharacter.codePointCount(this, beginIndex, endIndex);
    }

    public int codePointAt(int index) {
        return TCharacter.codePointAt(this, index);
    }

    public int codePointBefore(int index) {
        return TCharacter.codePointBefore(this, index);
    }
}

